/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.meta;

import java.text.NumberFormat;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.util.Assert;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.meta.ProgressRefresher;

public class SyncProgressRefresher
implements ProgressRefresher {
    private static Log logger = LogFactory.getLog(SyncProgressRefresher.class);
    protected PageCache pageCache;

    public SyncProgressRefresher(String pageId) {
        Assert.notNull((Object)pageId, (String)ResManager.loadKDString((String)"pageId\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String)"SyncProgressRefresher_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.pageCache = new PageCache(pageId);
    }

    protected SyncProgressRefresher() {
    }

    @Override
    public int refresh(int i, int total) {
        ++i;
        try {
            if (this.pageCache.get("startprogress") != null) {
                float value = Math.min(100.0f, (float)(i + 1) * 100.0f / (float)(total + 1));
                String progress = SyncProgressRefresher.getNumberFormatter().format(value);
                this.pageCache.put("progress", progress);
                if (this.isStop()) {
                    return -1;
                }
            }
            return i;
        }
        catch (Throwable e) {
            logger.warn(e);
            return i;
        }
    }

    @Override
    public void reset() {
        this.pageCache.put("text", null);
    }

    @Override
    public void notifyError() {
        this.pageCache.put("text", ResManager.loadKDString((String)"\u540c\u6b65\u51fa\u73b0\u5f02\u5e38!", (String)"SyncProgressRefresher_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        this.pageCache.put("startprogress", "false");
        this.pageCache.put("progress", "100");
    }

    protected boolean isStop() {
        String startProgress = this.pageCache.get("startprogress");
        return !StringUtils.isBlank((String)startProgress) && "false".equals(startProgress);
    }

    protected static NumberFormat getNumberFormatter() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        return numberFormat;
    }
}

