/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.meta.build;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.isc.iscb.platform.core.meta.build.FormMetaDefine;
import kd.isc.iscb.platform.core.meta.build.container.BaseInfoPanel;
import kd.isc.iscb.platform.core.meta.build.container.EntryInfoPanel;
import kd.isc.iscb.platform.core.meta.build.container.Panel;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XBigIntFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XCheckBoxFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XComboFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XDecimalFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XIntegerFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XTextFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XTimeFieldCfg;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class FormMetaDefineUtil {
    public static final String BASE_INFO_PANEL = "base_info_flex";

    public static boolean hasPermission() {
        return D.x((Object)ContextUtil.getTenantProperty("isc_create_meta_data"));
    }

    public static FormMetaDefine newFormMetaDefine(DynamicObject dynamicObject) {
        DynamicObject app = dynamicObject.getDynamicObject("bizapp");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bizAppId", app.getString("id"));
        map.put("bizUnitId", dynamicObject.getString("bizunit"));
        map.put("formName", D.s((Object)dynamicObject.getString("name")));
        map.put("formNumber", D.s((Object)dynamicObject.getString("number")));
        map.put("entityId", D.s((Object)dynamicObject.getString("entityid")));
        FormMetaDefine formConfig = new FormMetaDefine(map);
        FormMetaDefineUtil.parseContainerCfg(dynamicObject, formConfig);
        return formConfig;
    }

    private static void parseContainerCfg(DynamicObject dynamicObject, FormMetaDefine formConfig) {
        Map<String, List<DynamicObject>> map = FormMetaDefineUtil.classifyObj(dynamicObject);
        ArrayList<Panel> panelArrayList = new ArrayList<Panel>(map.size());
        int index = 2;
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            Panel panel;
            if (entry.getKey().equals(BASE_INFO_PANEL)) {
                panel = new BaseInfoPanel();
                panel.setName(new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"FormMetaDefineUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0])));
                panel.setIndex(1);
            } else {
                EntryInfoPanel entryInfoPanel = new EntryInfoPanel();
                entryInfoPanel.setName(FormMetaDefineUtil.getEntryName(dynamicObject, entry.getKey()));
                entryInfoPanel.setEntryTableName(FormMetaDefineUtil.getEntryTableName(dynamicObject, entry.getKey()));
                panel = entryInfoPanel;
                panel.setIndex(index++);
            }
            panel.setKey(entry.getKey());
            panel.setHidden(Boolean.FALSE);
            List<XFieldCfg> fields = FormMetaDefineUtil.createFieldApCfgs(entry.getValue());
            panel.setXFields(fields);
            panelArrayList.add(panel);
        }
        formConfig.setPanelList(panelArrayList);
    }

    private static String getEntryTableName(DynamicObject dynamicObject, String key) {
        DynamicObjectCollection collections = dynamicObject.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject collection : collections) {
            if (!key.equals(collection.getString("field_number"))) continue;
            return D.s((Object)collection.getString("table_field"));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u8868\u540d\u4e3a\u7a7a\u3002", (String)"FormMetaDefineUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
    }

    private static LocaleString getEntryName(DynamicObject dynamicObject, String key) {
        DynamicObjectCollection collections = dynamicObject.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject collection : collections) {
            if (!key.equals(collection.getString("field_number"))) continue;
            return FormMetaDefineUtil.convert2LocaleName(collection.getString("field_desc"));
        }
        return FormMetaDefineUtil.convert2LocaleName(key);
    }

    private static List<XFieldCfg> createFieldApCfgs(List<DynamicObject> fieldSetting) {
        ArrayList<XFieldCfg> fieldApCfgs = new ArrayList<XFieldCfg>(fieldSetting.size());
        for (DynamicObject field : fieldSetting) {
            XFieldCfg cfg;
            String fieldType = field.getString("field_type");
            String fieldProperty = field.getString("field_info_tag");
            Map map = (Map)Json.toObject((String)fieldProperty);
            XFieldCfg fieldApCfg = null;
            if ("varchar".equals(fieldType)) {
                cfg = new XTextFieldCfg();
                ((XTextFieldCfg)cfg).setEditStyle(0);
                ((XTextFieldCfg)cfg).setDefValue(field.getString("field_defvalue"));
                if (map != null) {
                    ((XTextFieldCfg)cfg).setMaxLength(D.i(map.get("max_length")));
                }
                fieldApCfg = cfg;
            } else if ("int".equals(fieldType)) {
                cfg = new XIntegerFieldCfg();
                ((XIntegerFieldCfg)cfg).setDefValue(new BigDecimal(D.i((Object)field.getString("field_defvalue"))));
                fieldApCfg = cfg;
            } else if ("long".equals(fieldType)) {
                cfg = new XBigIntFieldCfg();
                ((XIntegerFieldCfg)cfg).setDefValue(new BigDecimal(D.l((Object)field.getString("field_defvalue"))));
                fieldApCfg = cfg;
            } else if ("decimal".equals(fieldType)) {
                cfg = new XDecimalFieldCfg();
                String s = D.s((Object)field.getString("field_defvalue"));
                if (s != null) {
                    ((XDecimalFieldCfg)cfg).setDefValue(new BigDecimal(s));
                }
                fieldApCfg = cfg;
            } else if ("time".equals(fieldType)) {
                cfg = new XTimeFieldCfg();
                ((XTimeFieldCfg)cfg).setTimeDefValue(D.s((Object)D.t((Object)field.getString("field_defvalue"))));
                fieldApCfg = cfg;
            } else if ("combo".equals(fieldType)) {
                cfg = new XComboFieldCfg();
                ((XComboFieldCfg)cfg).setDefValue(D.s((Object)field.getString("field_defvalue")));
                FormMetaDefineUtil.setComboItems(map, (XComboFieldCfg)cfg);
                fieldApCfg = cfg;
            } else if ("checkbox".equals(fieldType)) {
                cfg = new XCheckBoxFieldCfg();
                ((XCheckBoxFieldCfg)cfg).setDefValue(D.x((Object)field.getString("field_defvalue")));
                fieldApCfg = cfg;
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b%s", (String)"FormMetaDefineUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), fieldType));
            }
            fieldApCfg.setShowInList(D.x((Object)field.get("show_inlist")));
            fieldApCfg.setShowInSearch(D.x((Object)field.get("insearch")));
            fieldApCfg.setMustInput(D.x((Object)field.get("isrequired")));
            fieldApCfg.setIndex(field.getInt("seq"));
            fieldApCfg.setKey(field.getString("field_number"));
            fieldApCfg.setName(new LocaleString(field.getString("field_desc")));
            fieldApCfgs.add(fieldApCfg);
        }
        return fieldApCfgs;
    }

    private static void setComboItems(Map<String, Object> map, XComboFieldCfg cfg) {
        if (map == null) {
            return;
        }
        Map combMap = (Map)Json.toObject((String)D.s((Object)map.get("comb_setting")));
        if (combMap != null) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(combMap.size());
            int i = 0;
            for (Map.Entry entry : combMap.entrySet()) {
                comboItems.add(new ComboItem(i++, new LocaleString(D.s(entry.getValue())), (String)entry.getKey()));
            }
            cfg.setItems(comboItems);
        }
    }

    private static Map<String, List<DynamicObject>> classifyObj(DynamicObject dynamicObject) {
        LinkedHashMap<String, List<DynamicObject>> map = new LinkedHashMap<String, List<DynamicObject>>();
        DynamicObjectCollection collections = dynamicObject.getDynamicObjectCollection("treeentryentity");
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, String> fieldKeyMap = new HashMap<String, String>(collections.size());
        for (DynamicObject collection : collections) {
            fieldKeyMap.put(D.s((Object)collection.get("id")), D.s((Object)collection.get("field_number")));
            if (!"entries".equals(D.s((Object)collection.get("field_type")))) continue;
            ids.add(D.s((Object)collection.get("id")));
        }
        for (DynamicObject collection : collections) {
            ArrayList<DynamicObject> list;
            String panelSign = null;
            if (D.l((Object)collection.get("pid")) == 0L) {
                panelSign = BASE_INFO_PANEL;
                if (ids.contains(D.s((Object)collection.get("id")))) {
                    continue;
                }
            } else {
                panelSign = (String)fieldKeyMap.get(D.s((Object)collection.get("pid")));
            }
            if ((list = (ArrayList<DynamicObject>)map.get(panelSign)) == null) {
                list = new ArrayList<DynamicObject>();
            }
            list.add(collection);
            map.put(panelSign, list);
        }
        return map;
    }

    private static LocaleString convert2LocaleName(Object objName) {
        LocaleString formName = objName instanceof LocaleString ? (LocaleString)objName : new LocaleString("zh_CN", (String)objName);
        return formName;
    }

    public static List<XFieldCfg> getUpdateFields(List<XFieldCfg> fieldCfgLi, List<XFieldCfg> addFieldList) {
        ArrayList<XFieldCfg> updateFields = new ArrayList<XFieldCfg>();
        for (XFieldCfg xFieldCfg : fieldCfgLi) {
            if (addFieldList.contains(xFieldCfg)) continue;
            updateFields.add(xFieldCfg);
        }
        return updateFields;
    }
}

