/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.meta.build.help;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.operation.EntryOpParameter;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.entity.operation.OperationParameter;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.isc.iscb.platform.core.meta.build.FormMetaDefineUtil;
import kd.isc.iscb.platform.core.meta.build.container.EntryInfoPanel;
import kd.isc.iscb.platform.core.meta.build.container.Panel;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XFieldCfg;
import kd.isc.iscb.platform.core.meta.build.help.FieldCfgHelper;
import kd.isc.iscb.util.dt.D;

public class EntryPanelHelper {
    private EntityMetadata entityMeta;
    List<ControlAp<?>> ctrlAps;
    List<EntityItem<?>> entityItems;
    private Map<String, ControlAp<?>> ctrlApsMap = new HashMap(16);
    private Map<String, EntityItem<?>> entityItemsMap = new HashMap(16);
    private List<Operation> operations;

    public EntryPanelHelper(FormMetadata formMeta, EntityMetadata entityMetadata) {
        this.init(formMeta, entityMetadata);
    }

    private void init(FormMetadata formMeta, EntityMetadata entityMeta) {
        this.entityMeta = entityMeta;
        this.ctrlAps = formMeta.getItems();
        this.entityItems = entityMeta.getItems();
        for (ControlAp<?> controlAp : this.ctrlAps) {
            this.ctrlApsMap.put(controlAp.getKey(), controlAp);
        }
        for (EntityItem entityItem : this.entityItems) {
            this.entityItemsMap.put(entityItem.getKey(), entityItem);
        }
        this.operations = entityMeta.getRootEntity().getOperations();
    }

    private void updateAdvConAp(EntryInfoPanel cfg, AdvConAp advConAp, EntryAp entryAp) {
        advConAp.setName(cfg.getName());
        advConAp.setIndex(cfg.getIndex());
        advConAp.setHidden(cfg.isHidden());
        entryAp.setName(cfg.getName());
    }

    public void save(EntryInfoPanel cfg) {
        AdvConAp advConAp = (AdvConAp)this.ctrlApsMap.get(cfg.getKey());
        EntryAp entryAp = (EntryAp)this.ctrlApsMap.get(cfg.getEntryKey());
        if (advConAp != null && entryAp != null) {
            this.updateAdvConAp(cfg, advConAp, entryAp);
            List<XFieldCfg> fieldCfgLi = cfg.getXFields();
            this.deleteControlAp(fieldCfgLi, entryAp);
            ArrayList<XFieldCfg> needAddFieldCfgLi = new ArrayList<XFieldCfg>();
            for (XFieldCfg apCfg : fieldCfgLi) {
                if (this.ctrlApsMap.containsKey(apCfg.getKey())) continue;
                needAddFieldCfgLi.add(apCfg);
            }
            this.ctrlAps.addAll(FieldCfgHelper.createEntryFieldAps(needAddFieldCfgLi, entryAp.getId()));
            this.entityItems.addAll(FieldCfgHelper.createEntryFields(needAddFieldCfgLi, entryAp.getEntryId()));
            List<XFieldCfg> updateFields = FormMetaDefineUtil.getUpdateFields(fieldCfgLi, needAddFieldCfgLi);
            FieldCfgHelper.updateEntryFieldAps(updateFields, this.ctrlApsMap);
            FieldCfgHelper.updateField(updateFields, this.entityItemsMap);
        } else {
            this.createControlAp(cfg);
        }
    }

    private void deleteControlAp(List<XFieldCfg> fieldCfgLi, EntryAp entryAp) {
        ArrayList<String> iscFieldApCfgKey = new ArrayList<String>(fieldCfgLi.size());
        for (XFieldCfg cfg : fieldCfgLi) {
            iscFieldApCfgKey.add(cfg.getKey());
        }
        ArrayList<String> deleteFields = new ArrayList<String>();
        for (ControlAp value : entryAp.getItems()) {
            if (!(value instanceof EntryFieldAp) || iscFieldApCfgKey.contains(D.s((Object)value.getKey()))) continue;
            deleteFields.add(value.getKey());
        }
        if (deleteFields.isEmpty()) {
            return;
        }
        this.removeControlByKey(deleteFields);
    }

    private List<Operation> createOperations(EntryInfoPanel cfg, EntryEntity entryEntity) {
        ArrayList<Operation> opList = new ArrayList<Operation>(2);
        Operation newEntry = new Operation();
        newEntry.setId(Uuid16.create().toString());
        newEntry.setKey(cfg.getAddEntryOpKey());
        newEntry.setName(ResManager.getLocaleString((String)"\u65b0\u589e\u5206\u5f55", (String)"EntryPanelHelper_0", (String)"isc-iscb-platform-core"));
        newEntry.setOperationType("newentry");
        EntryOpParameter newOpParam = new EntryOpParameter();
        newOpParam.setEntryId(entryEntity.getId());
        newEntry.setParameter((OperationParameter)newOpParam);
        opList.add(newEntry);
        Operation deleteEntry = new Operation();
        deleteEntry.setId(Uuid16.create().toString());
        deleteEntry.setKey(cfg.getDelEntryOpKey());
        deleteEntry.setName(ResManager.getLocaleString((String)"\u5220\u9664\u5206\u5f55", (String)"EntryPanelHelper_1", (String)"isc-iscb-platform-core"));
        deleteEntry.setOperationType("deleteentry");
        EntryOpParameter delOpParam = new EntryOpParameter();
        delOpParam.setEntryId(entryEntity.getId());
        deleteEntry.setParameter((OperationParameter)delOpParam);
        opList.add(deleteEntry);
        return opList;
    }

    private EntryEntity createEntryEntity(EntryInfoPanel cfg, EntryAp entryAp) {
        EntryEntity entryEntity = new EntryEntity();
        entryEntity.setId(entryAp.getId());
        entryAp.setEntryId(entryEntity.getId());
        entryEntity.setKey(entryAp.getKey());
        entryEntity.setName(entryAp.getName());
        entryEntity.setParentId(this.entityMeta.getRootEntity().getId());
        entryEntity.setTableName(cfg.getEntryTableName());
        entryEntity.setDefaultRows(0);
        return entryEntity;
    }

    public void createControlAp(EntryInfoPanel cfg) {
        List<ControlAp<?>> advConAps = cfg.createAdvConAp();
        EntryAp entryAp = cfg.createEntryAp(advConAps);
        List<XFieldCfg> fieldCfgLi = cfg.getXFields();
        List<EntryFieldAp> entryFieldAps = FieldCfgHelper.createEntryFieldAps(fieldCfgLi, entryAp.getId());
        EntryEntity entryEntity = this.createEntryEntity(cfg, entryAp);
        List<Field<?>> fields = FieldCfgHelper.createEntryFields(fieldCfgLi, entryEntity.getId());
        List<Operation> opList = this.createOperations(cfg, entryEntity);
        this.ctrlAps.addAll(advConAps);
        this.ctrlAps.add((ControlAp<?>)entryAp);
        this.ctrlAps.addAll(entryFieldAps);
        this.entityItems.add((EntityItem<?>)entryEntity);
        this.entityItems.addAll(fields);
        this.operations.addAll(opList);
    }

    public void deleteAdvPanel(List<Panel> panelList) {
        ArrayList<String> str = new ArrayList<String>(panelList.size());
        for (Panel cfg : panelList) {
            if (!(cfg instanceof EntryInfoPanel)) continue;
            str.add(cfg.getKey());
        }
        ArrayList<String> needDeletePaneKey = new ArrayList<String>(panelList.size());
        for (ControlAp<?> ctrlAp : this.ctrlAps) {
            if (!(ctrlAp instanceof AdvConAp) || str.contains(ctrlAp.getKey())) continue;
            needDeletePaneKey.add(ctrlAp.getKey());
        }
        if (needDeletePaneKey.isEmpty()) {
            return;
        }
        for (String s : needDeletePaneKey) {
            ArrayList<String> needDeleteKeys = new ArrayList<String>();
            needDeleteKeys.add(s);
            needDeleteKeys.add(s + "_sumy");
            needDeleteKeys.add(s + "_tb");
            needDeleteKeys.add(s + "_tb_n");
            needDeleteKeys.add(s + "_tb_d");
            needDeleteKeys.add(s + "_chid");
            needDeleteKeys.add(s + "_e");
            ArrayList<String> needDeleteOperaKeys = new ArrayList<String>(2);
            needDeleteOperaKeys.add(s + "_e_add");
            needDeleteOperaKeys.add(s + "_e_del");
            this.removeOperationControl(needDeleteOperaKeys);
            EntryAp entryAp = (EntryAp)this.ctrlApsMap.get(s + "_e");
            ArrayList<String> needDeleteEntryFieldId = new ArrayList<String>(2);
            for (ControlAp item : entryAp.getItems()) {
                needDeleteEntryFieldId.add(item.getId());
            }
            this.removeControlByKey(needDeleteKeys);
            this.removeControlById(needDeleteEntryFieldId);
        }
    }

    private void removeControlByKey(List<String> needDeleteKeys) {
        this.removeCtrlApsControlByKey(needDeleteKeys);
        this.removeEntityControlByKey(needDeleteKeys);
    }

    private void removeControlById(List<String> needDeleteIds) {
        this.removeCtrlApsControlById(needDeleteIds);
        this.removeEntityControlById(needDeleteIds);
    }

    private void removeEntityControlByKey(List<String> needDeleteKeys) {
        Iterator<EntityItem<?>> entityItemIterator = this.entityItems.iterator();
        while (entityItemIterator.hasNext()) {
            EntityItem<?> ap = entityItemIterator.next();
            if (!needDeleteKeys.contains(ap.getKey())) continue;
            entityItemIterator.remove();
        }
    }

    private void removeEntityControlById(List<String> needDeleteIds) {
        Iterator<EntityItem<?>> entityItemIterator = this.entityItems.iterator();
        while (entityItemIterator.hasNext()) {
            EntityItem<?> ap = entityItemIterator.next();
            if (!needDeleteIds.contains(ap.getId())) continue;
            entityItemIterator.remove();
        }
    }

    private void removeOperationControl(List<String> needDeleteKeys) {
        Iterator<Operation> iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            Operation ap = iterator.next();
            if (!needDeleteKeys.contains(ap.getKey())) continue;
            iterator.remove();
        }
    }

    private void removeCtrlApsControlByKey(List<String> needDeleteKeys) {
        Iterator<ControlAp<?>> iterator = this.ctrlAps.iterator();
        while (iterator.hasNext()) {
            ControlAp<?> ap = iterator.next();
            if (!needDeleteKeys.contains(ap.getKey())) continue;
            iterator.remove();
        }
    }

    private void removeCtrlApsControlById(List<String> needDeleteId) {
        Iterator<ControlAp<?>> iterator = this.ctrlAps.iterator();
        while (iterator.hasNext()) {
            ControlAp<?> ap = iterator.next();
            if (!needDeleteId.contains(ap.getId())) continue;
            iterator.remove();
        }
    }
}

