/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.meta.build.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.util.CollectionUtils;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XBigIntFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XCheckBoxFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XComboFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XDecimalFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XIntegerFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XTextFieldCfg;
import kd.isc.iscb.platform.core.meta.build.fieldcfg.XTimeFieldCfg;
import kd.isc.iscb.util.except.IscBizException;

public class FieldCfgHelper {
    protected static List<Field<?>> createFields(List<XFieldCfg> xFieldCfgList) {
        ArrayList fields = new ArrayList(xFieldCfgList.size());
        for (XFieldCfg fieldCfg : xFieldCfgList) {
            Field<?> field = fieldCfg.createField();
            if (field == null) continue;
            fields.add(field);
        }
        return fields;
    }

    protected static void updateField(List<XFieldCfg> xFieldCfgList, Map<String, EntityItem<?>> entityItemsMap) {
        for (XFieldCfg fieldCfg : xFieldCfgList) {
            EntityItem<?> field = entityItemsMap.get(fieldCfg.getKey());
            Class<?> aClass = fieldCfg.getClass();
            Class<?> aClass_ = field.getClass();
            if (XTextFieldCfg.class == aClass && TextField.class == aClass_) {
                fieldCfg.updateField((Field<?>)((TextField)field));
                continue;
            }
            if (XDecimalFieldCfg.class == aClass && DecimalField.class == aClass_) {
                fieldCfg.updateField((Field<?>)((DecimalField)field));
                continue;
            }
            if (XIntegerFieldCfg.class == aClass && IntegerField.class == aClass_) {
                fieldCfg.updateField((Field<?>)((IntegerField)field));
                continue;
            }
            if (XBigIntFieldCfg.class == aClass && BigIntField.class == aClass_) {
                fieldCfg.updateField((Field<?>)((BigIntField)field));
                continue;
            }
            if (XComboFieldCfg.class == aClass && ComboField.class == aClass_) {
                fieldCfg.updateField((Field<?>)((ComboField)field));
                continue;
            }
            if (XTimeFieldCfg.class == aClass && DateTimeField.class == aClass_) {
                fieldCfg.updateField((Field<?>)((DateTimeField)field));
                continue;
            }
            if (XCheckBoxFieldCfg.class == aClass && CheckBoxField.class == aClass_) {
                fieldCfg.updateField((Field<?>)((CheckBoxField)field));
                continue;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u6807\u8bc6\u3010%s\u3011\u5f53\u524d\u914d\u7f6e\u7684\u5b57\u6bb5\u7c7b\u578b\u4e0e\u5143\u6570\u636e\u4e0a\u5df2\u6709\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"FieldCfgHelper_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), fieldCfg.getKey()));
        }
    }

    protected static void updateEntryFieldAps(List<XFieldCfg> xFieldCfgList, Map<String, ControlAp<?>> ctrlApsMap) {
        if (!CollectionUtils.isEmpty(xFieldCfgList)) {
            for (XFieldCfg fieldApCfg : xFieldCfgList) {
                EntryFieldAp fieldAp = (EntryFieldAp)ctrlApsMap.get(fieldApCfg.getKey());
                fieldApCfg.updateEntryFieldAps(fieldAp);
            }
        }
    }

    protected static List<Field<?>> createEntryFields(List<XFieldCfg> fieldCfgLi, String entryEntityId) {
        List<Field<?>> fields = FieldCfgHelper.createFields(fieldCfgLi);
        for (Field<?> field : fields) {
            field.setParentId(entryEntityId);
        }
        return fields;
    }

    protected static List<EntryFieldAp> createEntryFieldAps(List<XFieldCfg> xFieldCfgList, String entryApId) {
        if (CollectionUtils.isEmpty(xFieldCfgList)) {
            return Collections.emptyList();
        }
        ArrayList<EntryFieldAp> entryFieldAps = new ArrayList<EntryFieldAp>(xFieldCfgList.size());
        for (XFieldCfg fieldApCfg : xFieldCfgList) {
            EntryFieldAp fieldAp = fieldApCfg.createEntryFieldAps(entryApId);
            entryFieldAps.add(fieldAp);
        }
        return entryFieldAps;
    }

    public static List<FieldAp> createFieldAps(List<XFieldCfg> xFieldCfgList, String parentId) {
        if (CollectionUtils.isEmpty(xFieldCfgList)) {
            return Collections.emptyList();
        }
        ArrayList<FieldAp> fieldAps = new ArrayList<FieldAp>(xFieldCfgList.size());
        for (XFieldCfg fieldApCfg : xFieldCfgList) {
            FieldAp fieldAp = fieldApCfg.createFieldAps(parentId);
            fieldAps.add(fieldAp);
        }
        return fieldAps;
    }

    public static void updateFieldAps(List<XFieldCfg> xFieldCfgList, Map<String, ControlAp<?>> ctrlApsMap) {
        if (!CollectionUtils.isEmpty(xFieldCfgList)) {
            for (XFieldCfg iscFieldApCfg : xFieldCfgList) {
                FieldAp fieldAp = (FieldAp)ctrlApsMap.get(iscFieldApCfg.getKey());
                if (fieldAp == null) continue;
                iscFieldApCfg.updateFieldAps(fieldAp);
            }
        }
    }
}

