/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.mservice;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.mservice.Result;
import kd.isc.iscb.platform.core.mservice.ServiceTag;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class MserviceParser {
    private static Log logger = LogFactory.getLog(MserviceParser.class);
    private static final Map<Class<?>, String> translateMap = new HashMap();

    public static Result parseAndSave(String serviceType, String appId, String serviceFactory) {
        Result result = new Result();
        try {
            Map<String, String> serviceMap = MserviceParser.getServiceMap(serviceFactory);
            for (Map.Entry<String, String> entry : serviceMap.entrySet()) {
                String serviceName = entry.getKey();
                List<Method> methods = MserviceParser.getServiceMethods(serviceName, serviceMap, result);
                for (Method method : methods) {
                    MserviceParser.handle(serviceType, appId, serviceFactory, serviceName, method, result);
                }
            }
            return result;
        }
        catch (Exception e) {
            result.setError(e);
            return result;
        }
    }

    private static void handle(String serviceType, String appId, String serviceFactory, String serviceName, Method method, Result result) {
        String number = serviceName + '_' + method.getName();
        if (QueryServiceHelper.exists((String)"isc_apic_mservice", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)})) {
            result.incignoreCount();
        } else {
            MserviceParser.insertMservice(serviceType, appId, serviceFactory, serviceName, method, result, number);
        }
    }

    private static void insertMservice(String serviceType, String appId, String serviceFactory, String serviceName, Method method, Result result, String number) {
        DynamicObject service = BusinessDataServiceHelper.newDynamicObject((String)"isc_apic_mservice");
        MserviceParser.setBaseInfo(serviceType, appId, serviceFactory, serviceName, service, method.getName(), number);
        MserviceParser.setInputs(method, service);
        MserviceParser.setOutputs(method, service);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{service});
        result.incSuccessCount();
    }

    private static List<Method> getServiceMethods(String serviceName, Map<String, String> serviceMap, Result result) {
        ArrayList<Method> methodList = new ArrayList<Method>(10);
        Class<?> serviceImpl = MserviceParser.findSeriveImplClass(serviceName, serviceMap);
        if (serviceImpl != null) {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = serviceImpl.getDeclaredMethods()) {
                if (MserviceParser.hasUnknownType(declaredMethod)) continue;
                methodList.add(declaredMethod);
                result.incTotal();
            }
        }
        return methodList;
    }

    private static Class<?> findSeriveImplClass(String serviceName, Map<String, String> serviceMap) {
        Class<?> serviceImpl = null;
        try {
            serviceImpl = Class.forName(serviceMap.get(serviceName));
        }
        catch (ClassNotFoundException ignore) {
            logger.info("\u5fae\u670d\u52a1:" + serviceName + "\u5b9e\u73b0\u7c7b\u627e\u4e0d\u5230\u3002");
        }
        return serviceImpl;
    }

    private static boolean hasUnknownType(Method declaredMethod) {
        for (Class<?> parameterType : declaredMethod.getParameterTypes()) {
            if (translateMap.containsKey(parameterType)) continue;
            return true;
        }
        Class<?> returnType = declaredMethod.getReturnType();
        if (Void.TYPE.isAssignableFrom(returnType)) {
            return false;
        }
        return !translateMap.containsKey(returnType);
    }

    private static Map<String, String> getServiceMap(String serviceFactory) {
        Class<?> aClass = MserviceParser.getServiceClass(serviceFactory);
        Field[] declaredFields = aClass.getDeclaredFields();
        Map<String, String> serviceMap = MserviceParser.getServiceMap(declaredFields);
        if (serviceMap != null) {
            return serviceMap;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6839\u636e%s\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u5b58\u50a8\u5fae\u670d\u52a1\u7684map", (String)"MserviceParser_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), serviceFactory));
    }

    private static Map<String, String> getServiceMap(Field[] declaredFields) {
        for (Field field : declaredFields) {
            Map map;
            if (!MserviceParser.isStaticMap(field) || (map = MserviceParser.findServiceMap(field)) == null) continue;
            return map;
        }
        return null;
    }

    private static boolean isStaticMap(Field field) {
        return Map.class.isAssignableFrom(field.getType()) && Modifier.isStatic(field.getModifiers());
    }

    private static Map findServiceMap(Field field) {
        try {
            field.setAccessible(true);
            Map map = (Map)field.get(null);
            if (!CollectionUtils.isEmpty(map)) {
                for (Object key : map.keySet()) {
                    String serviceName = D.s(key);
                    if (!MserviceParser.isServiceMap(serviceName)) continue;
                    return map;
                }
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw D.e((Throwable)e);
        }
    }

    private static boolean isServiceMap(String serviceName) {
        return serviceName != null && serviceName.toLowerCase(Locale.ENGLISH).contains("service");
    }

    private static Class<?> getServiceClass(String serviceFactory) {
        Class<?> aClass;
        try {
            aClass = Class.forName(serviceFactory);
        }
        catch (ClassNotFoundException e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u5fae\u670d\u52a1\u5de5\u5382\u7c7b:", (String)"MserviceParser_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
        }
        return aClass;
    }

    private static void setBaseInfo(String serviceType, String appId, String serviceFactory, String serviceName, DynamicObject service, String methodName, String number) {
        service.set("number", (Object)number);
        service.set("name", (Object)number);
        service.set("service_name", (Object)serviceName);
        service.set("method", (Object)methodName);
        service.set("enable", (Object)0);
        service.set("creator", (Object)RequestContext.get().getCurrUserId());
        ServiceTag tag = MserviceParser.parseServiceFactory(serviceType, appId, serviceFactory);
        service.set("service_type", (Object)tag.getServiceType());
        service.set("cloudid", (Object)tag.getCloudId());
        service.set("appid", (Object)tag.getAppId());
    }

    private static ServiceTag parseServiceFactory(String serviceType, String appId, String serviceFactory) {
        return new ServiceTag(serviceType, appId, serviceFactory);
    }

    private static void setInputs(Method method, DynamicObject service) {
        DynamicObjectCollection inputsEntry = service.getDynamicObjectCollection("inputs");
        inputsEntry.clear();
        for (Parameter parameter : method.getParameters()) {
            DynamicObject inputItem = inputsEntry.addNew();
            inputItem.set("input_field", (Object)parameter.getName());
            inputItem.set("input_data_type", (Object)translateMap.get(parameter.getType()));
        }
    }

    private static void setOutputs(Method method, DynamicObject service) {
        Class<?> returnType = method.getReturnType();
        if (Void.TYPE.isAssignableFrom(returnType)) {
            return;
        }
        DynamicObjectCollection outputsEntry = service.getDynamicObjectCollection("outputs");
        outputsEntry.clear();
        DynamicObject outputItem = outputsEntry.addNew();
        outputItem.set("output_field", (Object)"result");
        outputItem.set("output_data_type", (Object)translateMap.get(returnType));
    }

    static {
        translateMap.put(String.class, "string");
        translateMap.put(Boolean.class, "boolean");
        translateMap.put(Boolean.TYPE, "boolean");
        translateMap.put(Long.class, "long");
        translateMap.put(Long.TYPE, "long");
        translateMap.put(Integer.class, "int");
        translateMap.put(Integer.TYPE, "int");
        translateMap.put(BigDecimal.class, "decimal");
        translateMap.put(Timestamp.class, "datetime");
        translateMap.put(Double.class, "double");
        translateMap.put(Double.TYPE, "double");
        translateMap.put(List.class, "ENTRIES");
        translateMap.put(Map.class, "STRUCT");
        translateMap.put(Object[].class, "ARRAY");
        translateMap.put(Object.class, "Object");
    }
}

