/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.mservice;

import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.mservice.check.CheckResult;
import kd.isc.iscb.platform.core.mservice.check.MserviceUtil;

public class ServiceTag {
    private String cloudId;
    private String appId;
    private String serviceType;

    public ServiceTag(String serviceType, String appId, String serviceFactoryName) {
        String[] splits = serviceFactoryName.split("\\.");
        this.setInfoByserviceType(serviceType, appId, serviceFactoryName, splits);
    }

    private void setInfoByserviceType(String serviceType, String appId, String serviceFactoryName, String[] splits) {
        CheckResult checkResult = MserviceUtil.checkFactory(serviceType, serviceFactoryName);
        if (!checkResult.isValid()) {
            throw new IllegalArgumentException(checkResult.getErrorMsg());
        }
        this.initCloudIdAndAppId(serviceType, appId, serviceFactoryName, splits);
    }

    private void initCloudIdAndAppId(String serviceType, String appId, String serviceFactoryName, String[] splits) {
        if (serviceType.equals("bos")) {
            this.serviceType = "bos";
            this.cloudId = "bos";
            this.appId = "bos";
        } else if (serviceType.equals("isc")) {
            this.serviceType = "biz";
            this.cloudId = "isc";
            this.appId = "iscb";
        } else if (serviceType.equals("biz")) {
            this.serviceType = "biz";
            this.cloudId = splits[1];
            this.appId = splits[2];
        } else if (serviceType.equals("isv")) {
            this.serviceType = "isv";
            this.cloudId = serviceFactoryName.substring(0, serviceFactoryName.indexOf(".ServiceFactory"));
            this.appId = appId;
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5fae\u670d\u52a1\u7c7b\u578b\uff1a%s", (String)"ServiceTag_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), serviceType));
        }
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public String getAppId() {
        return this.appId;
    }
}

