/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.network;

import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.network.CheckResult;

public class NetSpeedTestUtil {
    private static final int TIMES = 5;
    private static final double ONE_MB = 1048576.0;
    private static final double ONE_GB = 1.073741824E9;
    private static final double ONE_KB = 1024.0;
    private static final double TOTAL_BYTES = 2621440.0;

    public static CheckResult speedTest(long dbLinkId) {
        long start = System.currentTimeMillis();
        try {
            ConnectionWrapper cn = NetSpeedTestUtil.getConnection(dbLinkId);
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e[%1$s]\u7f51\u901f\u6d4b\u8bd5\u3002", (String)"NetSpeedTestUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), cn.getConfig().getString("name"))).append("\r\n");
            long total = 0L;
            for (int i = 1; i <= 5; ++i) {
                long eachStart = System.currentTimeMillis();
                cn.getFactory().netSpeedTest(cn);
                long span = System.currentTimeMillis() - eachStart;
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u6b21\u83b7\u53d6512KB\u6570\u636e\uff0c\u8017\u65f6\uff1a%2$sms", (String)"NetSpeedTestUtil_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), i, span)).append("\r\n");
                total += span;
            }
            double unit = (double)total / 1000.0;
            if (unit > 0.0) {
                sb.append(String.format(ResManager.loadKDString((String)"\u603b\u8017\u65f6\uff1a%1$sms\uff0c\u5e73\u5747\u8017\u65f6\uff1a%2$sms\uff0c\u5e73\u5747\u7f51\u901f\uff1a", (String)"NetSpeedTestUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), total, total / 5L));
                return NetSpeedTestUtil.formatResult(start, sb, unit);
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u603b\u8017\u65f6\u4e0d\u6b63\u5e38\uff1a%s", (String)"NetSpeedTestUtil_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), total));
        }
        catch (Exception e) {
            return new CheckResult(false, String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u7f51\u901f\u6d4b\u8bd5\u5f02\u5e38\uff1a%s", (String)"NetSpeedTestUtil_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), StringUtil.toString((Throwable)e)), start);
        }
    }

    private static ConnectionWrapper getConnection(long dbLinkId) {
        ConnectionManager.pushResLicense(true);
        try {
            ConnectionWrapper connectionWrapper = ConnectionManager.getConnection(dbLinkId);
            return connectionWrapper;
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private static CheckResult formatResult(long start, StringBuilder sb, double unit) {
        double bps = 2621440.0 / unit;
        if (bps >= 1.073741824E9) {
            sb.append(String.format("%.2f", bps / 1.073741824E9)).append("GB/s");
        } else if (bps >= 1048576.0) {
            sb.append(String.format("%.2f", bps / 1048576.0)).append("MB/s");
        } else if (bps >= 1024.0) {
            sb.append(String.format("%.2f", bps / 1024.0)).append("KB/s");
        } else {
            sb.append(String.format("%.2f", bps)).append("B/s");
        }
        return new CheckResult(true, sb.toString(), start);
    }
}

