/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.params;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.Assert;

public class MicroService {
    private boolean is_isv;
    private String cloudId;
    private String appId;
    private String serviceName;
    private String methodName;
    private Object[] params;
    private String proxyUser;

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public MicroService(String cloudId, String appId, String serviceName, String methodName, Object[] params) {
        this.initCloudId(cloudId);
        this.appId = appId;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.params = params;
    }

    private void initCloudId(String cloudId) {
        Assert.notNull((Object)cloudId, (String)ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u7684cloudId\u4e0d\u80fd\u4e3a\u7a7a!", (String)"MicroService_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        int index = cloudId.lastIndexOf("@isv");
        if (index > 0) {
            this.is_isv = true;
            this.cloudId = cloudId.substring(0, index);
        } else {
            this.cloudId = cloudId;
        }
    }

    public MicroService(String appId, String serviceName, String methodName, Object[] params) {
        this("bos", appId, serviceName, methodName, params);
    }

    public boolean isIsv() {
        return this.is_isv;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object[] getParams() {
        return this.params;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getServiceURL() {
        return "xapi://" + this.cloudId + '.' + this.appId + '.' + this.serviceName + '.' + this.methodName;
    }

    public String toString() {
        return "Service{cloudId='" + this.cloudId + '\'' + ", appId='" + this.appId + '\'' + ", serviceName='" + this.serviceName + '\'' + ", methodName='" + this.methodName + '\'' + '}';
    }
}

