/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.permission;

import java.sql.Connection;
import java.util.Collections;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;

public class ImportController {
    public static boolean isOmitted(String table, long entryId) {
        Map importResource;
        String importSourceTrace;
        String pk;
        Object id;
        DataRow resource = ImportController.loadImportResource(table, entryId);
        String entityTitle = D.s((Object)resource.get((Object)"ftype"));
        String entityName = FileResourceUtil.getEntityName(entityTitle);
        String operation = D.s((Object)resource.get((Object)"foperation"));
        String omittedMsg = ImportController.checkImportResource(operation, entityName, id = FileResourceUtil.parseResPK(pk = D.s((Object)resource.get((Object)"fres_pk")), entityName), importSourceTrace = D.s((importResource = (Map)Json.toObject((String)D.s((Object)resource.get((Object)"fcontent")))).get("source_trace")));
        return omittedMsg != null;
    }

    public static String checkImportResource(String operation, String entityName, Object id, String importSourceTrace) {
        if ("INSERT".equals(operation)) {
            if (QueryServiceHelper.exists((String)entityName, (Object)id)) {
                return ResManager.loadKDString((String)"\u8be5\u8d44\u6e90\u5bfc\u5165\u65b9\u5f0f\u4e3a\u201c\u5173\u8054\u201d\u6a21\u5f0f\uff0c\u5e76\u4e14\u7cfb\u7edf\u5185\u5df2\u5b58\u5728\u8be5\u8d44\u6e90\uff0c\u5219\u5ffd\u7565\u5bfc\u5165\uff1b\u8be6\u7ec6\u4ecb\u7ecd\u8bf7\u770b\u5bfc\u5165\u65b9\u5f0f\u7684Tips\u4fe1\u606f\u3002", (String)"ImportController_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            }
            return null;
        }
        if (ImportController.hasSourceTraceProp(entityName)) {
            return ImportController.checkResult(entityName, id, importSourceTrace);
        }
        return null;
    }

    private static boolean hasSourceTraceProp(String entityName) {
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entityName).getProperties();
        return properties.containsKey((Object)"source_trace");
    }

    private static String checkResult(String entityName, Object id, String importSourceTrace) {
        DynamicObject currentResource = ImportController.getCurrentResource(entityName, id);
        if (currentResource == null) {
            return null;
        }
        String currentSourceTrace = D.s((Object)currentResource.get("source_trace"));
        if (currentSourceTrace == null) {
            return null;
        }
        if (importSourceTrace == null) {
            return ResManager.loadKDString((String)"\u672c\u5730\u8d44\u6e90\u4e0d\u662f\u5bfc\u5165\u8d44\u6e90\u7684\u5386\u53f2\u7248\u672c\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u8986\u76d6\u672c\u5730\u8d44\u6e90\u3002\n\u8bf7\u53c2\u8003\uff1ahttps://vip.kingdee.com/article/527079339259688192\n\u82e5\u5fc5\u987b\u5bfc\u5165\uff0c\u53ef\u52fe\u9009\u88ab\u5ffd\u7565\u7684\u4e3b\u8d44\u6e90\u8fdb\u884c\u5f3a\u5236\u5bfc\u5165\uff0c\u4f46\u8bf7\u4fdd\u8bc1\u5bf9\u73b0\u6709\u8d44\u6e90\u65e0\u5f71\u54cd\u7684\u60c5\u51b5\u4e0b\u4f7f\u7528\u8be5\u529f\u80fd\uff01", (String)"ImportController_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        return ImportController.checkSourceTrace(currentSourceTrace, importSourceTrace);
    }

    private static DynamicObject getCurrentResource(String entityName, Object id) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", id)};
        return QueryServiceHelper.queryOne((String)entityName, (String)"source_trace", (QFilter[])filters);
    }

    private static String checkSourceTrace(String currentSourceTrace, String importSourceTrace) {
        if (importSourceTrace.startsWith(currentSourceTrace)) {
            if (importSourceTrace.equals(currentSourceTrace)) {
                return null;
            }
            if (ImportController.notContainsCurrentTenant(importSourceTrace)) {
                return null;
            }
            if (ImportController.allowReverseImport()) {
                return null;
            }
            return ResManager.loadKDString((String)"\u5bfc\u5165\u8d44\u6e90\u5728\u5176\u4ed6\u73af\u5883\u88ab\u4fee\u6539\u8fc7\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u8986\u76d6\u672c\u5730\u8d44\u6e90\uff1b", (String)"ImportController_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u5982\u9700\u5bfc\u5165\u53ef\u5728\u3010\u516c\u5171\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011->\u3010\u7cfb\u7edf\u53c2\u6570\u3011->\u3010\u96c6\u6210\u670d\u52a1\u53c2\u6570\u3011->\u3010\u8d44\u6e90\u662f\u5426\u652f\u6301\u53cd\u5411\u5bfc\u5165\u3011\u6253\u5f00\u5f00\u5173\u3002", (String)"ImportController_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u672c\u5730\u8d44\u6e90\u4e0d\u662f\u5bfc\u5165\u8d44\u6e90\u7684\u5386\u53f2\u7248\u672c\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u8986\u76d6\u672c\u5730\u8d44\u6e90\u3002\n\u8bf7\u53c2\u8003\uff1ahttps://vip.kingdee.com/article/527079339259688192\n\u82e5\u5fc5\u987b\u5bfc\u5165\uff0c\u53ef\u52fe\u9009\u88ab\u5ffd\u7565\u7684\u4e3b\u8d44\u6e90\u8fdb\u884c\u5f3a\u5236\u5bfc\u5165\uff0c\u4f46\u8bf7\u4fdd\u8bc1\u5bf9\u73b0\u6709\u8d44\u6e90\u65e0\u5f71\u54cd\u7684\u60c5\u51b5\u4e0b\u4f7f\u7528\u8be5\u529f\u80fd\uff01", (String)"ImportController_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
    }

    private static boolean notContainsCurrentTenant(String importSourceTrace) {
        String[] importTraces = importSourceTrace.split(";");
        String tenantId = RequestContext.get().getTenantId();
        for (String trace : importTraces) {
            if (!tenantId.equals(trace)) continue;
            return false;
        }
        return true;
    }

    private static boolean allowReverseImport() {
        AppParam apm = new AppParam();
        apm.setAppId("TV3/VDJ86RC");
        apm.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        try {
            String reverseImport = D.s((Object)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm, (String)"reverse_import"));
            return "reverse_import_yes".equals(reverseImport);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static DataRow loadImportResource(String table, long entryid) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            String sql = "SELECT foperation,fres_pk,fcontent,ftype FROM " + table + " WHERE FENTRYID = ?";
            DataRow row = DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(entryid), Collections.singletonList(-5));
            if (row != null) {
                DataRow dataRow = row;
                return dataRow;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5bfc\u5165\u8d44\u6e90\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u6761\u4ef6\uff1atable = %1$s ,FENTRYID = %2$s", (String)"ImportController_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), table, entryid));
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }
}

