/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.proxy;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.LongProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class BusinessDataServiceHelperProxy {
    public static final String LOAD_FROM_DB = "isc.basedata.loadfromdb";

    public static DynamicObject loadSingleByFilter(DynamicObjectType type, QFilter[] filters) {
        String tenantId = RequestContext.get().getTenantId();
        String loadFromDB = SystemPropertyUtils.getProptyByTenant((String)LOAD_FROM_DB, (String)tenantId);
        if ("true".equalsIgnoreCase(loadFromDB)) {
            return BusinessDataServiceHelperProxy.loadSingleFromDB(type, filters);
        }
        return BusinessDataServiceHelperProxy.loadSingleFromCache(type, filters);
    }

    private static DynamicObject loadSingleFromDB(DynamicObjectType type, QFilter[] filters) {
        String entity = type.getName();
        List pks = QueryServiceHelper.queryPrimaryKeys((String)type.getName(), (QFilter[])filters, null, (int)10);
        if (pks.size() == 1) {
            return BusinessDataServiceHelper.loadSingle(pks.get(0), (DynamicObjectType)type);
        }
        if (pks.size() > 1) {
            String filter = BusinessDataServiceHelperProxy.getFilter(filters);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8fc7\u6ee4\u6761\u4ef6%1$s\uff0c\u67e5\u8be2\u5230\u5b9e\u4f53[%2$s]\u6709\u591a\u6761\u8bb0\u5f55\u7b26\u5408\u6761\u4ef6:%3$s", (String)"BusinessDataServiceHelperProxy_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), filter, entity, StringUtil.join((Collection)pks, (String)",")));
        }
        return null;
    }

    private static DynamicObject loadSingleFromCache(DynamicObjectType type, QFilter[] filters) {
        String entity = type.getName();
        Map objects = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)type, (QFilter[])filters);
        if (objects.size() == 1) {
            return (DynamicObject)objects.values().iterator().next();
        }
        if (objects.size() > 1) {
            String filter = BusinessDataServiceHelperProxy.getFilter(filters);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8fc7\u6ee4\u6761\u4ef6%1$s\uff0c\u67e5\u8be2\u5230\u5b9e\u4f53[%2$s]\u6709\u591a\u6761\u8bb0\u5f55\u7b26\u5408\u6761\u4ef6:", (String)"BusinessDataServiceHelperProxy_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), filter, entity, StringUtil.join(objects.keySet(), (String)",")));
        }
        return null;
    }

    private static String getFilter(QFilter[] filters) {
        return StringUtil.join((Object[])filters, (String)";");
    }

    public static DynamicObject loadSingle(Object pk, DynamicObjectType type) {
        pk = type.getPrimaryKey() instanceof LongProp ? Long.valueOf(D.l((Object)pk)) : D.s((Object)pk);
        String tenantId = RequestContext.get().getTenantId();
        String loadFromDB = SystemPropertyUtils.getProptyByTenant((String)LOAD_FROM_DB, (String)tenantId);
        if ("true".equalsIgnoreCase(loadFromDB)) {
            return BusinessDataServiceHelper.loadSingle((Object)pk, (DynamicObjectType)type);
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (DynamicObjectType)type);
        if (obj == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf\u4e2d\uff08%1$s\uff09\u4e2d\u4e0d\u5b58\u5728ID\u4e3a\uff08%2$s\uff09\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6709\u8bef\u6216\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"BusinessDataServiceHelperProxy_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type.getName(), pk));
        }
        return obj;
    }

    public static DynamicObject loadSingle(Object pk, String entityName) {
        try {
            return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664")) {
                String name = EntityMetadataCache.getDataEntityType((String)entityName).getDisplayName().getLocaleValue();
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf\u4e2d\uff08%1$s\uff09\u4e2d\u4e0d\u5b58\u5728ID\u4e3a\uff08%2$s\uff09\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6709\u8bef\u6216\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"BusinessDataServiceHelperProxy_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name, pk), (Throwable)e);
            }
            throw e;
        }
    }
}

