/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.rc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.isc.iscb.platform.core.rc.CheckResult;
import kd.isc.iscb.platform.core.rc.RiskInfo;
import kd.isc.iscb.platform.core.rc.RiskItem;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public interface RiskHandler {
    public List<CheckResult> check(RiskItem var1);

    default public String getDetailType() {
        return "showDetail";
    }

    default public RiskInfo calcRiskInfo(int totalCount, int riskCount) {
        return null;
    }

    default public Map<String, Object> getViewDetailParams(String id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<CheckResult> query(String sql, RiskItem riskItem) {
        ArrayList<CheckResult> arrayList;
        Connection cn = null;
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            List rows = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            ArrayList<CheckResult> list = new ArrayList<CheckResult>(rows.size());
            for (DataRow row : rows) {
                list.add(this.getCheckResult(row, riskItem));
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)true);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)true);
        return arrayList;
    }

    default public CheckResult getCheckResult(DataRow row, RiskItem riskItem) {
        CheckResult checkResult = new CheckResult();
        checkResult.setResourceId(D.l((Object)row.get((Object)"fid")));
        checkResult.setEntityName(riskItem.getEntity());
        String number = D.s((Object)row.get((Object)"fnumber"));
        checkResult.setResourceNumber(number == null ? "" : number);
        String fname = D.s((Object)row.get((Object)"fname"));
        checkResult.setResourceName(fname == null ? "" : fname);
        checkResult.setRiskItem(riskItem);
        return checkResult;
    }
}

