/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.rc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.rc.CheckItem;
import kd.isc.iscb.platform.core.rc.EntityEnum;
import kd.isc.iscb.platform.core.rc.GroupEnum;
import kd.isc.iscb.platform.core.rc.RiskHandler;
import kd.isc.iscb.platform.core.rc.RiskHandlers;
import kd.isc.iscb.platform.core.rc.RiskItem;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.NetUtil;

public class Util {
    private static Log logger = LogFactory.getLog(Util.class);
    private static final Map<String, CheckItem> checkItemToMap = new HashMap<String, CheckItem>(100);
    private static final Map<String, RiskItem> riskItemToMap = new HashMap<String, RiskItem>(100);
    private static final Map<String, List<CheckItem>> entityToCheckItemMap = new HashMap<String, List<CheckItem>>(100);
    private static final Map<String, List<EntityEnum>> groupToEntityMap = new HashMap<String, List<EntityEnum>>(100);
    private static final Map<String, String> queryEntitySqlMap = new HashMap<String, String>(100);
    public static final long ONEDAY = 86400000L;

    private static DataRow getRiskCount(Connection cn, String number) {
        String sql = "SELECT count(fid) as num FROM T_ISC_RES_CHECK_RESULT where  frisk_number=?";
        return DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(number), Collections.singletonList(12));
    }

    public static int getRiskCount(String number) {
        int n;
        Connection cn = null;
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            DataRow riskCount = Util.getRiskCount(cn, number);
            n = D.i((Object)riskCount.get((Object)"num"));
        }
        catch (Exception e) {
            try {
                throw new IscBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u68c0\u6d4b\u7ed3\u679c\u5931\u8d25\uff1a", (String)"Util_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(cn);
                throw throwable;
            }
        }
        DbUtil.close((Connection)cn);
        return n;
    }

    public static CheckItem getCheckItem(String number) {
        CheckItem item = checkItemToMap.get(number);
        if (item != null) {
            return item;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\uff08%s\uff09\u672a\u6ce8\u518c\u3002", (String)"Util_31", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number));
    }

    public static String getQueryEntitySql(String number) {
        return queryEntitySqlMap.get(number);
    }

    public static List<EntityEnum> getEntityEnums(String number) {
        List<EntityEnum> item = groupToEntityMap.get(number);
        if (item != null) {
            return item;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"group\uff08%s\uff09\u672a\u6ce8\u518c\u3002", (String)"Util_32", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number));
    }

    public static List<CheckItem> getCheckItems(String number) {
        List<CheckItem> item = entityToCheckItemMap.get(number);
        if (item != null) {
            return item;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"entity\uff08%s\uff09\u672a\u6ce8\u518c\u3002", (String)"Util_33", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number));
    }

    public static List<CheckItem> getAllCheckItems() {
        ArrayList<CheckItem> items = new ArrayList<CheckItem>();
        for (Map.Entry<String, List<CheckItem>> entry : entityToCheckItemMap.entrySet()) {
            items.addAll((Collection<CheckItem>)entry.getValue());
        }
        return items;
    }

    public static RiskItem getRiskItem(String number) {
        RiskItem item = riskItemToMap.get(number);
        if (item != null) {
            return item;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u98ce\u9669\u9879\uff08%s\uff09\u672a\u6ce8\u518c\u3002", (String)"Util_34", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number));
    }

    public static List<DataRow> getCheckRecord() {
        List list;
        Connection cn = null;
        String sql = "SELECT fkey,fvalue FROM T_ISC_RES_CHECK_RECORD";
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            list = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
        }
        catch (Exception e) {
            try {
                throw new IscBizException((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(cn, (boolean)false);
                throw throwable;
            }
        }
        DbUtil.close((Connection)cn, (boolean)false);
        return list;
    }

    public static String getRecordValue(String key) {
        List<DataRow> dataRows = Util.getCheckRecord();
        for (DataRow dataRow : dataRows) {
            if (!key.equals(dataRow.get((Object)"fkey"))) continue;
            return D.s((Object)dataRow.get((Object)"fvalue"));
        }
        return null;
    }

    public static RiskHandler getRiskHandler(String number) {
        return RiskHandlers.getHandler(number);
    }

    public static String getLinkType(String id, String entityName) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
        QFilter qFilter = new QFilter("id", "=", (Object)D.s((Object)dynamicObject.get("dum_link.id")));
        DynamicObject connectionType = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (String)"config_form", (QFilter[])new QFilter[]{qFilter});
        return D.s((Object)connectionType.get("config_form"));
    }

    public static Map<String, Object> getViewDetailParams(String showType, String entity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("showtype", showType);
        params.put("entity", entity);
        return params;
    }

    public static Map<String, Object> getViewDetailParams(String showType, String entity, String id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("showtype", showType);
        params.put("entity", Util.getLinkType(id, entity));
        return params;
    }

    static {
        try (InputStream in = Util.class.getResourceAsStream("/iscb/checkitems.json");){
            ArrayList<Object> list;
            String jsonStr = NetUtil.readText((InputStream)in);
            List checkItems = (List)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<List<CheckItem>>(){}, (Feature[])new Feature[0]);
            for (CheckItem checkItem : checkItems) {
                List<RiskItem> riskItems = checkItem.getRiskItemList();
                for (RiskItem riskItem : riskItems) {
                    riskItem.setCheckItem(checkItem);
                    riskItemToMap.put(riskItem.getNumber(), riskItem);
                }
                checkItemToMap.put(checkItem.getNumber(), checkItem);
            }
            for (EntityEnum entityEnum : EntityEnum.values()) {
                list = new ArrayList<Object>();
                for (CheckItem checkItem : checkItems) {
                    if (!entityEnum.name().equals(checkItem.getEntityName().name())) continue;
                    list.add(checkItem);
                }
                entityToCheckItemMap.put(entityEnum.name(), list);
                queryEntitySqlMap.put(entityEnum.name(), entityEnum.getTableName());
            }
            for (Enum enum_ : GroupEnum.values()) {
                list = new ArrayList();
                for (CheckItem checkItem : checkItems) {
                    GroupEnum temp = checkItem.getGroupName();
                    if (!enum_.name().equals(temp.name()) || list.contains((Object)checkItem.getEntityName())) continue;
                    list.add((Object)checkItem.getEntityName());
                }
                groupToEntityMap.put(enum_.name(), list);
            }
            queryEntitySqlMap.put("isc_data_copy_trigger", "t_isc_data_copy_trigger where fenable='1'");
        }
        catch (IOException e) {
            logger.warn("\u4ece\u914d\u7f6e\u6587\u4ef6\u83b7\u53d6\u68c0\u6d4b\u9879\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

