/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.resource.backup;

import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.HttpConnectionDecorator;

public class GitlabHttpConnectionDecorator
extends HttpConnectionDecorator {
    private int total;
    private String lastCommitId;

    public GitlabHttpConnectionDecorator(Map<String, Object> cookies, Map<String, Object> header) {
        super(cookies, header);
    }

    public void afterSubmit(HttpURLConnection http) {
        List<String> commitList;
        super.afterSubmit(http);
        Map<String, List<String>> headerFields = http.getHeaderFields();
        List<String> totalList = this.getValueFromMapIgnoreCase(headerFields, "X-Total");
        if (totalList != null && !totalList.isEmpty()) {
            this.total = D.i((Object)totalList.get(0));
        }
        if ((commitList = this.getValueFromMapIgnoreCase(headerFields, "X-Gitlab-Last-Commit-Id")) != null && !commitList.isEmpty()) {
            this.lastCommitId = commitList.get(0);
        }
    }

    private <T> T getValueFromMapIgnoreCase(Map<String, T> data, String key) {
        T value = data.get(key);
        if (value != null) {
            return value;
        }
        value = data.get(key.toLowerCase());
        if (value != null) {
            return value;
        }
        return data.get(key.toUpperCase());
    }

    public int getTotal() {
        return this.total;
    }

    public String getLastCommitId() {
        return this.lastCommitId;
    }
}

