/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.resource.backup;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.isc.iscb.platform.core.resource.backup.Branch;
import kd.isc.iscb.platform.core.resource.backup.GitlabHttpConnectionDecorator;
import kd.isc.iscb.platform.core.resource.backup.GitlabParam;
import kd.isc.iscb.platform.core.resource.backup.Project;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.HttpConnectionDecorator;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;

public class GitlabNetUtil {
    public static String createDataCenterCatalogPath() {
        String tenantId = RequestContext.get().getTenantId();
        Account dataCenter = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        return "iscb/" + tenantId + "/" + dataCenter.getAccountNumber() + "/";
    }

    public static String createResourceCatalogPath(String entityNumber) {
        String tenantId = RequestContext.get().getTenantId();
        Account dataCenter = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        return "iscb/" + tenantId + "/" + dataCenter.getAccountNumber() + "/" + entityNumber + "/";
    }

    public static String createResourceFilePath(String entityNumber, String pk) {
        String tenantId = RequestContext.get().getTenantId();
        Account dataCenter = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        String fileName = pk + ".dts";
        return "iscb/" + tenantId + "/" + dataCenter.getAccountNumber() + "/" + entityNumber + "/" + FileUtil.removeIllegalChar(fileName);
    }

    public static List<Branch> queryProjectBranches(GitlabParam param) {
        String url = String.format("%s/api/v4/projects/%s/repository/branches", param.getDomain(), GitlabNetUtil.urlEncoder(param.getProjectId()));
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("PRIVATE-TOKEN", param.getPrivateToken());
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(new HashMap(), headers);
        String responseStr = GitlabNetUtil.httpAccess(url, null, decorator, "GET");
        JSONArray response = null;
        try {
            response = JSONArray.parseArray((String)responseStr);
        }
        catch (Throwable t) {
            String tips = ResManager.loadKDString((String)"\u67e5\u8be2\u9879\u76ee\u5206\u652f\u51fa\u73b0\u5f02\u5e38\uff0c\u8fd4\u56de\u7684\u6570\u636e\u662f%s", (String)"GitlabNetUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(String.format(tips, responseStr), t);
        }
        ArrayList<Branch> result = new ArrayList<Branch>(response.size());
        for (Object o : response) {
            JSONObject item = (JSONObject)o;
            Branch branch = new Branch(item.getString("name"), item.getBoolean("default"), item.getString("web_url"));
            result.add(branch);
        }
        return result;
    }

    public static Project querySingleProject(GitlabParam param) {
        String url = String.format("%s/api/v4/projects/%s", param.getDomain(), GitlabNetUtil.urlEncoder(param.getProjectId()));
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("PRIVATE-TOKEN", param.getPrivateToken());
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(new HashMap(), headers);
        String responseStr = GitlabNetUtil.httpAccess(url, null, decorator, "GET");
        JSONObject response = JSONObject.parseObject((String)responseStr);
        return new Project(response.getString("name"));
    }

    public static Map<String, Object> queryRepositoryTree(String fullpath, int page, int limit) {
        GitlabParam param = GitlabParam.get();
        String url = String.format("%s/api/v4/projects/%s/repository/tree", param.getDomain(), GitlabNetUtil.urlEncoder(param.getProjectId()));
        String urlParam = String.format("?ref=%s&path=%s&page=%s&per_page=%s", param.getBranch(), GitlabNetUtil.urlEncoder(fullpath), page, limit);
        url = url + urlParam;
        HashMap<String, Object> headers = new HashMap<String, Object>(1);
        headers.put("PRIVATE-TOKEN", param.getPrivateToken());
        GitlabHttpConnectionDecorator decorator = new GitlabHttpConnectionDecorator(new HashMap<String, Object>(), headers);
        String responseStr = GitlabNetUtil.httpAccess(url, null, decorator, "GET");
        List response = (List)JSON.parseObject((String)responseStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", decorator.getTotal());
        result.put("data", response);
        return result;
    }

    public static void postFile(String entityNumber, String pk, String content, String commitRemark) {
        String fullpath = GitlabNetUtil.createResourceFilePath(entityNumber, pk);
        GitlabParam param = GitlabParam.get();
        GitlabNetUtil.postFile(fullpath, content, param, commitRemark);
    }

    public static void postFile(String fullpath, String content, GitlabParam param, String commitRemark) {
        HashMap<String, String> body = new HashMap<String, String>(3);
        body.put("commit_message", commitRemark);
        body.put("content", content);
        body.put("branch", param.getBranch());
        String url = String.format("%s/api/v4/projects/%s/repository/files/%s", param.getDomain(), GitlabNetUtil.urlEncoder(param.getProjectId()), GitlabNetUtil.urlEncoder(fullpath));
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("PRIVATE-TOKEN", param.getPrivateToken());
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(new HashMap(), headers);
        if (GitlabNetUtil.exists(fullpath, param)) {
            GitlabNetUtil.httpAccess(url, Json.toString(body, (boolean)true), decorator, "PUT");
        } else {
            GitlabNetUtil.httpAccess(url, Json.toString(body, (boolean)true), decorator, "POST");
        }
    }

    public static void deleteFile(String entityNumber, String pk) {
        if (GitlabNetUtil.exists(entityNumber, pk)) {
            String fullpath = GitlabNetUtil.createResourceFilePath(entityNumber, pk);
            GitlabParam param = GitlabParam.get();
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("commit_message", "delete by " + RequestContext.get().getUserName());
            body.put("branch", param.getBranch());
            String url = String.format("%s/api/v4/projects/%s/repository/files/%s", param.getDomain(), GitlabNetUtil.urlEncoder(param.getProjectId()), GitlabNetUtil.urlEncoder(fullpath));
            HashMap<String, String> headers = new HashMap<String, String>(1);
            headers.put("PRIVATE-TOKEN", param.getPrivateToken());
            HttpConnectionDecorator decorator = new HttpConnectionDecorator(new HashMap(), headers);
            GitlabNetUtil.httpAccess(url, Json.toString(body, (boolean)true), decorator, "DELETE");
        }
    }

    public static boolean exists(String entityNumber, String pk) {
        String fullpath = GitlabNetUtil.createResourceFilePath(entityNumber, pk);
        return GitlabNetUtil.exists(fullpath);
    }

    public static boolean exists(String fullpath) {
        GitlabParam param = GitlabParam.get();
        return GitlabNetUtil.exists(fullpath, param);
    }

    public static boolean exists(String fullpath, GitlabParam param) {
        String url = String.format("%s/api/v4/projects/%s/repository/files/%s/raw", param.getDomain(), GitlabNetUtil.urlEncoder(param.getProjectId()), GitlabNetUtil.urlEncoder(fullpath));
        String urlParam = String.format("?ref=%s", param.getBranch());
        url = url + urlParam;
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("PRIVATE-TOKEN", param.getPrivateToken());
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(new HashMap(), headers);
        try {
            GitlabNetUtil.httpAccess(url, null, decorator, "HEAD");
            return true;
        }
        catch (Exception e) {
            if (e.getMessage().contains("404")) {
                return false;
            }
            throw e;
        }
    }

    public static String queryFileContent(String entityNumber, String pk) {
        return GitlabNetUtil.queryFileContent(entityNumber, pk, null);
    }

    public static String queryFileContent(String entityNumber, String pk, String commitId) {
        String fullpath = GitlabNetUtil.createResourceFilePath(entityNumber, pk);
        GitlabParam param = GitlabParam.get();
        String url = String.format("%s/api/v4/projects/%s/repository/files/%s/raw", param.getDomain(), GitlabNetUtil.urlEncoder(param.getProjectId()), GitlabNetUtil.urlEncoder(fullpath));
        String urlParam = String.format("?ref=%s", StringUtil.isEmpty((String)commitId) ? param.getBranch() : commitId);
        url = url + urlParam;
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("PRIVATE-TOKEN", param.getPrivateToken());
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(new HashMap(), headers);
        String responseStr = GitlabNetUtil.httpAccess(url, null, decorator, "GET");
        return responseStr;
    }

    public static Map<String, String> queryFileHead(String fullpath) {
        GitlabParam param = GitlabParam.get();
        String url = String.format("%s/api/v4/projects/%s/repository/files/%s/raw", param.getDomain(), GitlabNetUtil.urlEncoder(param.getProjectId()), GitlabNetUtil.urlEncoder(fullpath));
        String urlParam = String.format("?ref=%s", param.getBranch());
        url = url + urlParam;
        HashMap<String, Object> headers = new HashMap<String, Object>(1);
        headers.put("PRIVATE-TOKEN", param.getPrivateToken());
        GitlabHttpConnectionDecorator decorator = new GitlabHttpConnectionDecorator(new HashMap<String, Object>(), headers);
        GitlabNetUtil.httpAccess(url, null, decorator, "HEAD");
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("lastCommitId", decorator.getLastCommitId());
        return result;
    }

    public static List<Map<String, String>> queryFileCommits(String fullpath) {
        GitlabParam param = GitlabParam.get();
        String url = String.format("%s/api/v4/projects/%s/repository/commits", param.getDomain(), GitlabNetUtil.urlEncoder(param.getProjectId()));
        String urlParam = String.format("?path=%s&ref_name=%s", GitlabNetUtil.urlEncoder(fullpath), param.getBranch());
        url = url + urlParam;
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("PRIVATE-TOKEN", param.getPrivateToken());
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(new HashMap(), headers);
        String json = GitlabNetUtil.httpAccess(url, null, decorator, "GET");
        return (List)JSONObject.parse((String)json);
    }

    public static Map<String, Object> querySingleCommit(String commitId) {
        GitlabParam param = GitlabParam.get();
        String url = String.format("%s/api/v4/projects/%s/repository/commits/%s", param.getDomain(), GitlabNetUtil.urlEncoder(param.getProjectId()), commitId);
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("PRIVATE-TOKEN", param.getPrivateToken());
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(new HashMap(), headers);
        String json = GitlabNetUtil.httpAccess(url, null, decorator, "GET");
        return (Map)JSONObject.parse((String)json);
    }

    public static List<Map<String, Object>> searchCommits(String searchText) {
        return null;
    }

    private static String httpAccess(String url, String data, HttpConnectionDecorator decorator, String method) {
        try {
            Reader reader = NetUtil.httpAccess((String)url, (String)data, (String)"UTF-8", (NetUtil.ConnectionDecorator)decorator, (String)method);
            return NetUtil.readText((Reader)reader);
        }
        catch (Exception e) {
            if (e.getMessage().contains("401 Unauthorized")) {
                String tips = ResManager.loadKDString((String)"\u8bbf\u95ee\u4ee4\u724c\u4e0d\u5408\u6cd5\uff0c\u4ed3\u5e93\u670d\u52a1\u8ba4\u8bc1\u4e0d\u901a\u8fc7\u3002", (String)"GitlabNetUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
                throw new IscBizException(tips, (Throwable)e);
            }
            if (e.getMessage().contains("404 Project Not Found")) {
                String tips = ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u60a8\u586b\u5199\u7684 \u9879\u76eeID/\u9879\u76ee\u540d\u79f0", (String)"GitlabNetUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
                throw new IscBizException(tips, (Throwable)e);
            }
            throw e;
        }
    }

    private static String urlEncoder(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw CommonError.INVALID_CHARSET.create((Throwable)e, new String[]{"UTF-8"});
        }
    }
}

