/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.resource.backup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.IDService;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.resource.backup.GitlabNetUtil;
import kd.isc.iscb.platform.core.resource.backup.PullJobFactory;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.util.MultiLangUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class PullJob
implements Job {
    private String title;
    private String param;
    public static final JobFactory FACTORY = new PullJobFactory();
    private int total;
    private AtomicInteger success = new AtomicInteger(0);

    public PullJob(String title, String param) {
        this.title = title;
        this.param = param;
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public long getOwnerId() {
        Map paramMap = (Map)Json.toObject((String)this.param);
        return D.l(paramMap.get("billId"));
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String getJobSummary() {
        Map paramMap = (Map)Json.toObject((String)this.param);
        String s = ResManager.loadKDString((String)"\u5df2\u751f\u6210\u6279\u53f7\u4e3a[%1$s]\u7684\u5f85\u5bfc\u5165\u8bb0\u5f55\uff0c\u5173\u95ed\u6b64\u5f39\u6846\u81ea\u52a8\u6253\u5f00\u3002\n\n\u6216\u590d\u5236\u6279\u53f7\u5230[\u76d1\u63a7\u7edf\u8ba1->\u8d44\u6e90\u5bfc\u5165\u8bb0\u5f55]\u83dc\u5355\u67e5\u8be2\u5e76\u5bfc\u5165\u6570\u636e\u3002", (String)"PullJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        return String.format(s, Hash.mur32((Object[])new Object[]{paramMap.get("billId")}));
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        Map paramMap = (Map)Json.toObject((String)this.param);
        String s = ResManager.loadKDString((String)"\u5df2\u751f\u6210\u6279\u53f7\u4e3a[%1$s]\u7684\u5f85\u5bfc\u5165\u8bb0\u5f55\u3002[\u76d1\u63a7\u7edf\u8ba1->\u8d44\u6e90\u5bfc\u5165\u8bb0\u5f55]\u83dc\u5355\u67e5\u8be2\u6570\u636e\u3002\n\u4e0b\u8f7d\u8d44\u6e90\uff1a%2$s/%3$s\u4e2a", (String)"PullJob_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        s = String.format(s, Hash.mur32((Object[])new Object[]{paramMap.get("billId")}), this.success.get(), this.total);
        return new Job.Progress(this.total, this.success.get(), s);
    }

    @Override
    public void run() {
        Map paramMap = (Map)Json.toObject((String)this.param);
        long billId = D.l(paramMap.get("billId"));
        List pullData = (List)paramMap.get("pullData");
        this.total = pullData.size();
        try {
            this.saveImportBill(billId, pullData);
        }
        catch (Throwable t) {
            String s = ResManager.loadKDString((String)"\u8d44\u6e90\u6062\u590d\u51fa\u73b0\u5f02\u5e38\uff0c\u53ef\u5728\u96c6\u6210\u7ba1\u7406>\u76d1\u63a7\u7edf\u8ba1>\u8d44\u6e90\u5bfc\u5165\u8bb0\u5f55\u67e5\u770b\u4efb\u52a1\u6279\u53f7[%s]\u7684\u6570\u636e", (String)"PullJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(String.format(s, Hash.mur32((Object[])new Object[]{billId})), t);
        }
    }

    private void saveImportBill(long billId, List<Map<String, String>> pullData) {
        for (Map<String, String> map : pullData) {
            SignalManager.checkCancelSignal();
            this.success.getAndIncrement();
            String entity = map.get("entity");
            String pk = map.get("pk");
            String content = GitlabNetUtil.queryFileContent(entity, pk);
            ArrayList<Map<String, Object>> main = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> ref = new ArrayList<Map<String, Object>>();
            this.classify(content, main, ref);
            this.saveMainContents(billId, main);
            this.saveRefContents(billId, ref);
        }
    }

    private void classify(String content, List<Map<String, Object>> main, List<Map<String, Object>> ref) {
        String[] jsons;
        for (String json : jsons = content.split("\\n")) {
            Map data = (Map)Json.toObject((String)json);
            if (data == null) continue;
            boolean isRef = D.x(data.get("$isref"));
            if (isRef) {
                ref.add(data);
                continue;
            }
            main.add(data);
        }
    }

    private void saveMainContents(long billId, List<Map<String, Object>> mainList) {
        ArrayList<Object[]> allParams = new ArrayList<Object[]>(mainList.size());
        for (int i = 0; i < mainList.size(); ++i) {
            Map<String, Object> e = mainList.get(i);
            Object[] params = new Object[12];
            params[0] = billId;
            params[1] = IDService.get().genLongId();
            params[2] = i + 1;
            params[3] = "UPDATE";
            params[4] = this.getResName(e);
            params[5] = this.getResNumber(e);
            String resPk = D.s((Object)e.get("id"));
            String entity = D.s((Object)e.get("$entityname"));
            params[6] = D.t((Object)e.get(this.getTimeField(entity)));
            params[7] = SolutionUtil.getLocalTime(entity, resPk);
            params[8] = "READY";
            params[9] = Json.toString(e);
            params[10] = resPk;
            params[11] = FileResourceUtil.getEntityTitle(entity);
            allParams.add(params);
        }
        String sql = "INSERT INTO T_ISCB_DTS_IMP_MRS2(FID,FENTRYID, FSEQ, FOPERATION,FNAME,FNUMBER,FRES_TIME,FLOCAL_TIME,FSTATE,    FCONTENT,FRES_PK, FTYPE)VALUES(?,?,?,?,    ?,?,?,?,?,    ?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"ISCB"), (String)sql, allParams);
    }

    private void saveRefContents(long billId, List<Map<String, Object>> refList) {
        if (refList.isEmpty()) {
            return;
        }
        ArrayList<Object[]> allParams = new ArrayList<Object[]>(refList.size());
        for (int i = 0; i < refList.size(); ++i) {
            Map<String, Object> e = refList.get(i);
            Object[] params = new Object[12];
            params[0] = billId;
            params[1] = IDService.get().genLongId();
            params[2] = i + 1;
            params[3] = "INSERT";
            params[4] = this.getResName(e);
            params[5] = this.getResNumber(e);
            String resPk = D.s((Object)e.get("id"));
            String entity = D.s((Object)e.get("$entityname"));
            params[6] = D.t((Object)e.get(this.getTimeField(entity)));
            params[7] = SolutionUtil.getLocalTime(entity, resPk);
            params[8] = "READY";
            params[9] = Json.toString(e);
            params[10] = resPk;
            params[11] = FileResourceUtil.getEntityTitle(entity);
            allParams.add(params);
        }
        String sql = "INSERT INTO T_ISCB_DTS_IMP_RRS2(FID,FENTRYID, FSEQ, FOPERATION,FNAME,FNUMBER,FRES_TIME,FLOCAL_TIME,FSTATE,    FCONTENT,FRES_PK,FTYPE)VALUES(?,?,?,?,     ?,?,?,?,    ?,?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"ISCB"), (String)sql, allParams);
    }

    private String getResName(Map<String, Object> data) {
        String s = MultiLangUtil.getMultiLangValue(data.get("name"));
        return s == null ? ResManager.loadKDString((String)"(\u65e0)", (String)"FileResourceParseJob_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : s;
    }

    private String getResNumber(Map<String, Object> data) {
        String number = D.s((Object)data.get("number"));
        return number == null ? ResManager.loadKDString((String)"(\u65e0)", (String)"FileResourceParseJob_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]) : number;
    }

    private String getTimeField(String entity) {
        switch (entity) {
            case "isc_apic_permission": {
                return "created_time";
            }
            case "iscx_resource_ext": {
                return "extended_time";
            }
        }
        return "modifytime";
    }
}

