/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.resource.backup;

import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.resource.backup.GitlabNetUtil;
import kd.isc.iscb.platform.core.resource.backup.GitlabParam;
import kd.isc.iscb.platform.core.resource.backup.PushJobFactory;
import kd.isc.iscb.platform.core.resource.packages.ExportUtil;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class PushJob
implements Job {
    private String param;
    private String title;
    private long taskId;
    private String userRemark;
    public static final JobFactory FACTORY = new PushJobFactory();
    private String current;
    private int total;
    private AtomicInteger success = new AtomicInteger(0);

    public PushJob(String title, String param) {
        this.param = param;
        this.title = title;
        Map paramMap = (Map)Json.toObject((String)param);
        this.taskId = D.l(paramMap.get("taskId"));
        this.userRemark = D.s(paramMap.get("remark"));
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public long getOwnerId() {
        return this.taskId;
    }

    @Override
    public String getJobSummary() {
        String s = ResManager.loadKDString((String)"\u5df2\u6210\u529f\u5907\u4efd%s\u4e2a\u8d44\u6e90\u5230\u4e91\u7aef", (String)"PushJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        return String.format(s, this.success.get());
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        String s = ResManager.loadKDString((String)"\u603b\u5171\u9700\u8981\u5907\u4efd\uff1a%1$s\u4e2a\uff0c\u5df2\u5907\u4efd\uff1a%2$s\u4e2a, %3$s", (String)"PushJob_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        String remark = String.format(s, this.total, this.success.get(), this.current);
        return new Job.Progress(this.total, this.success.get(), remark);
    }

    @Override
    public void run() {
        try {
            this.setStatus(BillStatus.B);
            this.innerRun();
            this.setStatus(BillStatus.C);
        }
        catch (Throwable t) {
            this.setStatus(BillStatus.A);
            String s = ResManager.loadKDString((String)"\u5907\u4efd\u5931\u8d25\u4e86\uff0c\u539f\u56e0\uff1a%s", (String)"PushJob_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
            throw new IscBizException(String.format(s, StringUtil.getCascadeMessage((Throwable)t)), t);
        }
    }

    private void innerRun() {
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)this.taskId, (String)"isc_res_backup_task");
        DynamicObjectCollection resources = task.getDynamicObjectCollection("entryentity");
        this.total = resources.size();
        for (DynamicObject res : resources) {
            SignalManager.checkCancelSignal();
            String resNumber = res.getString("res_number");
            String resName = res.getString("res_name");
            String pk = res.getString("res_pk");
            String entity = res.getDynamicObject("res_type").getString("number");
            String entityName = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().toString();
            Object resPK = FileResourceUtil.parseResPK(pk, entity);
            if (!QueryServiceHelper.exists((String)entity, (Object)resPK)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u3010%1$s\u3011\u3010%2$s\u3011\u5bf9\u5e94\u7684\u8d44\u6e90ID\u3010%3$s\u3011\u7f16\u7801\u3010%4$s\u3011\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u8ba1\u7b97\u5176\u5f15\u7528\u8d44\u6e90\uff0c\u8bf7\u786e\u4fdd\u8d44\u6e90\u5305\u6240\u9009\u62e9\u7684\u8d44\u6e90\u5728\u5f53\u524d\u73af\u5883\u5747\u5b58\u5728\uff0c\u4ee5\u4fbf\u8ba1\u7b97\u5f15\u7528\u8d44\u6e90\u3002", (String)"PushJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entityName, entity, resPK, resNumber));
            }
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)resPK, (String)entity);
            this.current = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790\uff1a\u3010%1$s\u3011\u3010%2$s\u3011", (String)"PushJob_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), resNumber, resName);
            String dts = ExportUtil.exportDynamicObjectToDts(object);
            this.current = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5907\u4efd\uff1a\u3010%1$s\u3011\u3010%2$s\u3011", (String)"PushJob_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), resNumber, resName);
            GitlabNetUtil.postFile(entity, pk, dts, this.getCommitRemark(entity, pk));
            this.success.incrementAndGet();
        }
        GitlabParam param = GitlabParam.get();
        String url = "URL:[" + param.getDomain() + "] Project:[" + param.getProjectId() + "] Branch:[" + param.getBranch() + ']';
        task.set("push_url", (Object)url);
        task.set("remark", (Object)this.userRemark);
        SaveServiceHelper.update((DynamicObject)task);
    }

    private String getCommitRemark(String entityNumber, String pk) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityNumber);
        HashMap<String, String> message = new HashMap<String, String>(4);
        message.put("number", this.getResNumber(object));
        message.put("name", this.getResName(object));
        message.put("pk", pk);
        message.put("author", RequestContext.get().getUserName());
        message.put("remark", this.userRemark);
        message.put("$entityname", entityNumber);
        return Json.toString(message, (boolean)Boolean.TRUE);
    }

    private String getResName(DynamicObject object) {
        IDataEntityProperty property = (IDataEntityProperty)object.getDataEntityType().getProperties().get((Object)"name");
        if (property == null) {
            return ResManager.loadKDString((String)"(\u65e0)", (String)"PushJob_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        return object.getString("name");
    }

    private String getResNumber(DynamicObject object) {
        IDataEntityProperty property = (IDataEntityProperty)object.getDataEntityType().getProperties().get((Object)"number");
        if (property == null) {
            return ResManager.loadKDString((String)"(\u65e0)", (String)"PushJob_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        }
        return object.getString("number");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(BillStatus status) {
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)false);
        String sql = "UPDATE t_iscb_backup_task set fbillstatus=? where fid=?";
        List<Object> values = Arrays.asList(status.name(), this.taskId);
        List<Integer> types = Arrays.asList(12, -5);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public static enum BillStatus {
        A{

            @Override
            public String getDescription() {
                return new MultiLangEnumBridge("\u6682\u5b58", "PushJob_3", "isc-iscb-platform-core").loadKDString();
            }
        }
        ,
        B{

            @Override
            public String getDescription() {
                return new MultiLangEnumBridge("\u5907\u4efd\u4e2d", "PushJob_4", "isc-iscb-platform-core").loadKDString();
            }
        }
        ,
        C{

            @Override
            public String getDescription() {
                return new MultiLangEnumBridge("\u5907\u4efd\u6210\u529f", "PushJob_5", "isc-iscb-platform-core").loadKDString();
            }
        };


        public abstract String getDescription();
    }
}

