/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.resource.packages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.dts.ExportDynamicObject;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.resource.packages.ExportUtil;
import kd.isc.iscb.platform.core.resource.packages.PackagesExportJobFactory;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.g.Graph;
import kd.isc.iscb.util.misc.Json;

public class PackagesExportJob
implements Job {
    private String param;
    private String title;
    private long packagesId;
    private long exportBillid;
    private String exportNumber;
    public static final JobFactory FACTORY = new PackagesExportJobFactory();
    private String current;
    private int total;
    private AtomicInteger success = new AtomicInteger(0);
    private Map<String, String> mainExportContent = new HashMap<String, String>(16);

    public PackagesExportJob(String title, String param) {
        this.param = param;
        this.title = title;
        Map paramMap = (Map)Json.toObject((String)param);
        this.packagesId = D.l(paramMap.get("packagesId"));
        this.exportBillid = D.l(paramMap.get("billId"));
        this.exportNumber = D.s(paramMap.get("number"));
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String getJobSummary() {
        String s = ResManager.loadKDString((String)"\u5df2\u7ecf\u751f\u6210\u6279\u53f7\u4e3a\uff1a%1$s \u7684\u5bfc\u51fa\u8bb0\u5f55\uff0c\u6253\u5f00\u5bfc\u51fa\u8bb0\u5f55\u5217\u8868\u6216\u5173\u95ed\u6b64\u5f39\u6846\u76f4\u63a5\u4e0b\u8f7d", (String)"PackagesExportJob_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        return String.format(s, this.exportNumber);
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        String s = ResManager.loadKDString((String)"\u4e3b\u8d44\u6e90\u603b\u6570\uff1a%1$s\uff0c\u5df2\u5904\u7406\uff1a%2$s, \u6b63\u5728\u5904\u7406\uff1a%3$s", (String)"PackagesExportJob_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        String remark = String.format(s, this.total, this.success.get(), this.current);
        return new Job.Progress(this.total, this.success.get(), remark);
    }

    @Override
    public long getOwnerId() {
        return this.packagesId;
    }

    public long getExportBillid() {
        return this.exportBillid;
    }

    public String getExportNumber() {
        return this.exportNumber;
    }

    @Override
    public void run() {
        DynamicObject packages = BusinessDataServiceHelper.loadSingle((Object)this.packagesId, (String)"isc_res_packages");
        DynamicObject exportObject = BusinessDataServiceHelper.newDynamicObject((String)"isc_res_packages_export");
        exportObject.set("id", (Object)this.exportBillid);
        exportObject.set("number", (Object)this.exportNumber);
        exportObject.set("packages", (Object)packages);
        DynamicObjectCollection resources = packages.getDynamicObjectCollection("entryentity");
        this.total = resources.size();
        Graph g = new Graph();
        ArrayList<DynamicObject> mainResources = new ArrayList<DynamicObject>(resources.size());
        for (DynamicObject res : resources) {
            SignalManager.checkCancelSignal();
            try {
                this.parseResource(res, mainResources, (Graph<DynamicObject>)g);
            }
            catch (Throwable t) {
                String resNumber = res.getString("res_number");
                String resName = res.getString("res_name");
                this.current = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u7b2c%1$s\u4e2a\u8d44\u6e90\u7684\u65f6\u5019\u51fa\u73b0\u5f02\u5e38\uff0c\u8d44\u6e90\u662f\uff1a\u3010%2$s\u3011\u3010%3$s\u3011", (String)"PackagesExportJob_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), mainResources.size(), resNumber, resName);
                throw new IscBizException(this.current, t);
            }
        }
        List allResources = g.topSort();
        if (allResources.size() != g.getNodeCount()) {
            Map<String, List<String>> bills = ExportDynamicObject.getCrossRefs((Graph<DynamicObject>)g, allResources);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e4b\u95f4\u5b58\u5728\u5faa\u73af\u5f15\u7528\u5173\u7cfb\uff0c\u4e0d\u80fd\u5bfc\u51fa\uff01\u6d89\u53ca\u7684\u5355\u636e\u6709\uff1a%s", (String)"PackagesExportJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), bills));
        }
        this.updateEntries(exportObject, allResources, mainResources);
        exportObject.set("res_count", (Object)mainResources.size());
        exportObject.set("remark", (Object)this.classifyInfo(resources));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{exportObject});
    }

    private void parseResource(DynamicObject res, List<DynamicObject> mainResources, Graph<DynamicObject> g) {
        String resNumber = res.getString("res_number");
        String resName = res.getString("res_name");
        this.current = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8d44\u6e90\uff1a\u3010%1$s\u3011\u3010%2$s\u3011", (String)"PackagesExportJob_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), resNumber, resName);
        String pk = res.getString("res_pk");
        String entity = res.getDynamicObject("res_type").getString("number");
        String entityName = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().toString();
        Object resPK = FileResourceUtil.parseResPK(pk, entity);
        if (!QueryServiceHelper.exists((String)entity, (Object)resPK)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u3010%1$s\u3011\u3010%2$s\u3011\u5bf9\u5e94\u7684\u8d44\u6e90ID\u3010%3$s\u3011\u7f16\u7801\u3010%4$s\u3011\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u8ba1\u7b97\u5176\u5f15\u7528\u8d44\u6e90\uff0c\u8bf7\u786e\u4fdd\u8d44\u6e90\u5305\u6240\u9009\u62e9\u7684\u8d44\u6e90\u5728\u5f53\u524d\u73af\u5883\u5747\u5b58\u5728\uff0c\u4ee5\u4fbf\u8ba1\u7b97\u5f15\u7528\u8d44\u6e90\u3002", (String)"PackagesExportJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entityName, entity, resPK, resNumber));
        }
        DynamicObject o = BusinessDataServiceHelper.loadSingle((Object)resPK, (String)entity);
        mainResources.add(o);
        ExportDynamicObject.append(g, o);
        String exportContent = ExportUtil.exportDynamicObjectToDts(o);
        this.mainExportContent.put(SolutionUtil.getFullKey(o.getDataEntityType().getName(), o.getPkValue()), exportContent);
        this.success.incrementAndGet();
    }

    private void updateEntries(DynamicObject exportObject, List<DynamicObject> allResources, List<DynamicObject> mainResources) {
        List<DynamicObject> mainObjects = SolutionUtil.getMainResources(allResources, mainResources);
        Map<String, DynamicObject> dataMap = SolutionUtil.convertToMap(allResources, mainResources);
        this.current = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u521b\u5efa\u5bfc\u51fa\u8bb0\u5f55\u5e76\u4fdd\u5b58\uff0c\u4e3b\u8d44\u6e90\uff1a%1$s\u4e2a\uff0c\u4f9d\u8d56\u8d44\u6e90\uff1a%2$s\u4e2a", (String)"PackagesExportJob_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), mainObjects.size(), dataMap.size());
        int refIndex = 0;
        DynamicObjectCollection refEntries = exportObject.getDynamicObjectCollection("ref_resources");
        refEntries.clear();
        for (DynamicObject data : dataMap.values()) {
            DynamicObject item = refEntries.addNew();
            this.setRefEntryValue(item, data, ++refIndex);
        }
        int mainIndex = 0;
        DynamicObjectCollection mainEntries = exportObject.getDynamicObjectCollection("main_resources");
        mainEntries.clear();
        for (DynamicObject data : mainObjects) {
            DynamicObject item = mainEntries.addNew();
            this.setMainEntryValue(item, data, ++mainIndex);
        }
    }

    private void setRefEntryValue(DynamicObject item, DynamicObject data, int seq) {
        String type = data.getDynamicObjectType().getName();
        item.set("ref_res_type", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)type, (String)"bos_objecttype"));
        item.set("ref_res_number", (Object)data.getString("number"));
        item.set("ref_res_name", (Object)data.getString("name"));
        item.set("ref_res_pk", data.getPkValue());
        item.set("ref_res_time", data.get(SolutionUtil.getTimeField(data.getDynamicObjectType().getName())));
        String content = this.objectToDtsContent(data);
        item.set("ref_res_content_tag", (Object)content);
        item.set("ref_res_size", (Object)content.length());
        item.set("seq", (Object)seq);
    }

    private void setMainEntryValue(DynamicObject item, DynamicObject data, int seq) {
        String type = data.getDynamicObjectType().getName();
        item.set("main_res_type", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)type, (String)"bos_objecttype"));
        item.set("main_res_number", (Object)data.getString("number"));
        item.set("main_res_name", (Object)data.getString("name"));
        item.set("main_res_pk", data.getPkValue());
        item.set("main_res_time", data.get(SolutionUtil.getTimeField(data.getDynamicObjectType().getName())));
        String content = this.objectToDtsContent(data);
        item.set("main_res_content_tag", (Object)content);
        item.set("main_export_content_tag", (Object)this.mainExportContent.get(SolutionUtil.getFullKey(data.getDataEntityType().getName(), data.getPkValue())));
        item.set("main_res_size", (Object)content.length());
        item.set("seq", (Object)seq);
    }

    private String objectToDtsContent(DynamicObject data) {
        Map<String, Object> map = DynamicObjectUtil.object2Map(data);
        map.put("$id", data.getPkValue());
        map.put("$entityname", data.getDynamicObjectType().getName());
        map.put("$isref", Boolean.FALSE);
        return Json.toString(map);
    }

    private String classifyInfo(DynamicObjectCollection resources) {
        HashMap<String, Integer> info = new HashMap<String, Integer>(16);
        for (DynamicObject res : resources) {
            String entity = res.getDynamicObject("res_type").getString("number");
            String entityName = EntityMetadataCache.getDataEntityType((String)entity).getDisplayName().toString();
            Integer i = (Integer)info.get(entityName);
            i = i == null ? Integer.valueOf(1) : Integer.valueOf(i + 1);
            info.put(entityName, i);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : info.entrySet()) {
            sb.append((String)entry.getKey()).append(':').append(entry.getValue()).append(' ');
        }
        return sb.toString();
    }
}

