/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.api.ApiResourceType;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.sf.runtime.n.ApiFunctionApplication;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.misc.StringUtil;

public class ApiInvokerParser
implements NodeParser,
Const {
    private static final String FUNC = "func";
    private static final String FUNC_TYPE = "func_type";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String FIXED_VALUE = "fixed_value";
    private static final String VAR_VALUE = "var_value";

    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        String title = node.getTitle();
        String func = D.s((Object)item.get(FUNC));
        this.checkFunc(title, func);
        FlowBuilder flowBuilder = node.getFlowBuilder();
        Resource resource = ServiceFlowParser.getResource(flowBuilder, func, node.getTitle());
        String entityType = D.s((Object)item.get(FUNC_TYPE));
        this.checkResourceType(title, resource, entityType);
        long id = resource.getId();
        String caller = D.s((Object)item.get("caller"));
        Map<String, Object> input = this.getInputMap(node, item);
        Map<String, ExprSetter> output = this.getOutputMap(node, item);
        ApiResourceType apiResource = ApiResourceType.getApiResource(entityType);
        ApiFunctionApplication app = new ApiFunctionApplication(id, apiResource, input, output, caller);
        node.biz((Application)app);
    }

    private void checkFunc(String title, String func) {
        if (StringUtil.isEmpty((String)func)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"API\u8282\u70b9[%s]\u7684API&\u51fd\u6570\u4e3a\u5fc5\u586b\u9879\u3002", (String)"ApiInvokerParser_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title));
        }
    }

    private void checkResourceType(String title, Resource resource, String entityType) {
        String resourceType = String.valueOf((Object)resource.getCategory());
        if (!resourceType.equalsIgnoreCase(entityType)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"API\u8282\u70b9[%1$s]\u8d44\u6e90\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5e94\u4e3a\uff1a%2$s,\u5b9e\u9645\u7684\u8d44\u6e90\u7c7b\u578b\u4e3a\uff1a%3$s", (String)"ApiInvokerParser_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title, resourceType, entityType));
        }
    }

    private Map<String, Object> getInputMap(NodeBuilder node, Map<String, Object> item) {
        Map input = (Map)item.get(INPUT);
        LinkedHashMap<String, Object> apiInput = new LinkedHashMap<String, Object>(input.size());
        for (Map.Entry entry : input.entrySet()) {
            Map values = (Map)entry.getValue();
            String fixed = (String)values.get(FIXED_VALUE);
            String var = (String)values.get(VAR_VALUE);
            if (!StringUtil.isEmpty((String)fixed)) {
                apiInput.put((String)entry.getKey(), new ExprGetter(fixed, null));
                continue;
            }
            if (!StringUtil.isEmpty((String)var)) {
                apiInput.put((String)entry.getKey(), ServiceFlowParser.parseExprGetter(node.getFlowBuilder(), var));
                continue;
            }
            apiInput.put((String)entry.getKey(), null);
        }
        return apiInput;
    }

    private Map<String, ExprSetter> getOutputMap(NodeBuilder node, Map<String, Object> item) {
        Map output = (Map)item.get(OUTPUT);
        LinkedHashMap<String, ExprSetter> apiOutput = new LinkedHashMap<String, ExprSetter>(output.size());
        for (Map.Entry entry : output.entrySet()) {
            Map values = (Map)entry.getValue();
            String var = D.s(values.get(VAR_VALUE));
            if (StringUtil.isEmpty((String)var)) {
                apiOutput.put((String)entry.getKey(), (ExprSetter)null);
                continue;
            }
            apiOutput.put((String)entry.getKey(), ServiceFlowParser.parseExprSetter(node.getFlowBuilder(), var));
        }
        return apiOutput;
    }
}

