/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.Assert;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.sf.res.DataCompResource;
import kd.isc.iscb.platform.core.sf.runtime.n.DataCompApplication;
import kd.isc.iscb.util.dt.CollectionDataType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.VariableBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCompParser
implements NodeParser,
Const {
    public static final String SRC_DATA_VAR = "src_data_var";
    private static final String SCHEMA = "schema";
    private static final String INPUT = "input";
    public static final String PARAM_NAME = "param_name";
    public static final String PARAM_VAR_FIXED = "param_var_fixed";
    public static final String PARAM_VAR = "param_var";

    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        String title = node.getTitle();
        String alias = D.s((Object)item.get(SCHEMA));
        this.checkSchema(title, alias);
        DynamicObject schema = this.getSchema(node, alias);
        Map<String, Object> map = this.getMap(node, item);
        DataCompApplication app = new DataCompApplication(schema, map);
        node.biz((Application)app);
    }

    private DynamicObject getSchema(NodeBuilder node, String alias) {
        FlowBuilder flowBuilder = node.getFlowBuilder();
        Resource resource = ServiceFlowParser.getResource(flowBuilder, alias, node.getTitle());
        if (!(resource instanceof DataCompResource)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%s\uff3d\u4e2d\u5bf9\u6bd4\u65b9\u6848\u8d44\u6e90\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3a\u5bf9\u6bd4\u65b9\u6848\u3002", (String)"DataCompParser_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle()));
        }
        return resource.getDynamicObject();
    }

    private Map<String, Object> getMap(NodeBuilder node, Map<String, Object> item) {
        Map input = (Map)item.get(INPUT);
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        Map<String, Object> dcInput = this.getInputParam(node, input);
        map.put(INPUT, dcInput);
        this.setSrcVar(node, item, map);
        this.setStateVar(node, item, map);
        return map;
    }

    private void setStateVar(NodeBuilder node, Map<String, Object> item, Map<String, Object> map) {
        String state = D.s((Object)item.get("state_var"));
        if (!StringUtil.isEmpty((String)state)) {
            map.put("state_var", ServiceFlowParser.parseExprSetter(node.getFlowBuilder(), state));
        }
    }

    private void setSrcVar(NodeBuilder node, Map<String, Object> item, Map<String, Object> map) {
        String srcVar = D.s((Object)item.get(SRC_DATA_VAR));
        if (!StringUtil.isEmpty((String)srcVar)) {
            map.put(SRC_DATA_VAR, this.getVariableSetterPair(node, srcVar));
        }
    }

    private Map<String, Object> getInputParam(NodeBuilder node, Map<String, Map<String, Object>> input) {
        HashMap<String, Object> dcInput = new HashMap<String, Object>(input.size());
        for (Map.Entry<String, Map<String, Object>> m : input.entrySet()) {
            String paramsName = D.s((Object)m.getValue().get(PARAM_NAME));
            String value = D.s((Object)m.getValue().get(PARAM_VAR_FIXED));
            String expr = D.s((Object)m.getValue().get(PARAM_VAR));
            if (!StringUtil.isEmpty((String)value)) {
                dcInput.put(paramsName, new ExprGetter(value, null));
                continue;
            }
            if (!StringUtil.isEmpty((String)expr)) {
                dcInput.put(paramsName, ServiceFlowParser.parseExprGetter(node.getFlowBuilder(), expr));
                continue;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%s\uff3d\u4e2d\u5bf9\u6bd4\u65b9\u6848\u7684\u8f93\u5165\u53c2\u6570\u56fa\u5b9a\u503c\u548c\u53d8\u91cf\u81f3\u5c11\u914d\u7f6e\u4e00\u9879\u3002", (String)"DataCompParser_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle()));
        }
        return dcInput;
    }

    private Pair<ExprSetter, Boolean> getVariableSetterPair(NodeBuilder node, String var) {
        ExprSetter setter = null;
        Boolean isArray = Boolean.FALSE;
        if (var != null) {
            String varName = this.getVarName(var);
            VariableBuilder builder = node.getVariable(varName);
            Assert.notNull((Object)builder, (String)String.format(ResManager.loadKDString((String)"\u8282\u70b9[%1$s]\u7684\u6d41\u7a0b\u53d8\u91cf%2$s\u4e0d\u5b58\u5728!", (String)"DataCompParser_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle(), varName));
            if (builder.getDataType() instanceof CollectionDataType) {
                isArray = Boolean.TRUE;
            }
            setter = ServiceFlowParser.parseExprSetter(node.getFlowBuilder(), var);
        }
        return new Pair(setter, (Object)isArray);
    }

    private String getVarName(String varText) {
        int index = varText.indexOf(46);
        return index > 0 ? varText.substring(0, index) : varText;
    }

    private void checkSchema(String title, String alias) {
        if (StringUtil.isEmpty((String)alias)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6cbb\u7406\u8282\u70b9[%s]\u7684\u5bf9\u6bd4\u65b9\u6848\u4e3a\u5fc5\u586b\u9879\u3002", (String)"DataCompParser_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title));
        }
    }
}

