/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.sf.res.DataCopyTriggerResource;
import kd.isc.iscb.platform.core.sf.runtime.n.DataCopyTriggerApplication;
import kd.isc.iscb.platform.core.sf.util.ExprUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.VariableBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;

public class DataCopyTriggerParser
implements NodeParser,
Const {
    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        DataCopyTriggerApplication app;
        FlowBuilder flowBuilder = node.getFlowBuilder();
        String prefixMsg = String.format(ResManager.loadKDString((String)"\u6807\u9898\u4e3a[%s]\u7684\u542f\u52a8\u65b9\u6848\u8282\u70b9", (String)"DataCopyTriggerParser_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle());
        Map dcTrigger = (Map)item.get("dc_trigger");
        this.checkTriggerNotNull(prefixMsg, dcTrigger);
        String triggerVar = D.s(dcTrigger.get("var"));
        Resource resource = ServiceFlowParser.getResource(flowBuilder, triggerVar, node.getTitle());
        this.checkTriggerVarTypeValid(prefixMsg, triggerVar, resource);
        DynamicObject trigger = resource.getDynamicObject();
        this.checkTriggerExists(prefixMsg, triggerVar, trigger);
        ExprSetter executionVarSetter = this.getExprSetter(node, item, "execution_var", prefixMsg);
        ExprSetter stateVarSetter = this.getExprSetter(node, item, "state_var", prefixMsg);
        if ("filters".equals(item.get("filter_type"))) {
            List<Map<String, Object>> filterList = this.getFilters(item, flowBuilder, triggerVar, trigger);
            app = new DataCopyTriggerApplication(trigger, filterList, executionVarSetter, stateVarSetter);
        } else {
            Map<String, Object> paramGetterMap = this.getParams(item, flowBuilder, prefixMsg, trigger);
            app = new DataCopyTriggerApplication(trigger, paramGetterMap, executionVarSetter, stateVarSetter);
        }
        node.biz((Application)app);
    }

    private List<Map<String, Object>> getFilters(Map<String, Object> item, FlowBuilder builder, String var, DynamicObject trigger) {
        List filterList = (List)item.get("filter_entries");
        if (CollectionUtils.isEmpty((Collection)filterList)) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848%s\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u6267\u884c!", (String)"DataCopyTriggerParser_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), var));
        }
        ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>(item.size());
        for (Map map : filterList) {
            HashMap<String, ExprGetter> temp = new HashMap<String, ExprGetter>(map);
            String value = D.s(map.get("filter_value_fixed"));
            if (value != null) {
                temp.put("filter_value", new ExprGetter(value, null));
            } else {
                String expr = D.s(map.get("filter_value_var"));
                temp.put("filter_value", ExprUtil.eval(expr, builder, trigger));
            }
            filters.add(temp);
        }
        return filters;
    }

    private Map<String, Object> getParams(Map<String, Object> item, FlowBuilder builder, String prefixMsg, DynamicObject trigger) {
        List paramEntries = (List)item.get("param_entries");
        this.checkParamEntriesNotEmpty(prefixMsg, paramEntries);
        HashMap<String, Object> paramGetterMap = new HashMap<String, Object>(paramEntries.size());
        for (Map m : paramEntries) {
            String paramsName = D.s(m.get("params_name"));
            String value = D.s(m.get("variables_value_fixed"));
            if (value == null) {
                String expr = D.s(m.get("variables_value"));
                paramGetterMap.put(paramsName, ExprUtil.eval(expr, builder, trigger));
                continue;
            }
            paramGetterMap.put(paramsName, new ExprGetter(value, null));
        }
        return paramGetterMap;
    }

    private void checkParamEntriesNotEmpty(String prefixMsg, List<Map<String, Object>> paramEntries) {
        if (paramEntries == null || paramEntries.size() == 0) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%s\u7684\u53c2\u6570\u5206\u5f55\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u6267\u884c", (String)"DataCopyTriggerParser_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), prefixMsg));
        }
    }

    private void checkTriggerExists(String prefixMsg, String triggerVar, DynamicObject trigger) {
        if (trigger == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%1$s\u6839\u636e\u53d8\u91cf[%2$s]\u83b7\u53d6\u5230\u7684\u542f\u52a8\u65b9\u6848\u4e3a\u7a7a", (String)"DataCopyTriggerParser_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), prefixMsg, triggerVar));
        }
    }

    private void checkTriggerVarTypeValid(String prefixMsg, String triggerVar, Resource resource) {
        if (!(resource instanceof DataCopyTriggerResource)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u53d8\u91cf[%2$s]\u7684\u7c7b\u578b\u4e0d\u662f\u542f\u52a8\u65b9\u6848\u7c7b\u578b\uff0c\u800c\u662f%3$s", (String)"DataCopyTriggerParser_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), prefixMsg, triggerVar, resource.getClass()));
        }
    }

    private void checkTriggerNotNull(String prefixMsg, Map<String, Object> dcTrigger) {
        if (dcTrigger == null || D.s((Object)dcTrigger.get("var")) == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%s\u5fc5\u987b\u9009\u62e9\u4e00\u4e2a\u542f\u52a8\u65b9\u6848\u7c7b\u578b\u8d44\u6e90\u3002", (String)"DataCopyTriggerParser_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), prefixMsg));
        }
    }

    private ExprSetter getExprSetter(NodeBuilder node, Map<String, Object> item, String varName, String prefixMsg) {
        ExprSetter setter = null;
        String expr = D.s((Object)item.get(varName));
        if (expr != null) {
            this.checkFlowVar(node, expr, prefixMsg);
            setter = ServiceFlowParser.parseExprSetter(node.getFlowBuilder(), expr);
        }
        return setter;
    }

    private void checkFlowVar(NodeBuilder node, String executionVar, String prefixMsg) {
        VariableBuilder builder = node.getVariable(executionVar);
        if (builder == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"%1$s\u7684\u6d41\u7a0b\u53d8\u91cf%2$s\u4e0d\u5b58\u5728!", (String)"DataCopyTriggerParser_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), prefixMsg, executionVar));
        }
    }
}

