/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.DataTypeCategory;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.sf.runtime.n.FieldMappingApplication;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.VariableBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.misc.StringUtil;

public class FieldMappingParser
implements NodeParser,
Const {
    private static final String FIELD_VALUE_CONVER_RULE = "value_conver_rule";
    private static final String MAPPING_ENTRIES = "mapping_entries";

    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        Map src = (Map)item.get("source_schema");
        Map tar = (Map)item.get("target_schema");
        if (src == null || tar == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%s\uff3d\u6e90\u5bf9\u8c61\u6216\u76ee\u6807\u5bf9\u8c61\u53d8\u91cf\u4e3a\u5fc5\u586b\u9879\u3002", (String)"FieldMappingParser_14", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle()));
        }
        String srcName = D.s(src.get("var"));
        String tarName = D.s(tar.get("var"));
        String title = D.s((Object)item.get("title"));
        List array = (List)item.get(MAPPING_ENTRIES);
        DynamicObject schema = this.createSchema(node, srcName, tarName, array);
        this.checkVariables(node, srcName, tarName, title);
        FieldMappingApplication app = new FieldMappingApplication(schema, srcName, tarName, title, node.getVariable(tarName).isArray(), D.x((Object)item.get("is_safe_mode")));
        node.biz((Application)app);
    }

    private void checkVariables(NodeBuilder node, String srcVarName, String tarVarName, String title) {
        VariableBuilder srcVariable = node.getVariable(srcVarName);
        VariableBuilder tarVariable = node.getVariable(tarVarName);
        if (srcVariable == null || tarVariable == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9 (%1$s) ,\u6765\u6e90\u6570\u636e\u53d8\u91cf(%2$s)\u4e0d\u5b58\u5728", (String)"FieldMappingParser_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title, srcVariable == null ? srcVarName : tarVarName));
        }
    }

    private DynamicObject createSchema(NodeBuilder node, String srcName, String tarName, List<Map<String, Object>> array) {
        FlowBuilder flow = node.getFlowBuilder();
        VariableBuilder srcVar = flow.getVariable(srcName);
        Assert.notNull((Object)srcVar, (String)String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%1$s\uff3d\u6e90\u5bf9\u8c61\u53d8\u91cf\uff08%2$s\uff09\u4e0d\u5b58\u5728", (String)"FieldMappingParser_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle(), srcName));
        VariableBuilder tarVar = flow.getVariable(tarName);
        Assert.notNull((Object)tarVar, (String)String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%1$s\uff3d\u76ee\u6807\u5bf9\u8c61\u53d8\u91cf\uff08%2$s\uff09\u4e0d\u5b58\u5728", (String)"FieldMappingParser_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle(), tarName));
        Map<String, Object> srcVarDef = ServiceFlowParser.getDefine(srcVar);
        boolean srcVarIsMeta = DataTypeCategory.ISC_METADATA_SCHEMA.name().equals(srcVarDef.get("category"));
        Assert.isTrue((boolean)srcVarIsMeta, (String)String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%1$s\uff3d\u6e90\u5bf9\u8c61\u53d8\u91cf\uff08%2$s\uff09\u7684\u7c7b\u522b\u4e0d\u662f\u96c6\u6210\u5bf9\u8c61\uff01", (String)"FieldMappingParser_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle(), srcName));
        long srcId = D.l((Object)srcVarDef.get("type"));
        Assert.isTrue((srcId > 0L ? 1 : 0) != 0, (String)String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%1$s\uff3d\u6e90\u5bf9\u8c61\u53d8\u91cf\uff08%2$s\uff09\u5728\u6d41\u7a0b\u5c5e\u6027\u4e2d\u7684\u96c6\u6210\u5bf9\u8c61\u672a\u6307\u5b9a\uff01", (String)"FieldMappingParser_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle(), srcName));
        Map<String, Object> tarVarDef = ServiceFlowParser.getDefine(tarVar);
        boolean tarVarIsMeta = DataTypeCategory.ISC_METADATA_SCHEMA.name().equals(tarVarDef.get("category"));
        Assert.isTrue((boolean)tarVarIsMeta, (String)String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%1$s\uff3d\u76ee\u6807\u5bf9\u8c61\u53d8\u91cf\uff08%2$s\uff09\u7684\u7c7b\u522b\u4e0d\u662f\u96c6\u6210\u5bf9\u8c61\uff01", (String)"FieldMappingParser_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle(), tarName));
        long tarId = D.l((Object)tarVarDef.get("type"));
        Assert.isTrue((tarId > 0L ? 1 : 0) != 0, (String)String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%1$s\uff3d\u76ee\u6807\u5bf9\u8c61\u53d8\u91cf\uff08%2$s\uff09\u5728\u6d41\u7a0b\u5c5e\u6027\u4e2d\u7684\u96c6\u6210\u5bf9\u8c61\u672a\u6307\u5b9a\uff01", (String)"FieldMappingParser_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle(), tarName));
        DynamicObject isc_metadata_schema = MetaDataSchema.get(srcId);
        DynamicObject tar_metadata_schema = MetaDataSchema.get(tarId);
        DynamicObject dc = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_copy");
        DynamicObjectCollection mappingEntries = dc.getDynamicObjectCollection(MAPPING_ENTRIES);
        if (!CollectionUtils.isEmpty(array)) {
            for (Map<String, Object> map : array) {
                DynamicObject entry = mappingEntries.addNew();
                entry.set("mapping_tar_column", map.get("mapping_tar_column"));
                entry.set("tar_desc", map.get("tar_desc"));
                entry.set("candidate_key", map.get("candidate_key"));
                entry.set("fixed_value", map.get("fixed_value"));
                entry.set("mapping_src_column", map.get("mapping_src_column"));
                entry.set("src_desc", map.get("src_desc"));
                entry.set("aggr_fn", map.get("aggr_fn"));
                String value_conver_rule = D.s((Object)map.get(FIELD_VALUE_CONVER_RULE));
                if (!StringUtil.isEmpty((String)value_conver_rule)) {
                    Resource rule = ServiceFlowParser.getResource(node.getFlowBuilder(), value_conver_rule, node.getTitle());
                    Assert.notNull((Object)rule, (String)String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%1$s\uff3d\u7684\u503c\u8f6c\u6362\u89c4\u5219\uff08%2$s\uff09\u4e0d\u5b58\u5728", (String)"FieldMappingParser_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle(), value_conver_rule));
                    boolean equals = "isc_value_conver_rule".equals(rule.getCategory().getEntityType());
                    Assert.isTrue((boolean)equals, (String)String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff3b%1$s\uff3d\u7684\u522b\u540d\u4e3a\uff08%2$s\uff09\u4e0d\u662f\u503c\u8f6c\u6362\u89c4\u5219\u7c7b\u578b\uff01", (String)"FieldMappingParser_23", (String)"isc-iscb-platform-core", (Object[])new Object[0]), node.getTitle(), value_conver_rule));
                    entry.set(FIELD_VALUE_CONVER_RULE, (Object)rule.getDynamicObject());
                    continue;
                }
                entry.set(FIELD_VALUE_CONVER_RULE, null);
            }
        }
        dc.set("source_schema_id", (Object)srcId);
        dc.set("target_schema_id", (Object)tarId);
        dc.set("data_source_id", (Object)isc_metadata_schema.getLong("group_id"));
        dc.set("data_target_id", (Object)tar_metadata_schema.getLong("group_id"));
        dc.set("status", (Object)"C");
        dc.set("enable", (Object)"1");
        dc.set("mode", (Object)"ResumeOnError");
        dc.set("number", (Object)("field_mapping_" + srcName + "-" + tarName + "_tmp_schema"));
        dc.set("name", (Object)ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u5b57\u6bb5\u6620\u5c04\u8282\u70b9\u4ea7\u751f\u7684\u4e34\u65f6\u65b9\u6848", (String)"FieldMappingParser_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        dc.set(MAPPING_ENTRIES, (Object)mappingEntries);
        return dc;
    }
}

