/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.sf.runtime.n.RPAApplication;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.misc.StringUtil;

public class RPANodeParser
implements NodeParser,
Const {
    private static final String OUTPUT = "output";
    private static final String RPA_FLOW = "rpa_flow";
    private static final String RPA_ROBOT = "rpa_robot";
    private static final String RPA_ROBOT_ID = "rpa_robot_id";
    public static final String PARAM_VAR_FIXED = "param_var_fixed";
    public static final String PARAM_VAR = "param_var";

    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        RPAApplication app;
        String title = node.getTitle();
        String number = D.s((Object)item.get(RPA_FLOW));
        String robotId = D.s((Object)item.get(RPA_ROBOT_ID));
        String version = D.s((Object)item.get("version"));
        if (StringUtil.isEmpty((String)title) || StringUtil.isEmpty((String)number) || StringUtil.isEmpty((String)robotId) || StringUtil.isEmpty((String)version)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\u3010%s\u3011\u672a\u914d\u7f6e", (String)"RPANodeParser_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title));
        }
        Map<String, Object> map = this.getInputMap(node, item);
        String output = D.s((Object)item.get(OUTPUT));
        if (!StringUtil.isEmpty((String)output)) {
            ExprSetter exprSetter = ServiceFlowParser.parseExprSetter(node.getFlowBuilder(), output);
            app = new RPAApplication(number, robotId, version, map, exprSetter);
        } else {
            app = new RPAApplication(number, robotId, version, map);
        }
        node.biz((Application)app);
    }

    private Map<String, Object> getInputMap(NodeBuilder node, Map<String, Object> item) {
        Map input = (Map)item.get("input");
        LinkedHashMap<String, Object> rpaInput = new LinkedHashMap<String, Object>(input.size());
        for (Map.Entry entry : input.entrySet()) {
            Map values = (Map)entry.getValue();
            String fixed = (String)values.get(PARAM_VAR_FIXED);
            String var = (String)values.get(PARAM_VAR);
            if (!StringUtil.isEmpty((String)fixed)) {
                rpaInput.put((String)entry.getKey(), new ExprGetter(fixed, null));
                continue;
            }
            if (StringUtil.isEmpty((String)var)) continue;
            rpaInput.put((String)entry.getKey(), ServiceFlowParser.parseExprGetter(node.getFlowBuilder(), var));
        }
        return rpaInput;
    }
}

