/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.parser.n;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.api.webapi.WebApi;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.NodeParser;
import kd.isc.iscb.platform.core.sf.runtime.n.WebApiApplication;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.FlowBuilder;
import kd.isc.iscb.util.flow.core.NodeBuilder;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.misc.StringUtil;

public class WebApiInvokerParser
implements NodeParser,
Const {
    @Override
    public void parse(NodeBuilder node, Map<String, Object> item) {
        String title = node.getTitle();
        Map webapiConfig = (Map)item.get("webapi_config");
        if (webapiConfig == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"WebAPI\u8c03\u7528\u8282\u70b9\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u6253\u5f00\u6d41\u7a0b\u56fe\u68c0\u67e5[%s]\u8282\u70b9\u3002", (String)"WebApiInvokerParser_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title));
        }
        String webapiAlias = D.s(webapiConfig.get("webapi"));
        this.checkWebapi(title, webapiAlias);
        FlowBuilder flowBuilder = node.getFlowBuilder();
        Resource resource = ServiceFlowParser.getResource(flowBuilder, webapiAlias, title);
        long id = resource.getId();
        WebApi webApi = WebApi.get(id);
        DynamicObject obj = webApi.getCfg();
        Map<String, ExprGetter> urlParams = this.getUrlParams(node, webapiConfig);
        Map<String, ExprGetter> reqHeader = this.getReqHeader(node, webapiConfig);
        Map<String, ExprGetter> reqBody = this.getReqBody(node, webapiConfig, obj);
        Map<String, ExprSetter> respBody = this.getRespBody(node, webapiConfig);
        WebApiApplication app = new WebApiApplication(id, urlParams, reqHeader, reqBody, respBody);
        node.biz((Application)app);
    }

    private void checkWebapi(String title, String webapi) {
        if (StringUtil.isEmpty((String)webapi)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"WebAPI\u8c03\u7528\u8282\u70b9[%s]\u7684WebAPI\u4e3a\u5fc5\u586b\u9879\u3002", (String)"WebApiInvokerParser_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), title));
        }
    }

    private Map<String, ExprGetter> getUrlParams(NodeBuilder node, Map<String, Object> webapiConfig) {
        Map params = (Map)webapiConfig.get("urlParams");
        LinkedHashMap<String, ExprGetter> result = new LinkedHashMap<String, ExprGetter>(params.size());
        for (Map.Entry entry : params.entrySet()) {
            Map values = (Map)entry.getValue();
            if (!D.x(values.get("param_need"))) continue;
            String fixed = (String)values.get("param_fixed_value");
            String var = (String)values.get("param_var");
            if (!StringUtil.isEmpty((String)fixed)) {
                result.put((String)entry.getKey(), new ExprGetter(fixed, null));
                continue;
            }
            if (!StringUtil.isEmpty((String)var)) {
                result.put((String)entry.getKey(), ServiceFlowParser.parseExprGetter(node.getFlowBuilder(), var));
                continue;
            }
            result.put((String)entry.getKey(), (ExprGetter)null);
        }
        return result;
    }

    private Map<String, ExprGetter> getReqHeader(NodeBuilder node, Map<String, Object> webapiConfig) {
        Map params = (Map)webapiConfig.get("reqHeader");
        LinkedHashMap<String, ExprGetter> result = new LinkedHashMap<String, ExprGetter>(params.size());
        for (Map.Entry entry : params.entrySet()) {
            Map values = (Map)entry.getValue();
            if (!D.x(values.get("header_need"))) continue;
            String fixed = (String)values.get("header_fixed_value");
            String var = (String)values.get("header_var");
            if (!StringUtil.isEmpty((String)fixed)) {
                result.put((String)entry.getKey(), new ExprGetter(fixed, null));
                continue;
            }
            if (!StringUtil.isEmpty((String)var)) {
                result.put((String)entry.getKey(), ServiceFlowParser.parseExprGetter(node.getFlowBuilder(), var));
                continue;
            }
            result.put((String)entry.getKey(), (ExprGetter)null);
        }
        return result;
    }

    private Map<String, ExprGetter> getReqBody(NodeBuilder node, Map<String, Object> webapiConfig, DynamicObject obj) {
        DynamicObjectCollection webReqBodyEntries = obj.getDynamicObjectCollection("web_req_body");
        Map params = (Map)webapiConfig.get("reqBody");
        LinkedHashMap<String, ExprGetter> result = new LinkedHashMap<String, ExprGetter>(params.size());
        for (Map.Entry entry : params.entrySet()) {
            Map values = (Map)entry.getValue();
            if (!this.needBuildGetter((String)entry.getKey(), webReqBodyEntries)) continue;
            String fixed = (String)values.get("body_fixed_value");
            String var = (String)values.get("body_var");
            if (!StringUtil.isEmpty((String)fixed)) {
                result.put((String)entry.getKey(), new ExprGetter(fixed, null));
                continue;
            }
            if (!StringUtil.isEmpty((String)var)) {
                result.put((String)entry.getKey(), ServiceFlowParser.parseExprGetter(node.getFlowBuilder(), var));
                continue;
            }
            result.put((String)entry.getKey(), (ExprGetter)null);
        }
        return result;
    }

    private boolean needBuildGetter(String name, DynamicObjectCollection webReqBodyEntries) {
        boolean flag = false;
        for (DynamicObject entry : webReqBodyEntries) {
            String value;
            if (!entry.getString("req_b_param_name").equals(name) || (value = D.s((Object)entry.get("req_b_param_value"))) != null || D.l((Object)entry.get("pid")) != 0L) continue;
            flag = true;
        }
        return flag;
    }

    private Map<String, ExprSetter> getRespBody(NodeBuilder node, Map<String, Object> webapiConfig) {
        Map params = (Map)webapiConfig.get("respBody");
        LinkedHashMap<String, ExprSetter> result = new LinkedHashMap<String, ExprSetter>(params.size());
        for (Map.Entry entry : params.entrySet()) {
            Map values = (Map)entry.getValue();
            String var = (String)values.get("resp_body_var");
            if (StringUtil.isEmpty((String)var)) {
                result.put((String)entry.getKey(), (ExprSetter)null);
                continue;
            }
            result.put((String)entry.getKey(), ServiceFlowParser.parseExprSetter(node.getFlowBuilder(), var));
        }
        return result;
    }
}

