/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.res;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.script.ScriptContext;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.parser.ResourceCategory;
import kd.isc.iscb.util.except.IscBizException;

public class DataSourceResource
extends Resource {
    private static final ThreadLocal<LinkedList<Map<Long, ConnectionWrapper>>> stack = new ThreadLocal();

    public DataSourceResource(ResourceCategory category, long id, String name, String title) {
        super(category, id, name, title);
    }

    public ConnectionWrapper eval(ScriptContext ctx) {
        return DataSourceResource.getConnection(this.getId());
    }

    public static ConnectionWrapper getConnection(Long dataSourceId) {
        Long dbLink = DataSourceResource.getDbLink(dataSourceId);
        return DataSourceResource.getConnectionByDbLink(dbLink);
    }

    public static ConnectionWrapper getConnectionByDbLink(Long dbLink) {
        Map<Long, ConnectionWrapper> map = DataSourceResource.getConnectionPool();
        ConnectionWrapper cn = map.get(dbLink);
        if (cn == null) {
            cn = ConnectionManager.getConnection(dbLink);
            map.put(dbLink, cn);
        }
        return cn;
    }

    private static Long getDbLink(Long dataSourceId) {
        return DataSource.get(dataSourceId).getDbLink();
    }

    private static Map<Long, ConnectionWrapper> getConnectionPool() {
        return DataSourceResource.top();
    }

    public static void createConnectionPool() {
        DataSourceResource.push(new LinkedHashMap<Long, ConnectionWrapper>());
    }

    public static boolean isReady() {
        return stack.get() != null;
    }

    public static void disposeConnectionPool() {
        Resource.dispose();
        Map<Long, ConnectionWrapper> map = DataSourceResource.pop();
        for (ConnectionWrapper cn : map.values()) {
            ConnectorUtil.close(cn);
        }
    }

    private static void push(Map<Long, ConnectionWrapper> o) {
        LinkedList<Map<Long, ConnectionWrapper>> list = stack.get();
        if (list == null) {
            list = new LinkedList();
            stack.set(list);
        }
        list.addLast(o);
    }

    private static Map<Long, ConnectionWrapper> pop() {
        LinkedList<Map<Long, ConnectionWrapper>> list = stack.get();
        if (list == null) {
            throw new IscBizException("Stack is not initiated.");
        }
        Map<Long, ConnectionWrapper> o = list.removeLast();
        if (list.size() == 0) {
            stack.remove();
        }
        return o;
    }

    private static Map<Long, ConnectionWrapper> top() {
        LinkedList<Map<Long, ConnectionWrapper>> list = stack.get();
        if (list == null) {
            throw new IscBizException("Stack is not initiated.");
        }
        return list.getLast();
    }
}

