/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.sf.parser.n.SubFlowInlined;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.sf.runtime.ProcessState;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.connector.s.QueryList;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Node;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.NodeExecutionSync;
import kd.isc.iscb.util.script.LifeScriptEngine;

public class ActivitySync
implements NodeExecutionSync {
    private static final String PRIOR_SYNC_TIME = "prior_sync_time";
    private static final String KEY_STATE = "state";
    public static final String KEY_START_TIME = "start_time";
    public static final String KEY_END_TIME = "end_time";
    public static final String KEY_ELAPSED = "elapsed";
    public static final String KEY_TOTAL_ELAPSED = "total_elapsed";
    public static final String KEY_INFO = "info";

    public String newId(VariableScope define, FlowRuntime runtime) {
        return null;
    }

    public void begin(Execution e) {
        this.setPath(e);
        ActivitySync.setState(e, KEY_STATE, "arrived");
        this.increaseCounter(e);
    }

    public void complete(Execution e) {
        String state = D.x((Object)e.getProperty("manual_complete")) ? "manual_complete" : "complete";
        ActivitySync.setState(e, KEY_STATE, state);
        ActivitySync.setState(e, KEY_END_TIME, new Timestamp(System.currentTimeMillis()).toString());
        this.setElapsedTime(e);
    }

    public void suspend(Execution e) {
        ActivitySync.setState(e, KEY_STATE, "suspended");
    }

    public void resume(Execution e) {
        ActivitySync.setState(e, KEY_STATE, "running");
    }

    public void fail(Execution e) {
        ActivitySync.setState(e, KEY_STATE, "failed");
        ActivitySync.setState(e, KEY_END_TIME, new Timestamp(System.currentTimeMillis()).toString());
        this.setElapsedTime(e);
    }

    public void terminate(Execution e) {
        if (!"complete".equals(ActivitySync.getState(e, KEY_STATE))) {
            ActivitySync.setState(e, KEY_STATE, "terminated");
        }
        ActivitySync.setState(e, KEY_END_TIME, new Timestamp(System.currentTimeMillis()).toString());
    }

    public void reenter(Execution e) {
        this.setPath(e);
    }

    public void ready(Execution e) {
        ActivitySync.setState(e, KEY_STATE, "ready");
        ActivitySync.setState(e, KEY_START_TIME, new Timestamp(System.currentTimeMillis()).toString());
    }

    private long getPriorSyncTime(FlowRuntime runtime) {
        Long prior = (Long)runtime.getTransientProperty(PRIOR_SYNC_TIME);
        if (prior == null) {
            prior = LifeScriptEngine.getNow();
            runtime.setTransientProperty(PRIOR_SYNC_TIME, (Object)prior);
        }
        return prior;
    }

    static void setAppStarted(Execution e) {
        Node node = (Node)e.getDefine();
        if (node.getChildren().isEmpty() && node.getCallback() == null && node.getAttribute("SUB_FLOW_ID") == null) {
            ActivitySync.setState(e, KEY_STATE, "complete");
        } else {
            ActivitySync.setState(e, KEY_STATE, "started");
        }
    }

    static void setPriorSyncTime(FlowRuntime runtime) {
        runtime.setTransientProperty(PRIOR_SYNC_TIME, (Object)LifeScriptEngine.getNow());
    }

    public void started(Execution e) {
        ActivitySync.setAppStarted(e);
        FlowRuntime runtime = e.getRuntime();
        long prior = this.getPriorSyncTime(runtime);
        int time = Math.max(D.i((Object)e.getRuntime().getFlow().getAttribute("auto_save_time")), 5) * 1000;
        if (LifeScriptEngine.getNow() - prior >= (long)time) {
            int threshold;
            long procInstId = Long.parseLong(runtime.getId());
            int length = ProcessRuntime.saveState(procInstId, runtime, ProcessState.Running);
            if (length > (threshold = QueryList.getResultSetMaxSize())) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u7684\u4e0a\u4e0b\u6587\u5185\u5bb9\u8d85\u8fc7\u4e86\u4e0a\u9650\u201c%s\u5b57\u7b26\u201d\u3002\u5efa\u8bae\u89e3\u51b3\u529e\u6cd5\uff1a\u8c03\u6574\u670d\u52a1\u6d41\u7a0b\u8bbe\u8ba1\uff0c\u51cf\u5c11\u6d41\u7a0b\u53d8\u91cf\u4e2d\u5b58\u653e\u7684\u5185\u5bb9\uff1b\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574JVM\u7cfb\u7edf\u53c2\u6570 ISC_QUERY_MAX_SIZE \u589e\u52a0\u4e0a\u9650\u3002", (String)"ActivitySync_13", (String)"isc-iscb-platform-core", (Object[])new Object[0]), threshold));
            }
            ActivitySync.setPriorSyncTime(runtime);
        }
    }

    public void leapOver(Execution e) {
        ActivitySync.setState(e, KEY_STATE, "ignored");
        ActivitySync.setState(e, KEY_END_TIME, new Timestamp(System.currentTimeMillis()).toString());
        this.setElapsedTime(e);
    }

    private void setElapsedTime(Execution e) {
        Timestamp started = D.t((Object)ActivitySync.getState(e, KEY_START_TIME));
        if (started == null) {
            return;
        }
        long elapsed = System.currentTimeMillis() - started.getTime();
        if (elapsed <= 0L) {
            return;
        }
        long total_elapsed = D.l((Object)ActivitySync.getState(e, KEY_TOTAL_ELAPSED)) + elapsed;
        ActivitySync.setState(e, KEY_ELAPSED, String.valueOf(elapsed));
        ActivitySync.setState(e, KEY_TOTAL_ELAPSED, String.valueOf(total_elapsed));
    }

    public static String getState(Execution e, String key) {
        String name = ActivitySync.getStatePropertyName(e, "acts");
        Map acts = (Map)e.getRuntime().getProperty(name);
        if (acts == null) {
            return null;
        }
        String id = e.getDefine().getId();
        Map info = (Map)acts.get(id);
        if (info == null) {
            return null;
        }
        return (String)info.get(key);
    }

    public static void setState(Execution e, String key, String value) {
        String id;
        HashMap<String, String> info;
        String name = ActivitySync.getStatePropertyName(e, "acts");
        LinkedHashMap<String, HashMap<String, String>> acts = (LinkedHashMap<String, HashMap<String, String>>)e.getRuntime().getProperty(name);
        if (acts == null) {
            acts = new LinkedHashMap<String, HashMap<String, String>>();
            e.getRuntime().setProperty(name, acts);
        }
        if ((info = (HashMap<String, String>)acts.get(id = e.getDefine().getId())) == null) {
            info = new HashMap<String, String>();
        }
        info.put(key, value);
        acts.put(id, info);
    }

    public static void recordSubFlowId(Execution e, String subFlowId) {
        String name = ActivitySync.getStatePropertyName(e, "subflows");
        LinkedHashMap<String, String> subflows = (LinkedHashMap<String, String>)e.getRuntime().getProperty(name);
        if (subflows == null) {
            subflows = new LinkedHashMap<String, String>();
            e.getRuntime().setProperty(name, subflows);
        }
        subflows.put(e.getDefine().getId(), subFlowId);
    }

    public static Map<String, Object> getTraceInfo(FlowRuntime runtime, String nodeId) {
        Map info;
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
        data.put(ResManager.loadKDString((String)"\u8282\u70b9\u540d\u79f0", (String)"ActivitySync_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), runtime.getFlow().getNode(nodeId).getTitle());
        Map acts = (Map)runtime.getProperty("acts");
        if (acts != null && (info = (Map)acts.get(nodeId)) != null) {
            data.put(ResManager.loadKDString((String)"\u8282\u70b9\u72b6\u6001", (String)"ActivitySync_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), info.get(KEY_STATE));
            int count = D.i(info.get("count"));
            if (count <= 1) {
                data.put(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4", (String)"ActivitySync_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), info.get(KEY_START_TIME));
                data.put(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4", (String)"ActivitySync_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), info.get(KEY_END_TIME));
                data.put(ResManager.loadKDString((String)"\u6267\u884c\u8017\u65f6", (String)"ActivitySync_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), TraceType.getTime(D.i(info.get(KEY_ELAPSED))));
            } else {
                data.put(ResManager.loadKDString((String)"\u6267\u884c\u6b21\u6570", (String)"ActivitySync_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), count);
                data.put(ResManager.loadKDString((String)"\u7d2f\u8ba1\u6267\u884c\u8017\u65f6", (String)"ActivitySync_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]), TraceType.getTime(D.i(info.get(KEY_TOTAL_ELAPSED))));
                data.put(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u6b21\u5f00\u59cb\u65f6\u95f4", (String)"ActivitySync_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), info.get(KEY_START_TIME));
                data.put(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u6b21\u7ed3\u675f\u65f6\u95f4", (String)"ActivitySync_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), info.get(KEY_END_TIME));
                data.put(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u6b21\u6267\u884c\u8017\u65f6", (String)"ActivitySync_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), TraceType.getTime(D.i(info.get(KEY_ELAPSED))));
            }
        }
        return data;
    }

    private void increaseCounter(Execution e) {
        String name = ActivitySync.getStatePropertyName(e, "acts");
        Map acts = (Map)e.getRuntime().getProperty(name);
        String id = e.getDefine().getId();
        Map info = (Map)acts.get(id);
        info.put("count", D.i(info.get("count")) + 1);
    }

    private void setPath(Execution e) {
        String id = e.getTransitionId();
        if (id == null) {
            return;
        }
        String name = ActivitySync.getStatePropertyName(e, "trans");
        LinkedHashMap<String, String> trans = (LinkedHashMap<String, String>)e.getRuntime().getProperty(name);
        if (trans == null) {
            trans = new LinkedHashMap<String, String>();
            e.getRuntime().setProperty(name, trans);
        }
        trans.put(id, "true");
    }

    public static String getStatePropertyName(Execution e, String name) {
        if (e.getDefine().getFlow() == e.getRuntime().getFlow()) {
            return name;
        }
        return ActivitySync.calcSubflowNodeStatePropertyName(e, name);
    }

    private static String calcSubflowNodeStatePropertyName(Execution e, String name) {
        StringBuilder sb = new StringBuilder(name);
        for (Execution parent = e.getParent(); parent != null; parent = parent.getParent()) {
            if (!SubFlowInlined.isSubFlowNode(parent)) continue;
            sb.append('.').append(parent.getDefine().getId());
        }
        return sb.toString();
    }
}

