/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime;

import java.util.Map;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.sf.runtime.AbstractProcessJob;
import kd.isc.iscb.platform.core.sf.runtime.ProcessSignalJobFactory;
import kd.isc.iscb.platform.core.sf.runtime.ProcessState;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.UneatableException;
import kd.isc.iscb.util.flow.core.FlowRuntime;

public final class ProcessSignalJob
extends AbstractProcessJob {
    public static final JobFactory FACTORY = new ProcessSignalJobFactory();
    private Object params;
    private String executionId;

    public ProcessSignalJob(long procInstId, String title, String executionId, Object params, long jobMutex) {
        super(procInstId, title, ProcessState.Waiting, false, jobMutex);
        this.executionId = executionId;
        this.params = params;
    }

    ProcessSignalJob(String title, Map<String, Object> param) {
        super(title, param);
        this.params = param.get("params");
        this.executionId = D.s((Object)param.get("executionId"));
    }

    @Override
    protected final Map<String, Object> getParamMap() {
        Map<String, Object> map = super.getParamMap();
        map.put("params", this.params);
        map.put("executionId", this.executionId);
        return map;
    }

    @Override
    protected void doJob(FlowRuntime runtime) {
        if (this.dataInjected(runtime)) {
            runtime.signal(this.executionId);
        }
    }

    private boolean dataInjected(FlowRuntime runtime) {
        try {
            return runtime.prepare(this.executionId, this.params);
        }
        catch (Throwable e) {
            throw new UneatableException(e);
        }
    }

    @Override
    protected TraceType getTraceType() {
        return TraceType.EXE_SFP;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }
}

