/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime.n;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.res.dc.DataCopySchemaResource;
import kd.isc.iscb.platform.core.sf.util.ExprUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCopySchemaApplication
implements Application {
    private DynamicObject dc;
    private Map<String, Object> params;
    private List<Map<String, Object>> filterList;
    private Pair<ExprSetter, Boolean> srcSetter;
    private Pair<ExprSetter, Boolean> tarSetter;

    private DataCopySchemaApplication(DynamicObject dc, Pair<ExprSetter, Boolean> srcSetter, Pair<ExprSetter, Boolean> tarSetter) {
        this.dc = dc;
        this.srcSetter = srcSetter;
        this.tarSetter = tarSetter;
    }

    public DataCopySchemaApplication(DynamicObject dc, Map<String, Object> params, Pair<ExprSetter, Boolean> srcSetter, Pair<ExprSetter, Boolean> tarSetter) {
        this(dc, srcSetter, tarSetter);
        this.params = params;
    }

    public DataCopySchemaApplication(DynamicObject dc, List<Map<String, Object>> filterList, Pair<ExprSetter, Boolean> srcSetter, Pair<ExprSetter, Boolean> tarSetter) {
        this(dc, srcSetter, tarSetter);
        this.filterList = filterList;
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        block2: {
            DataCopyParam param = CollectionUtils.isEmpty(this.filterList) ? this.initByParams(e) : this.initByFilters(e);
            try {
                Pair<List<Object>, List<Object>> pair = DataCopySchemaResource.doDataCopy(param);
                this.setVarValue(e, this.srcSetter, (List)pair.getA());
                this.setVarValue(e, this.tarSetter, (List)pair.getB());
            }
            catch (Throwable err) {
                this.handleError(err);
                if (!(err instanceof TaskCancelException)) break block2;
                throw err;
            }
        }
    }

    private void handleError(Throwable err) {
        StringBuilder data = new StringBuilder();
        data.append(ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e\uff1a", (String)"DataCopySchemaApplication_4", (String)"isc-iscb-platform-core", (Object[])new Object[0])).append("\r\n");
        data.append(StringUtil.trim((String)Json.toString(DataCopySchemaResource.getLastSrc()), (int)2000)).append("\r\n\r\n");
        data.append(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\uff1a", (String)"DataCopySchemaApplication_5", (String)"isc-iscb-platform-core", (Object[])new Object[0])).append("\r\n");
        data.append(StringUtil.trim((String)Json.toString(DataCopySchemaResource.getLastTar()), (int)2000));
        if (err instanceof IscBizException) {
            IscBizException err2 = (IscBizException)err;
            err2.setData(data.toString());
            throw err2;
        }
        IscBizException err2 = new IscBizException(err.getMessage(), err);
        err2.setData(data.toString());
        throw err2;
    }

    private DataCopyParam initByParams(Execution e) {
        HashMap<String, Object> filterParams = new HashMap<String, Object>(this.params.size());
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            String key = entry.getKey();
            Object value = ExprUtil.evalAssignValue(e, entry.getValue());
            filterParams.put(key, value);
        }
        return new DataCopyParam(this.dc, filterParams);
    }

    private DataCopyParam initByFilters(Execution e) {
        ArrayList<Map<String, Object>> pushFilters = new ArrayList<Map<String, Object>>(this.filterList.size());
        for (Map<String, Object> filter : this.filterList) {
            HashMap<String, Object> temp = new HashMap<String, Object>(filter);
            temp.put("filter_value", ExprUtil.evalAssignValue(e, filter.get("filter_value")));
            pushFilters.add(temp);
        }
        return new DataCopyParam(this.dc, pushFilters);
    }

    private void setVarValue(Execution e, Pair<ExprSetter, Boolean> setter, List<Object> pks) {
        ExprSetter s = (ExprSetter)setter.getA();
        if (s != null) {
            if (((Boolean)setter.getB()).booleanValue()) {
                s.set(e, pks);
            } else if (pks.size() == 1) {
                s.set(e, pks.get(0));
            } else if (pks.size() == 0) {
                s.set(e, null);
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u7684\u8f93\u51fa\u53d8\u91cf%s\u4e0d\u662f\u591a\u503c\u7c7b\u578b\uff0c\u65e0\u6cd5\u63a5\u6536ID\u5217\u8868!", (String)"DataCopySchemaApplication_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), s.getExpr()));
            }
        }
    }

    public String toString() {
        return "DataCopySchemaApplication\uff1a" + this.dc.getString("number");
    }
}

