/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime.n;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.runtime.EventWaitingJob;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.sf.runtime.n.EventWaitingUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.context.Context;

public class EventWaitingApplication
implements Application {
    private Script signalValues;

    public EventWaitingApplication(Script signalValues) {
        this.signalValues = signalValues;
    }

    public void invoke(Execution e) {
        List values = (List)this.signalValues.eval((Context)e);
        if (values.size() == 1 && values.get(0) instanceof List) {
            List<DynamicObject> objs = this.createMultipleSignalObjects(e, (List)values.get(0));
            SaveServiceHelper.save((DynamicObject[])objs.toArray(new DynamicObject[objs.size()]));
            this.createSignalJobs(objs);
            e.setProperty("signal_identifier", this.getSignalIdentifiers(objs));
        } else {
            DynamicObject obj = this.createSingleSignalObject(e, values);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            this.createSignalJob(obj);
            e.setProperty("signal_identifier", this.getSignalIdentifiers(obj));
        }
    }

    private List<String> getSignalIdentifiers(List<DynamicObject> objs) {
        ArrayList<String> ids = new ArrayList<String>(objs.size());
        for (DynamicObject obj : objs) {
            ids.add(obj.getString("signal_identifier"));
        }
        return ids;
    }

    private Object getSignalIdentifiers(DynamicObject obj) {
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(obj.getString("signal_identifier"));
        return ids;
    }

    private List<DynamicObject> createMultipleSignalObjects(Execution e, List<?> list) {
        String nodeTitle = e.getDefine().getTitle();
        if (list.isEmpty()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%s\uff09\u7684\u7b49\u5f85\u503c\u662f\u5217\u8868\uff0c\u4f46\u5217\u8868\u662f\u7a7a\u7684\u3002", (String)"EventWaitingApplication_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), nodeTitle));
        }
        String node_id = e.getDefine().getId();
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(list.size());
        long service_flow = ServiceFlowParser.getServiceFlowId(e.getDefine().getFlow());
        for (Object value : list) {
            List<?> values = Collections.singletonList(value);
            String signal_identifier = EventWaitingUtil.calcSignalIdentifier(values, nodeTitle);
            int hashCode = EventWaitingUtil.calcSignalHash(service_flow, node_id, signal_identifier);
            objs.add(this.prepareSignalObject(e, node_id, signal_identifier, service_flow, hashCode));
        }
        return objs;
    }

    private DynamicObject createSingleSignalObject(Execution e, List<?> values) {
        String node_id = e.getDefine().getId();
        String nodeTitle = e.getDefine().getTitle();
        String signal_identifier = EventWaitingUtil.calcSignalIdentifier(values, nodeTitle);
        long service_flow = ServiceFlowParser.getServiceFlowId(e.getDefine().getFlow());
        int hashCode = EventWaitingUtil.calcSignalHash(service_flow, node_id, signal_identifier);
        DynamicObject obj = this.prepareSignalObject(e, node_id, signal_identifier, service_flow, hashCode);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSignalJob(DynamicObject obj) {
        String sql = "SELECT fid FROM t_isc_sf_waiting_data WHERE fhash_code=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            int hashCode = obj.getInt("hash_code");
            if (DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(hashCode), Collections.singletonList(4)) != null) {
                Timestamp scheduledTime = new Timestamp(System.currentTimeMillis() + 5000L);
                JobEngine.submit(new EventWaitingJob(hashCode, "PULL:" + hashCode), scheduledTime);
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSignalJobs(List<DynamicObject> objs) {
        StringBuilder sql = new StringBuilder("SELECT fhash_code FROM t_isc_sf_waiting_data WHERE fhash_code IN( 0");
        ArrayList<Integer> params = new ArrayList<Integer>(objs.size());
        ArrayList<Integer> types = new ArrayList<Integer>(objs.size());
        for (DynamicObject obj : objs) {
            sql.append(", ?");
            params.add(obj.getInt("hash_code"));
            types.add(4);
        }
        sql.append(" )");
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql.toString(), params, types)) {
                Timestamp scheduledTime = new Timestamp(System.currentTimeMillis() + 5000L);
                int hashCode = D.i((Object)row.get((Object)"fhash_code"));
                JobEngine.submit(new EventWaitingJob(hashCode, "PULL:" + hashCode), scheduledTime);
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private DynamicObject prepareSignalObject(Execution e, String node_id, String signal_identifier, long service_flow, int hashCode) {
        DynamicObject proc = ProcessRuntime.getProcessObj(e.getRuntime());
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"isc_sf_waiting_signal");
        obj.set("id", (Object)IDService.get().genLongId());
        obj.set("service_flow", (Object)service_flow);
        obj.set("sp_number", (Object)proc.getString("number"));
        obj.set("sp", (Object)proc.getLong("id"));
        obj.set("node_title", (Object)e.getDefine().getTitle());
        obj.set("node", (Object)node_id);
        obj.set("activity", (Object)e.getId());
        obj.set("signal_identifier", (Object)signal_identifier);
        obj.set("hash_code", (Object)hashCode);
        obj.set("state", (Object)"W");
        obj.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
        return obj;
    }

    public void compile(VariableScope scope) {
    }
}

