/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime.n;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.sf.runtime.EventWaitingJob;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class EventWaitingUtil
implements Const {
    public static void signal(long regId, Object data) {
        DynamicObject event = BusinessDataServiceHelper.loadSingleFromCache((Object)regId, (String)"isc_sf_waiting_event");
        long service_flow = event.getLong("service_flow_id");
        String node_id = event.getString("node");
        String nodeTitle = event.getString("node_title");
        String[] signal_fields = event.getString("signal_fields").split(",");
        List<Map<String, Object>> list = EventWaitingUtil.toList(data);
        DynamicObject[] objects = new DynamicObject[list.size()];
        EventWaitingUtil.saveSignalData(list, service_flow, node_id, signal_fields, nodeTitle, objects);
        EventWaitingUtil.createSignalJob(objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSignalJob(DynamicObject[] objects) {
        ArrayList<Object> params = new ArrayList<Object>(objects.length);
        ArrayList<Integer> types = new ArrayList<Integer>(objects.length);
        String sql = EventWaitingUtil.prepareSelectSQL(objects, params, types);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, params, types)) {
                int hashCode = D.i((Object)row.get((Object)"fhash_code"));
                JobEngine.submit(new EventWaitingJob(hashCode, "PUSH:" + hashCode));
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private static String prepareSelectSQL(DynamicObject[] objects, List<Object> params, List<Integer> types) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT distinct fhash_code FROM t_isc_sf_waiting_signal");
        sql.append(" WHERE fhash_code IN(");
        for (DynamicObject obj : objects) {
            if (sql.charAt(sql.length() - 1) == '?') {
                sql.append(',');
            }
            sql.append('?');
            params.add(obj.get("hash_code"));
            types.add(4);
        }
        sql.append(')');
        return sql.toString();
    }

    private static void saveSignalData(List<Map<String, Object>> list, long service_flow, String node_id, String[] signal_fields, String nodeTitle, DynamicObject[] objects) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> item = list.get(i);
            List<Object> values = EventWaitingUtil.getSignalFilterValues(signal_fields, item);
            String signal_identifier = EventWaitingUtil.calcSignalIdentifier(values, nodeTitle);
            int hash_code = EventWaitingUtil.calcSignalHash(service_flow, node_id, signal_identifier);
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"isc_sf_waiting_data");
            obj.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
            obj.set("service_flow_id", (Object)service_flow);
            obj.set("node_title", (Object)nodeTitle);
            obj.set("node", (Object)node_id);
            obj.set("signal_identifier", (Object)signal_identifier);
            obj.set("hash_code", (Object)hash_code);
            obj.set("data", (Object)"...");
            obj.set("data_tag", (Object)Json.toString(item));
            obj.set("state", (Object)"W");
            objects[i] = obj;
        }
        SaveServiceHelper.save((DynamicObject[])objects);
    }

    private static List<Object> getSignalFilterValues(String[] signal_fields, Map<String, Object> item) {
        ArrayList<Object> values = new ArrayList<Object>(signal_fields.length);
        for (String key : signal_fields) {
            values.add(item.get(key));
        }
        return values;
    }

    private static List<Map<String, Object>> toList(Object data) {
        List<Map<String, Object>> list = data instanceof List ? (List<Map<String, Object>>)data : Collections.singletonList((Map)data);
        return list;
    }

    static String calcSignalIdentifier(List<?> values, String nodeTitle) {
        for (Object v : values) {
            if (EventWaitingUtil.isValid(v)) continue;
            String message = String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%s\uff09\u7684\u7b49\u5f85\u6761\u4ef6\u201c\u6bd4\u8f83\u503c\u201d\u4e2d\u5305\u542b\u4e0d\u5408\u6cd5\u7684\u6570\u636e\uff0c\u8981\u6c42\u7684\u6bd4\u8f83\u6761\u4ef6\u503c\u5fc5\u987b\u662f\u5b57\u7b26\u4e32\u6216\u6570\u503c\u3002", (String)"EventWaitingUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), nodeTitle);
            throw new IscBizException(message);
        }
        return Json.toString(values, (boolean)true);
    }

    private static boolean isValid(Object v) {
        if (v == null) {
            return false;
        }
        return v instanceof CharSequence || v instanceof Number;
    }

    static int calcSignalHash(long service_flow, String node_id, String signal_identifier) {
        return Math.abs((int)Hash.mur((Object[])new Object[]{service_flow, node_id, signal_identifier}));
    }

    public static void disableEvents(long flowId) {
        DynamicObject[] events;
        QFilter filter = new QFilter("service_flow_id", "=", (Object)flowId);
        for (DynamicObject e : events = BusinessDataServiceHelper.load((String)"isc_sf_waiting_event", (String)"id,enabled", (QFilter[])new QFilter[]{filter})) {
            e.set("enabled", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])events);
    }

    public static void detachEvents(long flowId) {
        DynamicObject[] events;
        QFilter filter = new QFilter("service_flow_id", "=", (Object)flowId).and(new QFilter("enabled", "=", (Object)Boolean.FALSE));
        for (DynamicObject event : events = BusinessDataServiceHelper.load((String)"isc_sf_waiting_event", (String)"id,meta_schema,service_flow", (QFilter[])new QFilter[]{filter})) {
            EventWaitingUtil.detachEvent(event);
        }
    }

    public static void deleteDisabledEvents(long flowId) {
        QFilter filter = new QFilter("service_flow_id", "=", (Object)flowId).and(new QFilter("enabled", "=", (Object)Boolean.FALSE));
        DeleteServiceHelper.delete((String)"isc_sf_waiting_event", (QFilter[])new QFilter[]{filter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attachEvent(DynamicObject event) {
        DynamicObject schema = MetaDataSchema.get(D.l((Object)event.get("meta_schema_id")));
        long dbLink = DataSource.get(schema.getLong("group_id")).getDbLink();
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)event.get("service_flow_id"), (String)"isc_service_flow");
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(flow));
        try (ConnectionWrapper cn = ConnectionManager.getConnection(dbLink);){
            String iscHub = ConnectorUtil.getIscHub(cn.getConfig());
            long id = event.getLong("id");
            String bill_events = event.getString("events");
            Map requires = (Map)Json.toObject((String)event.getString("requires_tag"));
            cn.getFactory().attachEvents(cn, iscHub, EventBindingUtil.TriggerType.ServiceFlowEventWaiting, id, schema.getString("full_name"), bill_events.split(","), requires);
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detachEvent(DynamicObject event) {
        long schemaId = D.l((Object)event.get("meta_schema_id"));
        DynamicObject schema = MetaDataSchema.get(schemaId);
        long dbLink = DataSource.get(schema.getLong("group_id")).getDbLink();
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)event.get("service_flow_id"), (String)"isc_service_flow");
        ConnectionManager.pushResLicense(IscLicenseUtil.resHasLicense(flow));
        try (ConnectionWrapper cn = ConnectionManager.getConnection(dbLink);){
            String iscHub = ConnectorUtil.getIscHub(cn.getConfig());
            long id = event.getLong("id");
            cn.getFactory().detachEvents(cn, iscHub, EventBindingUtil.TriggerType.ServiceFlowEventWaiting, id, schema.getString("full_name"));
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    public static Map<String, Object> initRequiresMap(Map<String, Object> item) {
        List selectorEntry = (List)item.get("selector_entry");
        LinkedHashMap<String, Object> requires = new LinkedHashMap<String, Object>(selectorEntry.size());
        for (Map selector : selectorEntry) {
            String field = D.s(selector.get("field"));
            if (field == null) continue;
            if (field.indexOf(46) < 0) {
                requires.put(field, 1);
                continue;
            }
            String[] path = field.split("\\.");
            SQLUtil.addEntryProperty(requires, path);
        }
        return requires;
    }
}

