/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime.n;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.runtime.ProcessRuntime;
import kd.isc.iscb.platform.core.sf.runtime.n.TimerWaitingJob;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.feature.tool.date.DateAdd;
import kd.isc.iscb.util.script.feature.tool.date.TimeSpan;

public class TimerWaitingApplication
implements Application {
    private Script schedule;

    public TimerWaitingApplication(Script schedule) {
        this.schedule = schedule;
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        long time = this.calcScheduleTime(e, 0);
        String number = ProcessRuntime.getNumber(e.getRuntime());
        String title = "[W] " + number + "\uff08" + e.getDefine().getTitle() + "\uff09";
        long procInstId = D.l((Object)e.getRuntime().getId());
        boolean isLight = ServiceFlowEngine.isLight(e);
        TimerWaitingJob job = new TimerWaitingJob(title, 0, procInstId, e.getId(), isLight, ServiceFlowParser.getMutex(e.getRuntime().getFlow()));
        JobEngine.submit(job, new Timestamp(Math.max(System.currentTimeMillis() + 1000L, time)));
    }

    long calcScheduleTime(Execution e, int index) {
        return TimerWaitingApplication.calcScheduleTime(this.schedule, e, index, false);
    }

    public static long calcScheduleTime(Script schedule, Execution e, int index, boolean limited) {
        Object time = schedule.eval((Context)e);
        long scheduleTime = limited ? TimerWaitingApplication.calcLimitedScheduleTime(e, index, time) : TimerWaitingApplication.calcUnlimitedScheduleTime(e, index, time);
        return scheduleTime;
    }

    private static long calcLimitedScheduleTime(Execution e, int index, Object time) {
        if (time instanceof List) {
            List list = (List)time;
            if (index < list.size()) {
                return TimerWaitingApplication.calcTime(e, list.get(index));
            }
        } else if (index == 0) {
            return TimerWaitingApplication.calcTime(e, time);
        }
        return 0L;
    }

    private static long calcUnlimitedScheduleTime(Execution e, int index, Object time) {
        if (time instanceof List) {
            List list = (List)time;
            int last = list.size() - 1;
            time = list.get(Math.min(index, last));
        }
        return TimerWaitingApplication.calcTime(e, time);
    }

    private static long calcTime(Execution e, Object time) {
        if (time instanceof TimeSpan) {
            return DateAdd.calc((Date)new Date(), (TimeSpan)((TimeSpan)time)).getTime();
        }
        String text = String.format(ResManager.loadKDString((String)"\u8282\u70b9\uff08%1$s\uff09\u7684\u7b49\u5f85\u8ba1\u5212\u65f6\u95f4\u503c\uff08%2$s\uff09\u4e0d\u5408\u6cd5\uff01", (String)"TimerWaitingApplication_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), e.getDefine().getTitle(), time);
        throw new IllegalArgumentException(text);
    }
}

