/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime.n;

import java.sql.Timestamp;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.sf.runtime.AbstractProcessJob;
import kd.isc.iscb.platform.core.sf.runtime.ProcessState;
import kd.isc.iscb.platform.core.sf.runtime.n.TimerWaitingApplication;
import kd.isc.iscb.platform.core.sf.runtime.n.TimerWaitingJobFactory;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Node;

public class TimerWaitingJob
extends AbstractProcessJob {
    private int index;
    private String executionId;

    public TimerWaitingJob(String title, int index, long procInstId, String executionId, boolean isLight, long jobMutex) {
        super(procInstId, title, ProcessState.Waiting, isLight, jobMutex);
        this.index = index;
        this.executionId = executionId;
    }

    @Override
    public String getParam() {
        return TimerWaitingJobFactory.toString(this.index, this.getProcInstId(), this.executionId, this.isLightTask(), this.getMutex());
    }

    @Override
    public JobFactory getFactory() {
        return TimerWaitingJobFactory.INSTANCE;
    }

    @Override
    protected TraceType getTraceType() {
        return TraceType.SFP_TW;
    }

    @Override
    protected void doJob(FlowRuntime runtime) {
        Execution e = runtime.getExecution(this.executionId);
        if (e != null) {
            if (runtime.prepare(this.executionId, null)) {
                runtime.signal(this.executionId);
            } else {
                TimerWaitingApplication app = (TimerWaitingApplication)((Node)e.getDefine()).getApplication();
                long time = app.calcScheduleTime(e, ++this.index);
                JobEngine.submit(this, new Timestamp(Math.max(System.currentTimeMillis() + 1000L, time)));
            }
        } else if (!runtime.isClosed()) {
            runtime.resume();
        }
    }
}

