/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.runtime.n;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.api.webapi.WebApi;
import kd.isc.iscb.platform.core.api.webapi.WebApiDispatcher;
import kd.isc.iscb.platform.core.sf.ExprGetter;
import kd.isc.iscb.platform.core.sf.ExprSetter;
import kd.isc.iscb.platform.core.sf.util.ExprUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.plugin.Application;

public class WebApiApplication
implements Application {
    private static final Log logger = LogFactory.getLog(WebApiApplication.class);
    private final long id;
    private final Map<String, ExprGetter> urlParams;
    private final Map<String, ExprGetter> reqHeader;
    private final Map<String, ExprGetter> reqBody;
    private final Map<String, ExprSetter> respBody;
    private final WebApi webApi;

    public WebApiApplication(long id, Map<String, ExprGetter> urlParams, Map<String, ExprGetter> reqHeader, Map<String, ExprGetter> reqBody, Map<String, ExprSetter> respBody) {
        this.id = id;
        this.webApi = WebApi.get(id);
        this.urlParams = urlParams;
        this.reqHeader = reqHeader;
        this.reqBody = reqBody;
        this.respBody = respBody;
    }

    public void compile(VariableScope scope) {
    }

    public void invoke(Execution e) {
        Object result;
        DynamicObject obj = this.webApi.getCfg();
        this.checkUrlParams(obj);
        this.checkReqHeader(obj);
        this.checkReqBody(obj);
        this.checkRespBody(obj);
        Map<String, Object> body = this.getInputMap(e, this.reqBody);
        Map<String, Object> head = this.getInputMap(e, this.reqHeader);
        Map<String, Object> queryParam = this.getInputMap(e, this.urlParams);
        try {
            result = WebApiDispatcher.execute(this.webApi, body, head, queryParam);
        }
        catch (Throwable t) {
            String err = String.format(ResManager.loadKDString((String)"\u8c03\u7528WebAPI\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u4e3a\uff1a[%s]\u7684WebAPI\u6570\u636e", (String)"WebApiApplication_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), obj.getString("number"));
            throw new IscBizException(err, t);
        }
        try {
            this.setRuntimeVar(e, result, D.x((Object)obj.get("need_format_result")));
        }
        catch (Throwable t) {
            String err = String.format(ResManager.loadKDString((String)"WebAPI\u8282\u70b9 \u7ed9\u54cd\u5e94\u7ed3\u679c\u8d4b\u503c\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u539f\u59cb\u7ed3\u679c\u662f\uff1a%s", (String)"WebApiApplication_17", (String)"isc-iscb-platform-core", (Object[])new Object[0]), result);
            throw new IscBizException(err, t);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setRuntimeVar(Execution e, Object result, boolean formatResult) {
        if (formatResult) {
            if (!(result instanceof Map)) throw new IscBizException(String.format(ResManager.loadKDString((String)"WebAPI\u8bbe\u7f6e\u4e86\u683c\u5f0f\u5316\u54cd\u5e94\u7ed3\u679c\uff0c\u4f46\u662f\u8fd4\u56de\u7684\u503c\u4e0d\u662fMap\u7ed3\u6784\uff0c\u6682\u4e0d\u652f\u6301\u8d4b\u503c\u3002\u8fd4\u56de\u503c\u662f\uff1a%s", (String)"WebApiApplication_18", (String)"isc-iscb-platform-core", (Object[])new Object[0]), result));
            this.varValueSetter(e, (Map)result);
            return;
        } else {
            ExprSetter s = this.respBody.get("$result");
            if (s == null) return;
            s.set(e, result);
        }
    }

    private void varValueSetter(Execution e, Map<String, Object> result) {
        for (Map.Entry<String, ExprSetter> entry : this.respBody.entrySet()) {
            ExprSetter s = entry.getValue();
            if (s == null) continue;
            s.set(e, result.get(entry.getKey()));
        }
    }

    private Map<String, Object> getInputMap(Execution e, Map<String, ExprGetter> params) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(params.size());
        for (Map.Entry<String, ExprGetter> entry : params.entrySet()) {
            map.put(entry.getKey(), ExprUtil.evalAssignValue(e, entry.getValue()));
        }
        return map;
    }

    private void checkUrlParams(DynamicObject webapi) {
        DynamicObjectCollection params = webapi.getDynamicObjectCollection("web_url_params");
        HashMap<String, Object> names = new HashMap<String, Object>(params.size());
        for (DynamicObject param : params) {
            if (D.s((Object)param.get("url_param_value")) != null) continue;
            names.put(param.getString("url_param_name"), 1);
        }
        if (names.size() != this.urlParams.size()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u7684URL\u53c2\u6570\u4e0e\u5b9e\u9645WebAPI\u7684URL\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u5f15\u7528\u7684WebAPI\u505a\u51fa\u4e86\u4fee\u6539\u800c\u6ca1\u6709\u91cd\u65b0\u914d\u7f6e\u6d41\u7a0b\u5bfc\u81f4\u3002WebAPI\u7684URL\u53c2\u6570\u4e2a\u6570\uff1a%1$s\uff0c\u6d41\u7a0b\u4e2d\u914d\u7f6e\u7684URL\u53c2\u6570\u4e2a\u6570\u662f\uff1a%2$s", (String)"WebApiApplication_19", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.urlParams.size(), names.size()));
        }
        if (!this.isAllContains(names, this.urlParams)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u7684URL\u53c2\u6570\u4e0e\u5b9e\u9645WebAPI\u7684URL\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u5f15\u7528\u7684API\u505a\u51fa\u4e86\u4fee\u6539\u800c\u6ca1\u6709\u91cd\u65b0\u914d\u7f6e\u6d41\u7a0b\u5bfc\u81f4\u3002", (String)"WebApiApplication_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private void checkReqHeader(DynamicObject webapi) {
        DynamicObjectCollection params = webapi.getDynamicObjectCollection("web_req_header");
        HashMap<String, Object> names = new HashMap<String, Object>(params.size());
        for (DynamicObject param : params) {
            if (D.s((Object)param.get("req_h_param_value")) != null) continue;
            names.put(param.getString("req_h_param_name"), 1);
        }
        if (names.size() != this.reqHeader.size()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u8bf7\u6c42\u5934\u53c2\u6570\u4e0e\u5b9e\u9645WebAPI\u7684\u8bf7\u6c42\u5934\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u5f15\u7528\u7684WebAPI\u505a\u51fa\u4e86\u4fee\u6539\u800c\u6ca1\u6709\u91cd\u65b0\u914d\u7f6e\u6d41\u7a0b\u5bfc\u81f4\u3002WebAPI\u7684\u8bf7\u6c42\u5934\u53c2\u6570\u4e2a\u6570\uff1a%1$s\uff0c\u6d41\u7a0b\u4e2d\u914d\u7f6e\u7684\u8bf7\u6c42\u5934\u53c2\u6570\u4e2a\u6570\u662f\uff1a%2$s", (String)"WebApiApplication_20", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.reqHeader.size(), names.size()));
        }
        if (!this.isAllContains(names, this.reqHeader)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u8bf7\u6c42\u5934\u53c2\u6570\u4e0e\u5b9e\u9645WebAPI\u7684\u8bf7\u6c42\u5934\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u5f15\u7528\u7684WebAPI\u505a\u51fa\u4e86\u4fee\u6539\u800c\u6ca1\u6709\u91cd\u65b0\u914d\u7f6e\u6d41\u7a0b\u5bfc\u81f4\u3002", (String)"WebApiApplication_9", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private void checkReqBody(DynamicObject webapi) {
        DynamicObjectCollection params = webapi.getDynamicObjectCollection("web_req_body");
        HashMap<String, Object> names = new HashMap<String, Object>(params.size());
        for (DynamicObject param : params) {
            String name = D.s((Object)param.get("req_b_param_name"));
            String value = D.s((Object)param.get("req_b_param_value"));
            if (value != null || D.l((Object)param.get("pid")) != 0L) continue;
            names.put(name, 1);
        }
        if (names.size() != this.reqBody.size()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u8bf7\u6c42\u4f53\u53c2\u6570\u4e0e\u5b9e\u9645WebAPI\u7684\u8bf7\u6c42\u4f53\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u5f15\u7528\u7684WebAPI\u505a\u51fa\u4e86\u4fee\u6539\u800c\u6ca1\u6709\u91cd\u65b0\u914d\u7f6e\u6d41\u7a0b\u5bfc\u81f4\u3002WebAPI\u7684\u8bf7\u6c42\u4f53\u53c2\u6570\u4e2a\u6570\uff1a%1$s\uff0c\u6d41\u7a0b\u4e2d\u914d\u7f6e\u7684\u8bf7\u6c42\u4f53\u53c2\u6570\u4e2a\u6570\u662f\uff1a%2$s", (String)"WebApiApplication_21", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.reqBody.size(), names.size()));
        }
        if (!this.isAllContains(names, this.reqBody)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u8bf7\u6c42\u4f53\u53c2\u6570\u4e0e\u5b9e\u9645WebAPI\u7684\u8bf7\u6c42\u4f53\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u5f15\u7528\u7684WebAPI\u505a\u51fa\u4e86\u4fee\u6539\u800c\u6ca1\u6709\u91cd\u65b0\u914d\u7f6e\u6d41\u7a0b\u5bfc\u81f4\u3002", (String)"WebApiApplication_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private void checkRespBody(DynamicObject webapi) {
        if (!D.x((Object)webapi.get("need_format_result"))) {
            return;
        }
        DynamicObjectCollection params = webapi.getDynamicObjectCollection("web_resp_body");
        HashMap<String, Object> names = new HashMap<String, Object>(params.size());
        for (DynamicObject param : params) {
            String name = D.s((Object)param.get("resp_b_param_name"));
            if (D.l((Object)param.get("pid")) != 0L) continue;
            names.put(name, 1);
        }
        if (names.size() != this.respBody.size()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u54cd\u5e94\u7ed3\u679c\u53c2\u6570\u4e0e\u5b9e\u9645WebAPI\u7684\u54cd\u5e94\u7ed3\u679c\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u5f15\u7528\u7684WebAPI\u505a\u51fa\u4e86\u4fee\u6539\u800c\u6ca1\u6709\u91cd\u65b0\u914d\u7f6e\u6d41\u7a0b\u5bfc\u81f4\u3002WebAPI\u7684\u54cd\u5e94\u7ed3\u679c\u53c2\u6570\u4e2a\u6570\uff1a%1$s\uff0c\u6d41\u7a0b\u4e2d\u914d\u7f6e\u7684\u54cd\u5e94\u7ed3\u679c\u53c2\u6570\u4e2a\u6570\u662f\uff1a%2$s", (String)"WebApiApplication_22", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.respBody.size(), names.size()));
        }
        if (!this.isAllContainsOut(names, this.respBody)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u54cd\u5e94\u7ed3\u679c\u53c2\u6570\u4e0e\u5b9e\u9645WebAPI\u7684\u54cd\u5e94\u7ed3\u679c\u53c2\u6570\u4e0d\u5339\u914d\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u5f15\u7528\u7684WebAPI\u505a\u51fa\u4e86\u4fee\u6539\u800c\u6ca1\u6709\u91cd\u65b0\u914d\u7f6e\u6d41\u7a0b\u5bfc\u81f4\u3002", (String)"WebApiApplication_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
    }

    private boolean isAllContains(Map<String, Object> map, Map<String, ExprGetter> maps) {
        int count = 0;
        for (Map.Entry<String, ExprGetter> entry : maps.entrySet()) {
            if (!map.containsKey(entry.getKey())) continue;
            ++count;
        }
        return count == map.size();
    }

    private boolean isAllContainsOut(Map<String, Object> map, Map<String, ExprSetter> maps) {
        int count = 0;
        for (Map.Entry<String, ExprSetter> entry : maps.entrySet()) {
            if (!map.containsKey(entry.getKey())) continue;
            ++count;
        }
        return count == map.size();
    }
}

