/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.sf.trigger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.sf.ServiceFlowEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.parser.n.EventStarterParser;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Flow;

public class ServiceFlowGenerator {
    public static Object generate(long flowDefId, Object data) {
        return ServiceFlowGenerator.generate(flowDefId, data, Collections.emptyMap());
    }

    public static Object generate(long flowDefId, Object data, Map<String, Object> extendInfos) {
        long releasedFlowId = ServiceFlowParser.findReleasedFlowId(flowDefId);
        if (releasedFlowId == 0L) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id%s\u627e\u4e0d\u5230\u5df2\u53d1\u5e03\u7684\u6d41\u7a0b\u5b9a\u4e49", (String)"ServiceFlowGenerator_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), flowDefId));
        }
        Flow flow = ServiceFlowParser.getFlow(releasedFlowId);
        EventStarterParser.EventStarter eventStarter = (EventStarterParser.EventStarter)ServiceFlowParser.getStarter(flow);
        String varName = eventStarter.getVarName();
        if (data instanceof Map) {
            return ServiceFlowGenerator.startServiceFlow(releasedFlowId, varName, data, extendInfos);
        }
        if (data instanceof List) {
            return ServiceFlowGenerator.handleDataList(releasedFlowId, eventStarter, varName, data, extendInfos);
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\u3002data = %s", (String)"ServiceFlowGenerator_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), data));
    }

    private static Object handleDataList(long releasedFlowId, EventStarterParser.EventStarter eventStarter, String varName, Object data, Map<String, Object> extendInfos) {
        if (eventStarter.isVarArray()) {
            return ServiceFlowGenerator.startServiceFlow(releasedFlowId, varName, data, extendInfos);
        }
        List list = (List)data;
        ArrayList<Object> flows = new ArrayList<Object>(list.size());
        for (Object o : list) {
            flows.add(ServiceFlowGenerator.startServiceFlow(releasedFlowId, varName, o, extendInfos));
        }
        return flows;
    }

    private static Object startServiceFlow(long releasedFlowId, String varName, Object data, Map<String, Object> extendInfos) {
        HashMap<String, Object> flowParam = new HashMap<String, Object>();
        flowParam.put(varName, data);
        return ServiceFlowEngine.createAndStart(releasedFlowId, new Object[0], flowParam, extendInfos);
    }
}

