/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.login.utils.ShaSignUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.HttpConnectionDecorator;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.misc.HttpUtil;

public class PublicResourceUtil {
    public static final Integer DEFAULT_PAGE_SIZE = 200;
    private static final Map<String, String> KEY_METHOD_MAP = new HashMap<String, String>();

    public static Map<String, Object> getAppInfo() {
        Map appInfo = PublicResourceUtil.checkNewAppInfoExist() ? PublicResourceUtil.getAppinfoBySdk() : PublicResourceUtil.getAppinfoByIscr();
        return appInfo;
    }

    public static Map getAppinfoByIscr() {
        String properties = "number,name,publickey,status,fileserver,server_accountid,phone,server_url,tenantid,accountid";
        DynamicObject apply = BusinessDataServiceHelper.loadSingle((String)"iscr_app_apply", (String)properties, (QFilter[])new QFilter[0]);
        if (apply == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"PublicResourceUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (!"B".equals(apply.get("status"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"PublicResourceUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (!PublicResourceUtil.isMatchEnvironment(apply)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u7684\u79df\u6237ID\u6216\u8d26\u5957ID\u4e0e\u7533\u8bf7\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"PublicResourceUtil_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return DynamicObjectUtil.object2Map(apply);
    }

    public static Map getAppinfoBySdk() {
        try {
            Class<?> clz = Class.forName("kd.bos.open.res.util.ResourceClientUtil");
            Method method = clz.getDeclaredMethod("findResourceClientInfo", new Class[0]);
            Object data = method.invoke(null, new Object[0]);
            return PublicResourceUtil.beanToMap(data);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    public static boolean checkNewAppInfoExist() {
        return MetadataDao.getIdByNumber((String)"res_pub_thirdapp_apply", (MetaCategory)MetaCategory.Form) != null;
    }

    private static Map<String, Object> beanToMap(Object data) {
        HashMap<String, Object> appInfo = new HashMap<String, Object>();
        if (data == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"PublicResourceUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        try {
            for (Map.Entry<String, String> entry : KEY_METHOD_MAP.entrySet()) {
                Method method = data.getClass().getDeclaredMethod(entry.getValue(), new Class[0]);
                appInfo.put(entry.getKey(), method.invoke(data, new Object[0]));
            }
            if (appInfo.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u5e94\u7528\u672a\u5f00\u901a\uff0c\u8bf7\u524d\u5f80\u3010\u8d44\u6e90\u4e2d\u5fc3\u3011-\u3010\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u754c\u9762\u63d0\u4ea4\u4e91\u8d44\u6e90\u5bc6\u94a5\u5f00\u901a\u7533\u8bf7\u3002", (String)"PublicResourceUtil_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
        return appInfo;
    }

    public static boolean isMatchEnvironment(DynamicObject apply) {
        String curTenantId = RequestContext.get().getTenantId();
        String curAccountId = RequestContext.get().getAccountId();
        return curTenantId.equals(apply.getString("tenantid")) && curAccountId.equals(apply.getString("accountid"));
    }

    public static Map<String, Object> queryDataByGet(String api, Map<String, Object> param) {
        return PublicResourceUtil.queryDataByGet(api, param, NetUtil.TIMEOUT);
    }

    public static Map<String, Object> queryDataByGet(String api, Map<String, Object> param, int TIMEOUT) {
        Reader reader = PublicResourceUtil.innerQueryByGet(api, param, TIMEOUT);
        return PublicResourceUtil.getResultData(reader);
    }

    public static List<Map<String, Object>> queryListByGet(String api, Map<String, Object> param) {
        Reader reader = PublicResourceUtil.innerQueryByGet(api, param, NetUtil.TIMEOUT);
        return PublicResourceUtil.getResultRows(reader);
    }

    private static Reader innerQueryByGet(String api, Map<String, Object> param, int TIMEOUT) {
        Map<String, Object> appInfo = PublicResourceUtil.getAppInfo();
        String serverUrl = D.s((Object)appInfo.get("server_url"));
        serverUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
        String url = serverUrl + api;
        LinkedHashMap<String, Object> queryParam = new LinkedHashMap<String, Object>(PublicResourceUtil.getDefaultParams());
        if (param != null && !param.isEmpty()) {
            queryParam.putAll(param);
        }
        Map<String, Object> params = PublicResourceUtil.getParams(appInfo, PublicResourceUtil.getQueryString(queryParam));
        params.putAll(queryParam);
        params.put("parameters", StringUtil.join(queryParam.keySet(), (String)","));
        url = HttpUtil.mergeToURL((String)url, (String)HttpUtil.xFormEncode(params));
        String charset = "utf-8";
        Reader reader = NetUtil.httpAccess((String)url, null, (String)charset, null, (String)"GET", (int)TIMEOUT);
        return reader;
    }

    public static InputStream downloadImage(String api, Map<String, Object> param) {
        Map<String, Object> appInfo = PublicResourceUtil.getAppInfo();
        String serverUrl = D.s((Object)appInfo.get("server_url"));
        serverUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
        String url = serverUrl + api;
        Map<String, Object> headers = PublicResourceUtil.getHeaders(appInfo, param);
        headers.put("Accept", "application/octet-stream");
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(new HashMap(), headers);
        byte[] bs = JSON.toJSONString(param).getBytes(StandardCharsets.UTF_8);
        return NetUtil.httpAccess((String)url, (String)"POST", (byte[])bs, (String)"application/json", (NetUtil.ConnectionDecorator)decorator, (int)NetUtil.TIMEOUT);
    }

    private static Map<String, Object> getDefaultParams() {
        LinkedHashMap<String, Object> queryParam = new LinkedHashMap<String, Object>(2);
        queryParam.put("pageSize", DEFAULT_PAGE_SIZE);
        queryParam.put("pageNo", 1);
        return queryParam;
    }

    public static Map<String, Object> getParams(Map<String, Object> appInfo, String queryString) {
        String signature;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = sdf.format(new Date());
        String signatureNonce = UUID.randomUUID().toString();
        String value = queryString + timestamp + signatureNonce;
        try {
            signature = ShaSignUtils.HMACSHA256StrByKey((String)value, (String)D.s((Object)appInfo.get("publickey")));
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
        LinkedHashMap<String, Object> header = new LinkedHashMap<String, Object>(16);
        String appNumber = D.s((Object)appInfo.get("number"));
        header.put("appId", appNumber);
        header.put("timestamp", timestamp);
        header.put("signature", signature);
        header.put("signatureNonce", signatureNonce);
        header.put("user", appNumber);
        header.put("usertype", "UserName");
        header.put("Content-Type", "application/json");
        header.put("accountId", D.s((Object)appInfo.get("server_accountid")));
        return header;
    }

    private static String getQueryString(LinkedHashMap<String, Object> queryParam) {
        if (queryParam == null || queryParam.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : queryParam.entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return sb.toString();
    }

    private static List<Map<String, Object>> getResultRows(Reader reader) {
        try {
            String result = NetUtil.readText((Reader)reader);
            Map res = (Map)Script.parseJson((String)result);
            if (D.x(res.get("status"))) {
                List list = (List)((Map)res.get("data")).get("rows");
                return list;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u83b7\u53d6\u7684\u4e91\u7aef\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\u662f:%s", (String)"PublicResourceUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), res));
        }
        finally {
            DbUtil.close((Reader)reader);
        }
    }

    private static Map<String, Object> getResultData(Reader reader) {
        try {
            String result = NetUtil.readText((Reader)reader);
            Map res = (Map)Script.parseJson((String)result);
            if (D.x(res.get("status"))) {
                Map map = (Map)res.get("data");
                return map;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u83b7\u53d6\u7684\u4e91\u7aef\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\u662f:%s", (String)"PublicResourceUtil_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), res));
        }
        finally {
            DbUtil.close((Reader)reader);
        }
    }

    public static Map<String, Object> getHeaders(Map<String, Object> appInfo, Map<String, Object> body) {
        String s = JSON.toJSONString(body);
        return PublicResourceUtil.getParams(appInfo, s);
    }

    public static boolean checkAppInfo() {
        Map<String, Object> appInfo = PublicResourceUtil.getAppInfo();
        return appInfo != null;
    }

    static {
        KEY_METHOD_MAP.put("number", "getThirdcode");
        KEY_METHOD_MAP.put("name", "getName");
        KEY_METHOD_MAP.put("publickey", "getPublickey");
        KEY_METHOD_MAP.put("status", "getBillstatus");
        KEY_METHOD_MAP.put("fileserver", "getFileserver");
        KEY_METHOD_MAP.put("server_accountid", "getTargetaccountid");
        KEY_METHOD_MAP.put("phone", "getPhone");
        KEY_METHOD_MAP.put("server_url", "getTargeturl");
        KEY_METHOD_MAP.put("tenantid", "getTenantid");
        KEY_METHOD_MAP.put("accountid", "getAccountid");
    }
}

