/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution;

import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.license.IscWhiteListUtil;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.platform.core.solution.ResourceToObjectConversion;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;

public class SolutionResourceUtil {
    private static final Log LOGGER = LogFactory.getLog(SolutionResourceUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadLogoToFileServer(String logoPath) {
        int i = logoPath.lastIndexOf(47);
        String simpleName = logoPath.substring(i + 1);
        int v = simpleName.indexOf(38);
        simpleName = v == -1 ? simpleName : simpleName.substring(0, v);
        long randId = IDService.get().genLongId();
        String path = FileNameUtils.getImageFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)"iscb", (String)"isc_solution_center_m", (Object)randId, (String)simpleName);
        InputStream in = null;
        try {
            in = SolutionResourceUtil.getInputStream(logoPath);
            FileItem fileItem = new FileItem(simpleName, path, in);
            fileItem.setCreateNewFileWhenExists(true);
            String urlLogo = FileServiceFactory.getImageFileService().upload(fileItem);
            LOGGER.info("upload image " + simpleName + " success. path: " + path + "; urlLogo: " + urlLogo);
            String string = urlLogo;
            return string;
        }
        finally {
            DbUtil.close((InputStream)in);
        }
    }

    private static InputStream getInputStream(String logoPath) {
        if ("fileserver".equals(SystemPropertyUtils.getProptyByTenant((String)"isc.retrieve.image.type", (String)RequestContext.get().getTenantId()))) {
            String fileServer = SolutionResourceUtil.getFileServer();
            String urlCloud = String.format("%s%s", fileServer, logoPath);
            return NetUtil.httpAccess((String)urlCloud, (String)"GET", (byte[])new byte[0], (String)"image/jpg", null, (int)NetUtil.TIMEOUT);
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(2);
        params.put("path", logoPath);
        return PublicResourceUtil.downloadImage("kapi/v2/kdec/iscb/download/image", params);
    }

    public static String getFileServer() {
        Map<String, Object> appInfo = PublicResourceUtil.getAppInfo();
        String fileserver = D.s((Object)appInfo.get("fileserver"));
        if (StringUtils.isNotEmpty((String)fileserver)) {
            return fileserver;
        }
        return System.getProperty("solution.resource.fileserver");
    }

    public static void removeUnnecessaryFields(Map<String, Object> data) {
        data.remove("creator");
        data.remove("modifier");
        data.remove("is_deployed");
    }

    public static List<Map<String, String>> buildWhitelist(List<Map<String, Object>> resources) {
        ArrayList<Map<String, String>> whitelist = new ArrayList<Map<String, String>>(resources.size());
        for (Map<String, Object> res : resources) {
            String solutionNumber = D.s((Object)res.get("solutionNumber"));
            String resourceId = D.s((Object)res.get("resourceId"));
            Map<String, Object> resRow = SolutionResourceUtil.querySolutionResource(solutionNumber, resourceId, true);
            Map data = (Map)Json.toObject((String)D.s((Object)resRow.get("fcontent_tag")));
            ResourceToObjectConversion type = ResourceToObjectConversion.valueOf(D.s((Object)resRow.get("ftype")));
            DynamicObject obj = type.map2Object(data, solutionNumber);
            Map<String, String> whitelistInfo = IscWhiteListUtil.getWhiteListInfo(obj);
            whitelist.add(whitelistInfo);
        }
        return whitelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> querySolutionResource(String solutionNumber, String resPk, boolean withJsonContent) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        String selectField = "r.fname, r.ftype";
        if (withJsonContent) {
            selectField = selectField + ", r.fcontent_tag";
        }
        try {
            String sql = " select " + selectField + " from t_isc_solution_mr r where       r.fid=( select fid from t_isc_solution_center where fnumber = ?)   and r.fres_pk = ? union  select " + selectField + " from t_isc_solution_rr r where       r.fid=( select fid from t_isc_solution_center where fnumber = ?)   and r.fres_pk = ?";
            DataRow row = DbUtil.executeRow((Connection)cn, (String)sql, Arrays.asList(solutionNumber, resPk, solutionNumber, resPk), Arrays.asList(12, 12, 12, 12));
            Map map = row.toMap();
            return map;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }
}

