/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution;

import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.platform.core.solution.UpdateCloudCnTypeJobFactory;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class UpdateCloudCnTypeJob
implements Job {
    private static final Log LOGGER = LogFactory.getLog(UpdateCloudCnTypeJob.class);
    public static final UpdateCloudCnTypeJobFactory FACTORY = new UpdateCloudCnTypeJobFactory();
    private final String param;
    private final String title;
    private volatile int total = 1;
    private final AtomicInteger success = new AtomicInteger(0);
    private final AtomicInteger failed = new AtomicInteger(0);
    private String current;

    public UpdateCloudCnTypeJob(String title, String param) {
        this.title = title;
        this.param = param;
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String getJobSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"\u603b\u6570\uff1a%1$s\uff1b\u6210\u529f\uff1a%2$s", (String)"UpdateCloudCnTypeJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.total, this.success));
        if (this.failed.get() > 0) {
            sb.append('\uff1b').append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff1a%s", (String)"UpdateCloudCnTypeJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.failed));
        }
        return sb.toString();
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        int completed = this.success.get() + this.failed.get();
        return new Job.Progress(this.total, completed, this.current);
    }

    @Override
    public void run() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("kdec_is_shared", "1");
        List<Map<String, Object>> typeList = PublicResourceUtil.queryListByGet("kapi/v2/kdec/iscb/isc_connection_type/query_connection_type_list", params);
        this.total = typeList.size();
        for (Map<String, Object> data : typeList) {
            this.current = String.format(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u66f4\u65b0\uff1a\u8fde\u63a5\u7c7b\u578b\uff08%s\uff09", (String)"UpdateCloudCnTypeJob_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), data.get("number"));
            try {
                data.put("$id", data.get("id"));
                data.put("$entityname", "isc_connection_type");
                data.put("$isref", Boolean.FALSE);
                String s = Json.toString(data);
                ImportDynamicObject.innerImport(s);
                this.success.incrementAndGet();
            }
            catch (Exception e) {
                this.failed.incrementAndGet();
                LOGGER.error("UpdateCloudCnTypeJob,\u66f4\u65b0\u4e91\u7aef\u8fde\u63a5\u7c7b\u578b[" + data.get("name") + "]\u5931\u8d25\u3002" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
            }
        }
    }

    @Override
    public long getOwnerId() {
        return Math.abs(Hash.mur64((byte[])"UpdateCloudCnTypeJob".getBytes(StandardCharsets.UTF_8)));
    }
}

