/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.imp.SolutionSyncCloudUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.license.IscWhiteListUtil;
import kd.isc.iscb.platform.core.license.UpdateCloudWhiteListJob;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.solution.UpdateCloudSolutionJobFactory;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class UpdateCloudSolutionJob
implements Job {
    private static final Log LOGGER = LogFactory.getLog(UpdateCloudSolutionJob.class);
    public static final UpdateCloudSolutionJobFactory FACTORY = new UpdateCloudSolutionJobFactory();
    private final String param;
    private final String title;
    private volatile int total = 10000;
    private final AtomicInteger success = new AtomicInteger(0);
    private final AtomicInteger failed = new AtomicInteger(0);
    private final AtomicInteger omitted = new AtomicInteger(0);
    private String current;

    public UpdateCloudSolutionJob(String title, String param) {
        this.title = title;
        this.param = param;
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String refreshProgress() {
        return this.current;
    }

    @Override
    public long getOwnerId() {
        return Math.abs(Hash.mur64((byte[])"UpdateCloudSolutionJob".getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        int completed = this.success.get() + this.failed.get() + this.omitted.get();
        return new Job.Progress(this.total, completed, this.current);
    }

    @Override
    public String getJobSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u8ba2\u9605\u6210\u529f\uff1a", (String)"UpdateCloudSolutionJob_0", (String)"isc-iscb-platform-core", (Object[])new Object[0])).append(this.success);
        if (this.failed.get() > 0) {
            sb.append(ResManager.loadKDString((String)"\uff1b\u8ba2\u9605\u5931\u8d25\uff1a", (String)"UpdateCloudSolutionJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0])).append(this.failed);
        }
        if (this.omitted.get() > 0) {
            sb.append(String.format(ResManager.loadKDString((String)"\uff1b\u5ffd\u7565\uff1a%1$s\uff0c\u672c\u5730\u65b9\u6848\u548c\u4e91\u7aef\u4e00\u81f4\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\u3002", (String)"UpdateCloudSolutionJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.omitted));
        }
        return sb.toString();
    }

    @Override
    public void run() {
        try {
            this.innerRun();
        }
        catch (Exception e) {
            this.failed.incrementAndGet();
            LOGGER.error("UpdateCloudSolutionJob,\u66f4\u65b0\u4e91\u7aef\u89e3\u51b3\u65b9\u6848\u5931\u8d25\u3002" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
            throw e;
        }
    }

    private void innerRun() {
        if (this.param.equals("update_solution_list")) {
            SolutionUtil.updateSolutionCategory();
            this.updateSolution();
        } else {
            SolutionUtil.updateSolutionCategory();
            SolutionUtil.updateSolutionDomain();
            List<Map<String, Object>> solutionList = PublicResourceUtil.queryListByGet(this.param, null);
            this.newSaveSolution(solutionList);
        }
    }

    private void updateSolution() {
        String api = "kapi/v2/kdec/iscb/isc_solution_center/query_solution_list";
        int pageNo = 0;
        List<Map<String, Object>> list = UpdateCloudSolutionJob.querySolutionByPage(api, ++pageNo);
        while (list.size() != 0) {
            this.saveSolution(list);
            list = UpdateCloudSolutionJob.querySolutionByPage(api, ++pageNo);
        }
    }

    private void saveSolution(List<Map<String, Object>> solutions) {
        for (Map<String, Object> solution : solutions) {
            Object name = solution.get("name");
            this.current = String.format(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u66f4\u65b0\uff1a\u89e3\u51b3\u65b9\u6848\uff08%s)", (String)"UpdateCloudSolutionJob_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name);
            try {
                if (SolutionUtil.isOmitted(solution)) {
                    this.omitted.incrementAndGet();
                    continue;
                }
                this.saveSolution(solution);
                this.success.incrementAndGet();
            }
            catch (Exception e) {
                this.failed.incrementAndGet();
                LOGGER.error("UpdateCloudSolutionJob,\u66f4\u65b0\u4e91\u7aef\u89e3\u51b3\u65b9\u6848[" + name + "]\u5931\u8d25\u3002" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
            }
        }
    }

    private static List<Map<String, Object>> querySolutionByPage(String api, int pageNo) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("pageSize", PublicResourceUtil.DEFAULT_PAGE_SIZE);
        param.put("pageNo", pageNo);
        return PublicResourceUtil.queryListByGet(api, param);
    }

    private void saveSolution(Map<String, Object> solution) {
        SolutionUtil.uploadLogo(solution);
        this.preHandleData(solution);
        ImportDynamicObject.innerImport(Json.toString(solution));
    }

    private void newSaveSolution(List<Map<String, Object>> solutions) {
        this.total = solutions.size();
        ArrayList<Long> solutionIds = new ArrayList<Long>(solutions.size());
        HashSet<String> resourceIds = new HashSet<String>(64);
        for (Map<String, Object> solution : solutions) {
            Object name = solution.get("name");
            this.current = String.format(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90\u66f4\u65b0\uff1a\u89e3\u51b3\u65b9\u6848\uff08%s\uff09", (String)"UpdateCloudSolutionJob_12", (String)"isc-iscb-platform-core", (Object[])new Object[0]), name);
            if (SolutionUtil.isOmitted(solution)) {
                this.omitted.incrementAndGet();
                continue;
            }
            SolutionUtil.saveSolutionAndResource(solution);
            this.success.incrementAndGet();
            solutionIds.add(D.l((Object)solution.get("id")));
            this.collectBuildWhitelistResourceId(solution, resourceIds);
        }
        if (!resourceIds.isEmpty()) {
            this.updateWhiteList(resourceIds);
        }
        SolutionSyncCloudUtil.uploadSolutionDownLoadInfo(solutionIds);
    }

    private void collectBuildWhitelistResourceId(Map<String, Object> solution, Set<String> resourceIds) {
        String pk;
        String dts;
        String type;
        List mainResources = (List)solution.get("main_resources");
        List refResources = (List)solution.get("ref_resources");
        for (Map res : mainResources) {
            type = D.s(res.get("main_res_type_id"));
            if (!this.canBuildWhitelist(type, dts = D.s(res.get("main_res_content_tag")))) continue;
            pk = D.s(res.get("main_res_pk"));
            resourceIds.add(pk);
        }
        for (Map res : refResources) {
            type = D.s(res.get("ref_res_type_id"));
            if (!this.canBuildWhitelist(type, dts = D.s(res.get("ref_res_content_tag")))) continue;
            pk = D.s(res.get("ref_res_pk"));
            resourceIds.add(pk);
        }
    }

    private boolean canBuildWhitelist(String type, String dts) {
        if ("isc_metadata_schema".equals(type)) {
            Map object = (Map)Json.toObject((String)dts);
            MetaType metaType = MetaType.valueOf((String)D.s(object.get("type")));
            return MetaType.SERVICE == metaType || MetaType.QUERY == metaType;
        }
        return IscWhiteListUtil.isBuildWhitelistType(type);
    }

    private void updateWhiteList(Set<String> resourceIds) {
        this.current = ResManager.loadKDString((String)"\u6b63\u5728\u66f4\u65b0\u4e91\u7aef\u767d\u540d\u5355\u6570\u636e\u5230\u672c\u5730", (String)"UpdateCloudSolutionJob_15", (String)"isc-iscb-platform-core", (Object[])new Object[0]);
        HashMap<String, Set<String>> paramMap = new HashMap<String, Set<String>>();
        paramMap.put("resourceIdList", resourceIds);
        UpdateCloudWhiteListJob updateJob = new UpdateCloudWhiteListJob(ResManager.loadKDString((String)"\u66f4\u65b0\u4e91\u7aef\u767d\u540d\u5355", (String)"UpdateCloudSolutionJob_16", (String)"isc-iscb-platform-core", (Object[])new Object[0]), Json.toString(paramMap));
        updateJob.run();
    }

    private void preHandleData(Map<String, Object> solution) {
        solution.put("main_resources", Collections.emptyList());
        solution.put("ref_resources", Collections.emptyList());
        solution.put("$id", D.l((Object)solution.get("id")));
        solution.put("$entityname", "isc_solution_center_m");
        solution.put("$isref", Boolean.FALSE);
    }
}

