/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.dts.ExportDynamicObject;
import kd.isc.iscb.platform.core.imp.FileResourceUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.solution.UpdateRefResourceJobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.g.Graph;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;

public class UpdateRefResourceJob
implements Job {
    public static final UpdateRefResourceJobFactory FACTORY = new UpdateRefResourceJobFactory();
    private String param;
    private long id;
    private String tile;
    private String current;
    private volatile int total;
    private AtomicLong size = new AtomicLong(0L);
    private AtomicInteger completed = new AtomicInteger(0);

    public UpdateRefResourceJob(String title, String param) {
        this.tile = title;
        this.param = param;
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return this.tile;
    }

    @Override
    public String refreshProgress() {
        return this.current;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        return new Job.Progress(this.total, this.completed.get(), this.current);
    }

    @Override
    public String getJobSummary() {
        return String.format(ResManager.loadKDString((String)"\u603b\u6570\uff1a%1$s\u4e2a\uff0c\u5b8c\u6210\uff1a%2$s\u4e2a\u3002", (String)"UpdateRefResourceJob_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.total, this.completed);
    }

    @Override
    public long getOwnerId() {
        return Math.abs(Hash.mur64((byte[])"UpdateRefResourceJob".getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public void run() {
        Map params = (Map)Json.toObject((String)this.param);
        List mainResources = (List)params.get("main_resources");
        this.id = D.l(params.get("id"));
        this.total = mainResources.size();
        Graph g = new Graph();
        ArrayList<DynamicObject> mainObjects = new ArrayList<DynamicObject>(mainResources.size());
        for (Map main : mainResources) {
            SignalManager.checkCancelSignal();
            String pk = D.s(main.get("main_res_pk"));
            String entity = D.s(main.get("main_res_type"));
            Object resPK = FileResourceUtil.parseResPK(pk, entity);
            if (!QueryServiceHelper.exists((String)entity, (Object)resPK)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u5bf9\u5e94\u7684\u8d44\u6e90ID(%2$s)\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u66f4\u65b0\u5176\u5f15\u7528\u8d44\u6e90\uff0c\u8bf7\u786e\u4fdd\u6240\u6709\u4e3b\u8d44\u6e90\u5728\u5f53\u524d\u73af\u5883\u5747\u5b58\u5728\uff0c\u4ee5\u4fbf\u8ba1\u7b97\u5f15\u7528\u8d44\u6e90\u3002", (String)"UpdateRefResourceJob_11", (String)"isc-iscb-platform-core", (Object[])new Object[0]), entity, resPK));
            }
            DynamicObject o = BusinessDataServiceHelper.loadSingle((Object)resPK, (String)entity);
            mainObjects.add(o);
            this.current = o.getDataEntityType().getDisplayName().toString() + "(" + main.get("main_res_number") + ")";
            ExportDynamicObject.append((Graph<DynamicObject>)g, o);
            this.completed.incrementAndGet();
        }
        List refResources = g.topSort();
        if (refResources.size() != g.getNodeCount()) {
            Map<String, List<String>> bills = ExportDynamicObject.getCrossRefs((Graph<DynamicObject>)g, refResources);
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e4b\u95f4\u5b58\u5728\u5faa\u73af\u5f15\u7528\u5173\u7cfb\uff0c\u4e0d\u80fd\u5bfc\u51fa\uff01\u6d89\u53ca\u7684\u5355\u636e\u6709\uff1a%s", (String)"UpdateRefResourceJob_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), bills));
        }
        this.updateEntries(refResources, mainObjects);
    }

    private void updateEntries(List<DynamicObject> refResources, List<DynamicObject> mainResources) {
        List<DynamicObject> mainObject = SolutionUtil.getMainResources(refResources, mainResources);
        Map<String, DynamicObject> dataMap = SolutionUtil.convertToMap(refResources, mainResources);
        DynamicObject solution = BusinessDataServiceHelper.loadSingle((Object)this.id, (String)"isc_solution_center_m");
        int refIndex = 0;
        DynamicObjectCollection refEntries = solution.getDynamicObjectCollection("ref_resources");
        refEntries.clear();
        for (DynamicObject data : dataMap.values()) {
            DynamicObject item = refEntries.addNew();
            String type = data.getDynamicObjectType().getName();
            this.setEntryValue(item, data, ++refIndex);
            item.set("ref_res_type", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)type, (String)"bos_objecttype"));
            item.set("ref_res_pk", data.getPkValue());
        }
        int mainIndex = 0;
        DynamicObjectCollection mainEntries = solution.getDynamicObjectCollection("main_resources");
        mainEntries.clear();
        for (DynamicObject data : mainObject) {
            DynamicObject item = mainEntries.addNew();
            String type = data.getDynamicObjectType().getName();
            this.setMainEntryValue(item, data, ++mainIndex);
            item.set("main_res_type", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)type, (String)"bos_objecttype"));
            item.set("main_res_pk", data.getPkValue());
        }
        solution.set("res_count", (Object)(mainResources.size() + dataMap.size()));
        SolutionUtil.evalPackageSize(solution);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{solution});
    }

    private void setEntryValue(DynamicObject item, DynamicObject data, int seq) {
        item.set("ref_res_number", (Object)data.getString("number"));
        item.set("ref_res_name", (Object)data.getString("name"));
        item.set("ref_res_time", (Object)D.t((Object)System.currentTimeMillis()));
        Map<String, Object> map = DynamicObjectUtil.object2Map(data);
        map.put("$id", data.getPkValue());
        map.put("$entityname", data.getDynamicObjectType().getName());
        map.put("$isref", Boolean.FALSE);
        String content = Json.toString(map);
        item.set("ref_res_content_tag", (Object)content);
        item.set("ref_res_size", (Object)content.length());
        item.set("ref_res_time", data.get(SolutionUtil.getTimeField(data.getDynamicObjectType().getName())));
        item.set("seq", (Object)seq);
        this.size.addAndGet(content.length());
    }

    private void setMainEntryValue(DynamicObject item, DynamicObject data, int seq) {
        item.set("main_res_number", (Object)data.getString("number"));
        item.set("main_res_name", (Object)data.getString("name"));
        item.set("main_res_time", (Object)D.t((Object)System.currentTimeMillis()));
        Map<String, Object> map = DynamicObjectUtil.object2Map(data);
        map.put("$id", data.getPkValue());
        map.put("$entityname", data.getDynamicObjectType().getName());
        map.put("$isref", Boolean.FALSE);
        String content = Json.toString(map);
        item.set("main_res_content_tag", (Object)content);
        item.set("main_res_size", (Object)content.length());
        item.set("main_res_time", data.get(SolutionUtil.getTimeField(data.getDynamicObjectType().getName())));
        item.set("seq", (Object)seq);
        this.size.addAndGet(content.length());
    }
}

