/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.platform.core.solution.SolutionResourceUtil;
import kd.isc.iscb.platform.core.solution.SolutionUtil;
import kd.isc.iscb.platform.core.solution.UpdateCloudSolutionJob;
import kd.isc.iscb.platform.core.solution.UpdateResourceListJobFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class UpdateResourceListJob
implements Job {
    private static final Log LOGGER = LogFactory.getLog(UpdateCloudSolutionJob.class);
    public static final JobFactory FACTORY = new UpdateResourceListJobFactory();
    private final String param;
    private final String title;
    private boolean success = false;
    private boolean omitted = false;
    private String current;

    public UpdateResourceListJob(String title, String param) {
        this.title = title;
        this.param = param;
    }

    @Override
    public String getParam() {
        return this.param;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String refreshProgress() {
        return String.format(ResManager.loadKDString((String)"\u6b63\u5728\u66f4\u65b0\u65b9\u6848\u5305\uff1a%s", (String)"UpdateResourceListJob_8", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.current);
    }

    @Override
    public String getJobSummary() {
        StringBuilder sb = new StringBuilder();
        if (this.success) {
            sb.append(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f\uff1a", (String)"UpdateResourceListJob_1", (String)"isc-iscb-platform-core", (Object[])new Object[0])).append(this.current);
        } else if (this.omitted) {
            sb.append(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u5305[%1$s]\u5df2\u5ffd\u7565\n\u4e91\u7aef\u65b9\u6848\u7248\u672c\u53f7\u5c0f\u4e8e\u6216\u7b49\u4e8e\u672c\u5730\u7248\u672c\u53f7\u3002", (String)"UpdateResourceListJob_2", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.current));
        } else {
            sb.append(ResManager.loadKDString((String)"\u4e91\u7aef\u6ca1\u6709\u60a8\u9009\u4e2d\u7684\u65b9\u6848\u5305\u8d44\u6e90", (String)"UpdateResourceListJob_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    @Override
    public void run() {
        this.updateSolution();
    }

    private void updateSolution() {
        try {
            String api = "kapi/v2/kdec/iscb/isc_solution_center/query_resources_by_id?id=" + this.param;
            List<Map<String, Object>> solutions = PublicResourceUtil.queryListByGet(api, null);
            if (solutions.isEmpty()) {
                return;
            }
            Map<String, Object> solution = solutions.get(0);
            this.current = D.s((Object)solution.get("name"));
            if (!SolutionUtil.isOmitted(solution)) {
                this.saveSolution(solution);
                this.success = true;
            } else {
                this.omitted = true;
            }
        }
        catch (Exception e) {
            String failed = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u4e91\u7aef\u89e3\u51b3\u65b9\u6848[%1$s]\u5931\u8d25\u3002\u539f\u56e0\u662f\uff1a%2$s", (String)"UpdateResourceListJob_10", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.param, StringUtil.getCascadeMessage((Throwable)e));
            LOGGER.error(failed, (Throwable)e);
            throw new IscBizException(failed, (Throwable)e);
        }
    }

    private void saveSolution(Map<String, Object> solution) {
        this.uploadLogo(solution);
        this.preHandleData(solution);
        ImportDynamicObject.innerImport(Json.toString(solution));
    }

    private void uploadLogo(Map<String, Object> solution) {
        String logo = D.s((Object)solution.get("logo"));
        if (StringUtils.isNotBlank((CharSequence)logo)) {
            solution.put("logo", SolutionResourceUtil.uploadLogoToFileServer(logo));
        }
    }

    private void preHandleData(Map<String, Object> solution) {
        solution.put("$id", D.l((Object)solution.get("id")));
        solution.put("$entityname", "isc_solution_center_m");
        solution.put("$isref", Boolean.FALSE);
    }
}

