/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution.resources;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.isc.iscb.platform.core.dts.EntityAndFieldsFilter;
import kd.isc.iscb.platform.core.solution.resources.DependentParseHandler;
import kd.isc.iscb.platform.core.solution.resources.DependentParseHandlerFactory;
import kd.isc.iscb.platform.core.solution.resources.ResourceMapping;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.g.Graph;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.Triple;

public class DependentParser {
    private final ResourceMapping resourceMapping;
    private final MainEntityType entityType;
    private final Map<String, Object> data;
    private final Graph<Pair<String, String>> g = new Graph();

    public DependentParser(String entity, Map<String, Object> data, ResourceMapping mapping) {
        this.entityType = EntityMetadataCache.getDataEntityType((String)entity);
        this.data = data;
        this.resourceMapping = mapping;
    }

    public List<Pair<String, String>> parse() {
        this.append((IDataEntityType)this.entityType, this.data, null);
        return this.g.topSort();
    }

    private void append(IDataEntityType entityType, Map<String, Object> data, String parent) {
        boolean added = this.appendNode(data);
        if (added) {
            this.doParse(entityType, data, parent);
        }
    }

    private boolean appendNode(Map<String, Object> data) {
        String key = this.getKey(data);
        if (this.g.contains(key)) {
            return false;
        }
        this.g.appendVertex(key, this.keyToPair(key));
        return true;
    }

    private void doParse(IDataEntityType entityType, Map<String, Object> data, String parent) {
        for (IDataEntityProperty p : entityType.getProperties()) {
            if (p instanceof MulBasedataProp) {
                this.parseMulBaseData(data, (MulBasedataProp)p, parent);
                continue;
            }
            if (p instanceof BasedataProp) {
                this.parseBaseData(data, (BasedataProp)p, parent);
                continue;
            }
            if (p instanceof EntryProp) {
                if ("isc_data_copy".equals(entityType.getName())) {
                    this.parseDcEntry(data, (EntryProp)p);
                }
                this.parseEntry(data, (EntryProp)p);
                continue;
            }
            if (!(entityType instanceof EntryType) || !this.isIndirectRef(entityType.getParent().getName(), entityType.getName(), p.getName())) continue;
            this.parseIndirectRef(data, entityType.getParent().getName(), parent);
        }
    }

    private boolean isIndirectRef(String entity, String entry, String field) {
        Set<Triple<String, String, String>> indirectRefSet = EntityAndFieldsFilter.getIndirectRefSet();
        return indirectRefSet.contains(new Triple((Object)entity, (Object)entry, (Object)field));
    }

    private void parseIndirectRef(Map<String, Object> data, String entity, String parent) {
        DependentParseHandler handler = DependentParseHandlerFactory.get(entity);
        Map<String, Object> indirectRef = handler.getIndirectRef(parent, data, this.resourceMapping);
        if (!indirectRef.isEmpty()) {
            String refId = D.s((Object)indirectRef.get("id"));
            this.parseRef(entity, refId, parent);
        }
    }

    private void parseMulBaseData(Map<String, Object> data, MulBasedataProp p, String parent) {
        String name = p.getName();
        Object value = data.get(name);
        if (value == null) {
            return;
        }
        List list = CollectionUtils.toList(value);
        String entity = p.getComplexType().getName();
        for (Object v : list) {
            String refId = D.s(v);
            if (refId == null || !this.resourceMapping.exists(entity, refId)) continue;
            if (data.containsKey("id") && data.containsKey("$entityname")) {
                this.parseRef(entity, refId, this.getKey(data));
                continue;
            }
            this.parseRef(entity, refId, parent);
        }
    }

    private void parseBaseData(Map<String, Object> data, BasedataProp p, String parent) {
        String refEntity;
        if (p instanceof ItemClassProp) {
            ItemClassProp itemClassProp = (ItemClassProp)p;
            refEntity = D.s((Object)data.get(itemClassProp.getTypePropName()));
        } else {
            refEntity = p.getBaseEntityId();
        }
        String propIdName = p.getRefIdPropName();
        Object originalId = data.get(propIdName);
        String refId = D.s((Object)originalId);
        if (refId != null && this.resourceMapping.exists(refEntity, refId)) {
            if (data.containsKey("id") && data.containsKey("$entityname")) {
                this.parseRef(refEntity, refId, this.getKey(data));
            } else {
                this.parseRef(refEntity, refId, parent);
            }
        }
    }

    private void parseRef(String refEntity, String refId, String parent) {
        Map<String, Object> refData = this.resourceMapping.load(refEntity, refId);
        String from = this.getKey(refData);
        if (this.g.contains(from, parent)) {
            return;
        }
        this.append((IDataEntityType)EntityMetadataCache.getDataEntityType((String)refEntity), refData, parent);
        this.g.append(from, parent);
    }

    private void parseEntry(Map<String, Object> data, EntryProp p) {
        String name = p.getName();
        List list = (List)data.get(name);
        if (!CollectionUtils.isEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                IDataEntityType type = p.getItemType();
                this.doParse(type, map, this.getKey(data));
            }
        }
    }

    private void parseDcEntry(Map<String, Object> data, EntryProp p) {
        String entryName = p.getName();
        if ("mapping_entries".equals(entryName) || "filter_entries".equals(entryName) || "sort_entries".equals(entryName)) {
            Object source_schema_id = data.get("source_schema_id");
            Object target_schema_id = data.get("target_schema_id");
            HashMap<String, Map<String, Object>> srcRefMap = new HashMap<String, Map<String, Object>>(16);
            Map<String, Object> source_schema = this.resourceMapping.load("isc_metadata_schema", source_schema_id);
            this.getRefMap(null, source_schema, srcRefMap);
            HashMap<String, Map<String, Object>> tarRefMap = new HashMap<String, Map<String, Object>>(16);
            Map<String, Object> target_schema = this.resourceMapping.load("isc_metadata_schema", target_schema_id);
            this.getRefMap(null, target_schema, tarRefMap);
            List entries = (List)data.get(entryName);
            for (Map e : entries) {
                DataEntityPropertyCollection collection = p.getItemType().getProperties();
                for (IDataEntityProperty prop : collection) {
                    String name = prop.getName();
                    String value = D.s(e.get(name));
                    if (value == null) continue;
                    if ("mapping_entries".equals(entryName)) {
                        if ("mapping_src_column".equals(name)) {
                            this.setRef(srcRefMap, value, this.getKey(data));
                            continue;
                        }
                        if (!"mapping_tar_column".equals(name)) continue;
                        this.setRef(tarRefMap, value, this.getKey(data));
                        continue;
                    }
                    if ("filter_entries".equals(entryName)) {
                        if (!"filter_column".equals(name)) continue;
                        this.setRef(srcRefMap, value, this.getKey(data));
                        continue;
                    }
                    if (!"sort_field".equals(name)) continue;
                    this.setRef(srcRefMap, value, this.getKey(data));
                }
            }
        }
    }

    private void setRef(Map<String, Map<String, Object>> refMap, String value, String parentDc) {
        Map<String, Object> ref = refMap.get(value);
        if (ref != null) {
            String refId = D.s((Object)ref.get("id"));
            String refEntity = D.s((Object)ref.get("$entityname"));
            this.parseRef(refEntity, refId, parentDc);
        }
    }

    private void getRefMap(String parent, Map<String, Object> metaSchema, Map<String, Map<String, Object>> map) {
        if (metaSchema == null) {
            return;
        }
        List prop_entryentity = (List)metaSchema.get("prop_entryentity");
        Map<String, Object> metaschemaObject = null;
        for (Map prop : prop_entryentity) {
            String key;
            String data_schema = D.s(prop.get("data_schema"));
            String data_type = D.s(prop.get("data_type"));
            String prop_name = D.s(prop.get("prop_name"));
            long groupId = D.l((Object)metaSchema.get("group_id"));
            if (!"REF".equals(data_type) && !"ENTRIES".equals(data_type) || (metaschemaObject = this.resourceMapping.loadMetaSchemaByNumberAndGroup(groupId, data_schema)).isEmpty()) continue;
            String string = key = parent == null ? prop_name : parent + "." + prop_name;
            if ("REF".equals(data_type)) {
                map.put(key, metaschemaObject);
                continue;
            }
            this.getRefMap(key, metaschemaObject, map);
        }
    }

    private String getKey(Map<String, Object> data) {
        String entity = D.s((Object)data.get("$entityname"));
        String pk = D.s((Object)data.get("id"));
        return entity + "," + pk;
    }

    private Pair<String, String> keyToPair(String key) {
        String[] split = key.split(",");
        String entity = split[0];
        String pk = split[1];
        return new Pair((Object)entity, (Object)pk);
    }
}

