/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.solution.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;

public class ResourceMapping {
    private final Map<String, List<DynamicObject>> mainResMapping = new ConcurrentHashMap<String, List<DynamicObject>>();
    private final Map<String, List<DynamicObject>> refResMapping = new ConcurrentHashMap<String, List<DynamicObject>>();
    private final List<DynamicObject> mainResources = new ArrayList<DynamicObject>();
    private final List<DynamicObject> refResources = new ArrayList<DynamicObject>();
    private final Map<String, DynamicObject> refResUsePkKey = new ConcurrentHashMap<String, DynamicObject>();
    private final Map<String, Map<String, Object>> refResContentMapUsePkKey = new ConcurrentHashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Object>> refMetaschemaContentMap = new ConcurrentHashMap<String, Map<String, Object>>();

    public void addMainResMapping(String entity, DynamicObject mainResRow) {
        if (mainResRow == null) {
            return;
        }
        List<DynamicObject> list = this.mainResMapping.computeIfAbsent(entity, new Function<String, List<DynamicObject>>(){

            @Override
            public List<DynamicObject> apply(String k) {
                return new ArrayList<DynamicObject>();
            }
        });
        list.add(mainResRow);
        this.mainResources.add(mainResRow);
    }

    public void addRefResMapping(String entity, DynamicObject refResRow) {
        if (refResRow == null) {
            return;
        }
        List<DynamicObject> list = this.refResMapping.computeIfAbsent(entity, new Function<String, List<DynamicObject>>(){

            @Override
            public List<DynamicObject> apply(String k) {
                return new ArrayList<DynamicObject>();
            }
        });
        list.add(refResRow);
        this.refResources.add(refResRow);
        this.refResUsePkKey.put(refResRow.getString("ref_res_pk"), refResRow);
        String json = D.s((Object)refResRow.get("ref_res_content_tag"));
        Map content = (Map)Json.toObject((String)json);
        this.refResContentMapUsePkKey.put(refResRow.getString("ref_res_pk"), content);
        if ("isc_metadata_schema".equals(content.get("$entityname"))) {
            String key = D.s(content.get("group_id")) + "," + refResRow.getString("ref_res_number");
            this.refMetaschemaContentMap.put(key, content);
        }
    }

    public Map<String, Object> load(long entryid) {
        for (DynamicObject o : this.mainResources) {
            if (!o.getPkValue().equals(entryid)) continue;
            String json = D.s((Object)o.get("main_res_content_tag"));
            return (Map)Json.toObject((String)json);
        }
        for (DynamicObject o : this.refResources) {
            if (!o.getPkValue().equals(entryid)) continue;
            String json = D.s((Object)o.get("ref_res_content_tag"));
            return (Map)Json.toObject((String)json);
        }
        return Collections.emptyMap();
    }

    public boolean exists(String entity, Object pk) {
        List<DynamicObject> mainList = this.mainResMapping.get(entity);
        if (mainList != null) {
            for (DynamicObject o : mainList) {
                if (!o.getString("main_res_pk").equals(D.s((Object)pk))) continue;
                return true;
            }
        }
        return this.refResUsePkKey.containsKey(D.s((Object)pk));
    }

    public Map<String, Object> load(String entity, Object pk) {
        Map<String, Object> refContent;
        List<DynamicObject> mainList = this.mainResMapping.get(entity);
        if (mainList != null) {
            for (DynamicObject o : mainList) {
                if (!o.getString("main_res_pk").equals(D.s((Object)pk))) continue;
                String json = D.s((Object)o.get("main_res_content_tag"));
                return (Map)Json.toObject((String)json);
            }
        }
        if ((refContent = this.refResContentMapUsePkKey.get(D.s((Object)pk))) == null) {
            return Collections.emptyMap();
        }
        return refContent;
    }

    public Map<String, Object> loadMetaSchemaByNumberAndGroup(long dataSourceId, String number) {
        Map<String, Object> refContent;
        List<DynamicObject> mainList = this.mainResMapping.get("isc_metadata_schema");
        if (mainList != null) {
            for (DynamicObject o : mainList) {
                Map<String, Object> data = this.findContentObj(dataSourceId, number, o, 1);
                if (data.isEmpty()) continue;
                return data;
            }
        }
        if ((refContent = this.refMetaschemaContentMap.get(dataSourceId + "," + number)) != null && D.s((Object)refContent.get("group_id")).equals(D.s((Object)dataSourceId))) {
            return refContent;
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> findContentObj(long dataSourceId, String number, DynamicObject o, int mode) {
        String json;
        Map data;
        String contentKey;
        String entryNumber = mode == 1 ? "main_res_number" : "ref_res_number";
        String string = contentKey = mode == 1 ? "main_res_content_tag" : "ref_res_content_tag";
        if (o.getString(entryNumber).equals(number) && D.s((data = (Map)Json.toObject((String)(json = D.s((Object)o.get(contentKey))))).get("group_id")).equals(D.s((Object)dataSourceId))) {
            return data;
        }
        return Collections.emptyMap();
    }

    public List<DynamicObject> findEntryByKey(List<Pair<String, String>> keys) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (Pair<String, String> pair : keys) {
            String entity = (String)pair.getA();
            String pk = (String)pair.getB();
            for (DynamicObject o : this.mainResMapping.getOrDefault(entity, Collections.emptyList())) {
                if (!o.getString("main_res_pk").equals(pk)) continue;
                result.add(o);
            }
            DynamicObject refEntry = this.refResUsePkKey.get(pk);
            if (refEntry == null) continue;
            result.add(refEntry);
        }
        return result;
    }

    public DynamicObject get(long entryid) {
        for (DynamicObject o : this.mainResources) {
            if (D.l((Object)o.getPkValue()) != entryid) continue;
            return o;
        }
        for (DynamicObject o : this.refResources) {
            if (D.l((Object)o.getPkValue()) != entryid) continue;
            return o;
        }
        return null;
    }
}

