/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.startjob;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.startjob.ApiCronJob;
import kd.isc.iscb.platform.core.startjob.Const;
import kd.isc.iscb.platform.core.startjob.FlowCronJob;
import kd.isc.iscb.platform.core.startjob.TriggerCronJob;
import kd.isc.iscb.platform.core.util.TimeUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import org.quartz.CronExpression;

public class CronJobUtil
implements Const {
    public static final String IS_ISC_SCHEDULE_ENABLE = "IS_ISC_SCHEDULE_ENABLE";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void enable(String type, String cron, Timestamp start, Timestamp expire, long id, String title, long creator) {
        Timestamp scheduledTime = CronJobUtil.getNextTimestamp(cron, start);
        long expireTime = CronJobUtil.getExpireTime(expire);
        if (scheduledTime.getTime() < expireTime) {
            if ("isc_service_flow".equals(type)) {
                FlowCronJob job = new FlowCronJob(cron, 1L, id, title, expireTime);
                JobEngine.submitX(job, scheduledTime, creator);
                return;
            } else if ("isc_data_copy_trigger".equals(type)) {
                TriggerCronJob job = new TriggerCronJob(cron, 1L, id, title, expireTime);
                JobEngine.submitX(job, scheduledTime, creator);
                return;
            } else {
                if (!"isc_call_api_by_timer".equals(type)) throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u5b9a\u65f6\u4efb\u52a1\u7c7b\u578b\uff1a%s", (String)"CronJobUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
                ApiCronJob job = new ApiCronJob(cron, 1L, id, title, expireTime);
                JobEngine.submitX(job, scheduledTime, creator);
            }
            return;
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u5f53\u524d\u542f\u52a8\u65b9\u6848\u4e0b\u6b21\u6267\u884c\u8ba1\u5212\u65f6\u95f4\u3010%1$s\u3011\u5927\u4e8e\u6240\u914d\u7f6e\u7684\u8fc7\u671f\u65f6\u95f4\u3010%2$s\u3011\uff0c\u65e0\u6548\u5b9a\u65f6\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"CronJobUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), TimeUtil.getInteTime(new Date(scheduledTime.getTime()), sdf), TimeUtil.getInteTime(new Date(expireTime), sdf)));
        }
    }

    private static long getExpireTime(Timestamp expire) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(9999, 11, 31);
        return expire != null ? expire.getTime() : calendar.getTime().getTime();
    }

    public static boolean isIscScheduleEnable() {
        String tenantId = RequestContext.get().getTenantId();
        String prop = D.s((Object)SystemPropertyUtils.getProptyByTenant((String)IS_ISC_SCHEDULE_ENABLE, (String)tenantId));
        return prop == null || "true".equalsIgnoreCase(prop);
    }

    private static Timestamp getNextTimestamp(String cron, Timestamp start) {
        CronExpression cronEx = null;
        try {
            cronEx = new CronExpression(cron);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        assert (cronEx != null);
        long time = start != null ? Math.max(System.currentTimeMillis(), start.getTime()) : System.currentTimeMillis();
        Date date = new Date(time);
        Date after = cronEx.getNextValidTimeAfter(date);
        return D.t((Object)after.getTime());
    }

    public static void disable(long id) {
        if (JobEngine.existsRunningJobWithOwnerId(id)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5b58\u5728\u6267\u884c\u4e2d\u6216\u7b49\u5f85\u4e2d\u7684\u5173\u8054\u4efb\u52a1\uff0c\u8bf7\u7b49\u5f85\u540e\u53f0\u4efb\u52a1\u6267\u884c\u5b8c\u6210\u6216\u64a4\u9500\u8be5\u4efb\u52a1\u540e\uff0c\u8fdb\u884c\u542f\u7528/\u7981\u7528\u64cd\u4f5c\u3002\u4efb\u52a1\u7684ownerId\u662f\uff1a%s", (String)"CronJobUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), id));
        }
        JobEngine.dropNoRunningJobByOwnerId(id);
    }
}

