/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.startjob;

import java.util.Collections;
import java.util.HashMap;
import kd.isc.iscb.platform.core.job.AbstractCronJob;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.sf.ServiceFlowEngine;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.res.DataSourceResource;
import kd.isc.iscb.platform.core.startjob.Const;
import kd.isc.iscb.platform.core.startjob.FlowCronJobFactory;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.trace.TraceTask;

public class FlowCronJob
extends AbstractCronJob
implements Const {
    public static final JobFactory FACTORY = new FlowCronJobFactory();
    private long id;
    private String title;

    public FlowCronJob(String schedule, long count, long id, String title, long expireTime) {
        super(schedule, count, expireTime);
        this.id = id;
        this.title = title;
    }

    @Override
    public String getParam() {
        HashMap<String, Object> param = new HashMap<String, Object>(5);
        param.put("id", this.id);
        param.put("schedule", this.getSchedule());
        param.put("title", this.title);
        param.put("count", this.getCount());
        param.put("expireTime", this.getExpireTime());
        return Json.toString(param);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public void run() {
        TraceStack.trace(Caller.Timer, new TraceTask(){

            public void run() {
                DataSourceResource.createConnectionPool();
                try {
                    long releasedFlowId = ServiceFlowParser.findReleasedFlowId(FlowCronJob.this.id);
                    ServiceFlowEngine.createAndExecute(releasedFlowId, new Object[0], Collections.emptyMap());
                }
                catch (Throwable throwable) {
                }
                finally {
                    DataSourceResource.disposeConnectionPool();
                }
            }
        });
    }

    @Override
    public long getOwnerId() {
        return this.id;
    }
}

