/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.syndata;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.syndata.DataResp;
import kd.isc.iscb.platform.core.syndata.ISynData;
import kd.isc.iscb.platform.core.syndata.ProgressCache;
import kd.isc.iscb.platform.core.syndata.SynDataUtil;
import kd.isc.iscb.platform.core.syndata.SyncBaseDataTask;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.StringUtil;

public abstract class AbstractSynData
implements ISynData {
    private static final String FIELD_MESSAGE_TAG = "message_tag";
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_ID = "id";
    private static final String ISC_SYNC_DATA_LOG = "isc_sync_data_log";
    private static final String FIELD_STATUS = "status";
    protected static final String ENABLE_STR = "enable";
    protected static final String STATUS_STR = "status";
    protected DynamicObject log;
    protected DynamicObject baseSchema;
    private static Log logger = LogFactory.getLog(SyncBaseDataTask.class);

    public AbstractSynData(DynamicObject baseSchema) {
        this(baseSchema, true);
    }

    protected AbstractSynData(DynamicObject baseSchema, boolean isLog) {
        this.baseSchema = baseSchema;
        if (isLog) {
            QFilter qFilter = new QFilter("base_schema", "=", (Object)baseSchema.getLong(FIELD_ID));
            qFilter.and("status", "in", (Object)new String[]{"0", "1"});
            DynamicObject log = BusinessDataServiceHelper.loadSingle((String)ISC_SYNC_DATA_LOG, (String)"id,status,modify_time,message,message_tag", (QFilter[])new QFilter[]{qFilter});
            if (log != null) {
                if (this.isJobOvertime(log)) {
                    log.set(FIELD_MESSAGE, (Object)ResManager.loadKDString((String)"\u8d85\u8fc730\u5206\u949f\u672a\u66f4\u65b0\u72b6\u6001\uff0c\u4efb\u52a1\u5931\u8d25", (String)"AbstractSynData_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                    log.set(FIELD_MESSAGE_TAG, (Object)ResManager.loadKDString((String)"\u8d85\u8fc730\u5206\u949f\u672a\u66f4\u65b0\u72b6\u6001\uff0c\u4efb\u52a1\u5931\u8d25", (String)"AbstractSynData_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
                    SynDataUtil.updateStatus(log, "3");
                } else {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6570\u636e\u540c\u6b65\u4efb\u52a1[%s]\u5df2\u7ecf\u5728\u6267\u884c\u4e2d", (String)"AbstractSynData_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), baseSchema.getString("name")));
                }
            }
            this.log = SynDataUtil.initLog(baseSchema.getLong(FIELD_ID), "isc_base_schema");
        }
    }

    public void invoke() {
        this.invoke(new ProgressCache(-1, -1));
    }

    public void invoke(ProgressCache progress) {
        SynDataUtil.updateStatus(this.log, "1");
        long dataSchemaId = this.baseSchema.getLong("data_schema_id");
        DynamicObject dataSchema = BusinessDataServiceHelper.loadSingle((Object)dataSchemaId, (String)"isc_metadata_schema");
        long dataSourceId = dataSchema.getLong("group_id");
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source");
        ConnectionWrapper connectionWrapper = null;
        ObjectReader<? extends Map<String, Object>> reader = null;
        ConnectionManager.pushResLicense(true);
        try {
            connectionWrapper = ConnectionManager.getConnection((Long)dataSource.get("dblink_id"));
            DataResp<? extends Map<String, Object>> resp = this.queryData(connectionWrapper, dataSchema);
            long count = resp.getCount();
            SynDataUtil.updateTotalCount(this.log, count, 0L);
            if (count > 0L) {
                this.deleteAllData(this.baseSchema.getLong(FIELD_ID));
            }
            reader = resp.getReader();
            this.handleData(this.baseSchema.getLong(FIELD_ID), dataSchemaId, reader, progress);
            SynDataUtil.updateStatus(this.log, "2");
        }
        catch (Throwable e) {
            logger.warn("\u540c\u6b65\u8fc7\u7a0b\u51fa\u9519", e);
            String s = StringUtil.toString((Throwable)e);
            this.log.set(FIELD_MESSAGE, (Object)AbstractSynData.trim(s));
            this.log.set(FIELD_MESSAGE_TAG, (Object)s);
            SynDataUtil.updateStatus(this.log, "3");
            progress.setErr(e);
            throw D.e((Throwable)e);
        }
        finally {
            ConnectionManager.popResLicense();
            DbUtil.close(reader);
            ConnectorUtil.close(connectionWrapper);
        }
    }

    private static String trim(String s) {
        if (s != null && s.length() > 200) {
            s = s.substring(0, 200);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllData(long baseSchemaId) {
        while (true) {
            Connection cn = TX.__getAloneConnection((String)"ISCB", (boolean)false, (String)"t_iscb_basic_data", (String[])new String[0]);
            try {
                List<DataRow> list = this.queryTop500FID(baseSchemaId, cn);
                if (list.isEmpty()) break;
                this.deleteBasicData(cn, list);
                continue;
            }
            finally {
                DbUtil.close((Connection)cn, (boolean)true);
                continue;
            }
            break;
        }
    }

    private List<DataRow> queryTop500FID(long baseSchemaId, Connection cn) {
        String selectFidSql = "SELECT top 500 fid from t_iscb_basic_data where fbaseschema = ? ";
        List<Long> values = Collections.singletonList(baseSchemaId);
        List<Integer> types = Collections.singletonList(-5);
        return DbUtil.executeList((Connection)cn, (String)selectFidSql, values, types);
    }

    private void deleteBasicData(Connection cn, List<DataRow> list) {
        ArrayList<Object> ids = new ArrayList<Object>(list.size());
        ArrayList<Integer> idTypes = new ArrayList<Integer>(list.size());
        StringBuilder deleteMainSql = new StringBuilder("delete from t_iscb_basic_data where fid in ");
        StringBuilder deleteMultiLangSql = new StringBuilder("delete from t_iscb_basic_data_l where fid in ");
        StringBuilder whereSql = this.generateWhereAndParams(list, ids, idTypes);
        DbUtil.executeUpdate((Connection)cn, (String)deleteMainSql.append((CharSequence)whereSql).toString(), ids, idTypes);
        DbUtil.executeUpdate((Connection)cn, (String)deleteMultiLangSql.append((CharSequence)whereSql).toString(), ids, idTypes);
    }

    private StringBuilder generateWhereAndParams(List<DataRow> list, List<Object> ids, List<Integer> idTypes) {
        StringBuilder whereSql = new StringBuilder("(");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                whereSql.append(',');
            }
            whereSql.append('?');
            DataRow row = list.get(i);
            ids.add(D.l((Object)row.get((Object)"fid")));
            idTypes.add(-5);
        }
        whereSql.append(')');
        return whereSql;
    }

    private void handleData(long baseSchemaId, long dataSchemaId, ObjectReader<? extends Map<String, Object>> reader, ProgressCache progress) {
        long lastUpdateCountTime = System.currentTimeMillis();
        int execCount = 0;
        Map item = (Map)reader.read();
        while (item != null) {
            SignalManager.checkCancelSignal();
            ++execCount;
            this.insertBaseData(baseSchemaId, dataSchemaId, item);
            if (System.currentTimeMillis() - lastUpdateCountTime >= 5000L) {
                SynDataUtil.updateExecCount(this.log, execCount);
                lastUpdateCountTime = System.currentTimeMillis();
            }
            progress.refresh(reader.getTotalCount(), execCount);
            item = (Map)reader.read();
        }
        SynDataUtil.updateExecCount(this.log, execCount);
    }

    private DynamicObject getBaseData(long baseSchemaId, String oid) {
        QFilter qFilter = new QFilter("baseschema", "=", (Object)baseSchemaId);
        qFilter.and("oid", "=", (Object)oid);
        return BusinessDataServiceHelper.loadSingle((String)"isc_basic_data", (String)"id,number,name,cus_field1,cus_field2,cus_field3,enable", (QFilter[])new QFilter[]{qFilter});
    }

    private boolean isJobOvertime(DynamicObject log) {
        Date modifyTime = log.getDate("modify_time");
        return log.getInt("status") == 1 && System.currentTimeMillis() - modifyTime.getTime() > 1800000L;
    }
}

