/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.syndata;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.syndata.AbstractSynData;
import kd.isc.iscb.platform.core.syndata.DataResp;
import kd.isc.iscb.platform.core.util.MultiLangUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class EntitySynData
extends AbstractSynData {
    private static final String CUS_FIELD_3 = "cus_field3";
    private static final String CUS_FIELD_2 = "cus_field2";
    private static final String CUS_FIELD_1 = "cus_field1";
    private String number_field;
    private String name_field;
    private String c1;
    private String c2;
    private String c3;
    private String pk_field;

    public EntitySynData(DynamicObject baseSchema, boolean isLog) {
        super(baseSchema, isLog);
        this.init(baseSchema);
    }

    public EntitySynData(DynamicObject baseSchema) {
        super(baseSchema);
        this.init(baseSchema);
    }

    private void init(DynamicObject baseSchema) {
        this.number_field = baseSchema.getString("number_field");
        this.name_field = baseSchema.getString("name_field");
        Object data_schema_id = baseSchema.get("data_schema_id");
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)data_schema_id, (String)"isc_metadata_schema");
        DynamicObjectCollection props = meta.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject prop : props) {
            if (!prop.getBoolean("is_primary_key")) continue;
            this.pk_field = prop.getString("prop_name");
            break;
        }
        if (StringUtils.isEmpty((String)this.number_field)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u540c\u6b65\uff0c\u7f16\u7801\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u4fee\u6539\u96c6\u6210\u8d44\u6599\u6a21\u578b", (String)"EntitySynData_0", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)this.name_field)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u540c\u6b65\uff0c\u540d\u79f0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u96c6\u6210\u8d44\u6599\u6a21\u578b", (String)"EntitySynData_1", (String)"isc-iscb-platform-core", (Object[])new Object[0]));
        }
        this.c1 = D.s((Object)baseSchema.getString(CUS_FIELD_1));
        this.c2 = D.s((Object)baseSchema.getString(CUS_FIELD_2));
        this.c3 = D.s((Object)baseSchema.getString(CUS_FIELD_3));
    }

    @Override
    public String getOid(Map<String, Object> item) {
        return D.s((Object)item.get("id"));
    }

    @Override
    public void updateBaseData(DynamicObject baseData, Map<String, Object> item) {
        Object number = item.get(this.number_field);
        baseData.set("number", (Object)this.getValue(number));
        Object name = item.get(this.name_field);
        baseData.set("name", (Object)this.getValue(name));
        baseData.set(CUS_FIELD_1, (Object)this.getValue(item.get(this.c1)));
        baseData.set(CUS_FIELD_2, (Object)this.getValue(item.get(this.c2)));
        baseData.set(CUS_FIELD_3, (Object)this.getValue(item.get(this.c3)));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{baseData});
    }

    @Override
    public void insertBaseData(long baseSchemaId, long dataSchemaId, Map<String, Object> item) {
        DynamicObject newObject = BusinessDataServiceHelper.newDynamicObject((String)"isc_basic_data");
        newObject.set("oid", (Object)D.s((Object)item.get(this.pk_field)));
        Object number = item.get(this.number_field);
        newObject.set("number", (Object)this.getValue(number));
        Object name = item.get(this.name_field);
        newObject.set("name", (Object)this.getValue(name));
        newObject.set(CUS_FIELD_1, (Object)this.getValue(item.get(this.c1)));
        newObject.set(CUS_FIELD_2, (Object)this.getValue(item.get(this.c2)));
        newObject.set(CUS_FIELD_3, (Object)this.getValue(item.get(this.c3)));
        newObject.set("baseschema", (Object)baseSchemaId);
        newObject.set("dataschema", (Object)dataSchemaId);
        newObject.set("enable", (Object)"1");
        newObject.set("status", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObject});
    }

    private String getValue(Object value) {
        return MultiLangUtil.getMultiLangValue(value);
    }

    public DataResp<Map<String, Object>> queryData(ConnectionWrapper connectionWrapper, DynamicObject dataSchema) {
        ObjectReader<Map<String, Object>> meta = this.query(connectionWrapper, dataSchema);
        long count = D.l((Object)meta.getTotalCount());
        DataResp<Map<String, Object>> resp = new DataResp<Map<String, Object>>(count, meta);
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryCount(ConnectionWrapper connectionWrapper, DynamicObject dataSchema) {
        ObjectReader<Map<String, Object>> meta = null;
        try {
            meta = this.query(connectionWrapper, dataSchema);
            long l = D.l((Object)meta.getTotalCount());
            return l;
        }
        finally {
            DbUtil.close(meta);
        }
    }

    private ObjectReader<Map<String, Object>> query(ConnectionWrapper connectionWrapper, DynamicObject dataSchema) {
        StringBuilder sb = new StringBuilder(this.pk_field);
        sb.append(',').append(this.number_field);
        sb.append(',').append(this.name_field);
        if (this.c1 != null) {
            sb.append(',').append(this.c1);
        }
        if (this.c2 != null) {
            sb.append(',').append(this.c2);
        }
        if (this.c3 != null) {
            sb.append(',').append(this.c3);
        }
        return ConnectionManager.query(connectionWrapper, dataSchema.getString("full_name"), sb.toString().split(","));
    }
}

