/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.syndata;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.syndata.MapDataJobFactory;
import kd.isc.iscb.platform.core.syndata.ProgressCache;
import kd.isc.iscb.platform.core.syndata.SyncBaseDataTask;

public class MapDataJob
implements Job {
    public static final JobFactory FACTORY = new MapDataJobFactory();
    private long id;
    private String title;
    private ProgressCache progressCache;

    public MapDataJob(long id, String title) {
        this.id = id;
        this.title = title;
    }

    @Override
    public String getParam() {
        return String.valueOf(this.id);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void run() {
        DynamicObject converRule = BusinessDataServiceHelper.loadSingle((Object)this.id, (String)"isc_value_conver_rule");
        this.progressCache = new ProgressCache(0, 0);
        SyncBaseDataTask.doAutoMapping(converRule, this.progressCache);
    }

    @Override
    public JobFactory getFactory() {
        return FACTORY;
    }

    @Override
    public String refreshProgress() {
        return this.progressCache.getCompleted() + "/" + this.progressCache.getTotal();
    }

    @Override
    public long getOwnerId() {
        return this.id;
    }

    @Override
    public Job.Progress getRealtimeProgress() {
        Job.Progress progress = new Job.Progress(this.progressCache.getTotal(), this.progressCache.getCompleted(), String.format(ResManager.loadKDString((String)"\u5171\uff1a%1$s \u6761\uff0c\u5df2\u5339\u914d\uff1a%2$s \u6761\u3002", (String)"MapDataJob_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.progressCache.getTotal(), this.progressCache.getCompleted()));
        return progress;
    }

    @Override
    public String getJobSummary() {
        return String.format(ResManager.loadKDString((String)"\u5339\u914d\u5b8c\u6210\uff0c\u5171\u5339\u914d %s \u6761\u3002", (String)"MapDataJob_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), this.progressCache.getTotal());
    }
}

