/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.syndata;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.syndata.ProgressCache;
import kd.isc.iscb.platform.core.syndata.SynDataUtil;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.vc.ValueConversionRule;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleConfig;
import kd.isc.iscb.platform.core.vc.ValueConversionRuleFactory;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;

public class MapDataUtil {
    private static final String ENTITY_ISC_MAPPING_DATA = "isc_mapping_data";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_OID = "oid";
    private static final String FIELD_MODIFYTIME = "modifytime";
    private static final String FIELD_CREATETIME = "createtime";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_ENABLE = "enable";
    private static final String ENTITY_ISC_BASE_SCHEMA = "isc_base_schema";
    private static final String FIELD_DATA_SCHEMA = "data_schema";
    private static final String FIELD_NUMBER = "number";
    private static Log logger = LogFactory.getLog(MapDataUtil.class);
    private static final HashSet<String> numberList = new HashSet(8);
    private static final HashSet<String> nameList = new HashSet(5);

    public static boolean existNumber(String number) {
        return numberList.contains(number);
    }

    public static boolean existName(String name) {
        return nameList.contains(name);
    }

    public static void autoMapData(DynamicObject converRule, DynamicObject log) {
        MapDataUtil.autoMapData(converRule, log, new ProgressCache(-1, -1));
    }

    public static void autoMapData(DynamicObject converRule, DynamicObject log, ProgressCache progress) {
        String message;
        DynamicObject source_data_schema = converRule.getDynamicObject("source_data_schema");
        DynamicObjectCollection sourceDataCollection = MapDataUtil.getDataCollection(source_data_schema);
        DynamicObject target_data_schema = converRule.getDynamicObject("target_data_schema");
        DynamicObjectCollection targetDataCollection = MapDataUtil.getDataCollection(target_data_schema);
        HashMap<String, DynamicObject> targetOidMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> targetNumberMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> targetNameMap = new HashMap<String, DynamicObject>();
        MapDataUtil.initMap(targetDataCollection, targetOidMap, targetNumberMap, targetNameMap);
        Map<String, Long> existsMappingMap = MapDataUtil.getExistsMappingMap(converRule.getLong("id"));
        int totalCount = sourceDataCollection.size();
        SynDataUtil.updateTotalCount(log, totalCount, 0L);
        int mapCount = 0;
        if (totalCount > 0) {
            MapDataUtil.setAllDataInvalid(converRule.getLong("id"));
        }
        long lastUpdateCountTime = System.currentTimeMillis();
        int execCount = 0;
        progress.refresh(totalCount, execCount);
        for (DynamicObject sourceData : sourceDataCollection) {
            SignalManager.checkCancelSignal();
            ++execCount;
            mapCount = MapDataUtil.handleEachSourceData(converRule, targetOidMap, targetNumberMap, targetNameMap, existsMappingMap, mapCount, sourceData);
            if (System.currentTimeMillis() - lastUpdateCountTime >= 5000L) {
                SynDataUtil.updateExecCount(log, execCount);
                lastUpdateCountTime = System.currentTimeMillis();
            }
            progress.refresh(totalCount, execCount);
        }
        log.set("exec_count", (Object)execCount);
        if (mapCount < totalCount) {
            message = String.format(ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u6570\u636e\u6709%1$s\u6761\uff0c\u6ca1\u6709\u5339\u914d\u4e0a\u7684\u6570\u636e\u6709%2$s\u6761\uff0c\u8bf7\u5230\u503c\u6620\u5c04\u6570\u636e\u754c\u9762\u624b\u52a8\u5339\u914d,\u503c\u6620\u5c04\u65b9\u6848\u4e3a:%3$s", (String)"MapDataUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), totalCount, totalCount - mapCount, converRule.getString(FIELD_NAME));
            logger.info(message);
            log.set("message", (Object)message);
        } else {
            message = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5339\u914d\u4e86%1$s\u6761\u6570\u636e,\u503c\u6620\u5c04\u65b9\u6848\u4e3a:%2$s", (String)"MapDataUtil_7", (String)"isc-iscb-platform-core", (Object[])new Object[0]), totalCount, converRule.getString(FIELD_NAME));
            logger.info(message);
            log.set("message", (Object)message);
        }
    }

    public static void syncBaseData(Object selectedId) {
        DynamicObject converRule = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"isc_value_conver_rule");
        MapDataUtil.startSynData(converRule.getLong("source_data_schema_id"));
        MapDataUtil.startSynData(converRule.getLong("target_data_schema_id"));
    }

    private static void startSynData(long dataSchemaId) {
        QFilter qFilter = new QFilter(FIELD_DATA_SCHEMA, "=", (Object)dataSchemaId);
        DynamicObject baseSchema = BusinessDataServiceHelper.loadSingle((String)ENTITY_ISC_BASE_SCHEMA, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (baseSchema == null) {
            baseSchema = MapDataUtil.createBaseSchemaIfNotExists(dataSchemaId);
        }
        SynDataUtil.startSynData(D.l((Object)baseSchema.getPkValue()), baseSchema.getString(FIELD_NUMBER));
    }

    public static DynamicObject createBaseSchemaIfNotExists(long data_schema_id) {
        QFilter qFilter = new QFilter(FIELD_DATA_SCHEMA, "=", (Object)data_schema_id);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)ENTITY_ISC_BASE_SCHEMA, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (obj == null) {
            DynamicObject data_schema = BusinessDataServiceHelper.loadSingle((Object)data_schema_id, (String)"isc_metadata_schema");
            return MapDataUtil.createBaseSchema(data_schema);
        }
        return obj;
    }

    private static DynamicObject createBaseSchema(DynamicObject data_schema) {
        DynamicObject newObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_BASE_SCHEMA);
        newObject.set(FIELD_DATA_SCHEMA, data_schema.get("id"));
        DynamicObject group = data_schema.getDynamicObject("group");
        newObject.set("data_source", (Object)group.getLong("id"));
        newObject.set(FIELD_NUMBER, data_schema.get(FIELD_NUMBER));
        newObject.set(FIELD_NAME, (Object)(group.get(FIELD_NAME) + "-" + data_schema.get(FIELD_NAME)));
        DynamicObjectCollection props = data_schema.getDynamicObjectCollection("prop_entryentity");
        int count = 0;
        if ("ENTITY".equals(data_schema.getString("type"))) {
            for (DynamicObject prop : props) {
                String prop_name = prop.getString("prop_name");
                String number_field = newObject.getString("number_field");
                String name_field = newObject.getString("name_field");
                if (MapDataUtil.existNumber(prop_name) && (number_field == null || !number_field.equals(FIELD_NUMBER))) {
                    newObject.set("number_field", (Object)prop_name);
                    ++count;
                } else if (MapDataUtil.existName(prop_name) && (name_field == null || !name_field.equals(FIELD_NAME))) {
                    newObject.set("name_field", (Object)prop_name);
                    ++count;
                }
                if (count != 2) continue;
                break;
            }
        }
        newObject.set(FIELD_ENABLE, (Object)"1");
        newObject.set(FIELD_STATUS, (Object)"C");
        newObject.set(FIELD_CREATETIME, (Object)new Timestamp(System.currentTimeMillis()));
        newObject.set(FIELD_MODIFYTIME, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObject});
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setAllDataInvalid(long ruleId) {
        String sql = "update t_isc_mapping_data set fenable = ? where fmapping_rule = ? ";
        Connection cn = null;
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            List<Object> values = Arrays.asList("0", ruleId);
            List<Integer> types = Arrays.asList(12, -5);
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)true);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)true);
    }

    private static void initMap(DynamicObjectCollection targetDataCollection, Map<String, DynamicObject> targetOidMap, Map<String, DynamicObject> targetNumberMap, Map<String, DynamicObject> targetNameMap) {
        for (DynamicObject targetData : targetDataCollection) {
            String oid = targetData.getString(FIELD_OID);
            String number = targetData.getString(FIELD_NUMBER);
            String name = targetData.getString(FIELD_NAME);
            if (StringUtils.isNotEmpty((String)oid)) {
                targetOidMap.put(oid, targetData);
            }
            if (StringUtils.isNotEmpty((String)number)) {
                targetNumberMap.put(number, targetData);
            }
            if (!StringUtils.isNotEmpty((String)name)) continue;
            targetNameMap.put(name, targetData);
        }
    }

    private static int handleEachSourceData(DynamicObject converRule, Map<String, DynamicObject> targetOidMap, Map<String, DynamicObject> targetNumberMap, Map<String, DynamicObject> targetNameMap, Map<String, Long> existsMappingMap, int mapCount, DynamicObject sourceData) {
        String oid = sourceData.getString(FIELD_OID);
        mapCount = existsMappingMap.containsKey(oid) ? MapDataUtil.updateOldMapData(converRule, targetOidMap, targetNumberMap, targetNameMap, existsMappingMap, mapCount, sourceData, oid) : MapDataUtil.insertNewMapData(converRule, targetNumberMap, targetNameMap, mapCount, sourceData);
        return mapCount;
    }

    private static int insertNewMapData(DynamicObject converRule, Map<String, DynamicObject> targetNumberMap, Map<String, DynamicObject> targetNameMap, int mapCount, DynamicObject sourceData) {
        DynamicObject newMappingData = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ISC_MAPPING_DATA);
        newMappingData.set("mapping_rule", (Object)converRule.getLong("id"));
        newMappingData.set("source_id", sourceData.get(FIELD_OID));
        newMappingData.set("source_number", sourceData.get(FIELD_NUMBER));
        newMappingData.set("source_name", (Object)StringUtil.trim((Object)sourceData.get(FIELD_NAME), (int)100));
        DynamicObject targetData = MapDataUtil.mapTargetData(targetNumberMap, targetNameMap, sourceData, converRule.getBoolean("isfuzzymatch"));
        if (targetData != null) {
            MapDataUtil.setTargetInfo(newMappingData, targetData);
            ++mapCount;
        }
        String s = D.s((Object)converRule.getLong("id")) + sourceData.get(FIELD_OID);
        newMappingData.set(FIELD_NUMBER, (Object)Hash.mur64((byte[])s.getBytes(StandardCharsets.UTF_8)));
        newMappingData.set(FIELD_CREATETIME, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newMappingData});
        return mapCount;
    }

    private static int updateOldMapData(DynamicObject converRule, Map<String, DynamicObject> targetOidMap, Map<String, DynamicObject> targetNumberMap, Map<String, DynamicObject> targetNameMap, Map<String, Long> existsMappingMap, int mapCount, DynamicObject sourceData, String oid) {
        Long exsitsId = existsMappingMap.get(oid);
        DynamicObject oldData = BusinessDataServiceHelper.loadSingle((Object)exsitsId, (String)ENTITY_ISC_MAPPING_DATA);
        oldData.set("source_number", (Object)sourceData.getString(FIELD_NUMBER));
        oldData.set("source_name", (Object)StringUtil.trim((String)sourceData.getString(FIELD_NAME), (int)100));
        String target_id = oldData.getString("target_id");
        if (StringUtils.isNotEmpty((String)target_id)) {
            DynamicObject oldTargetData = targetOidMap.get(target_id);
            if (oldTargetData != null) {
                oldData.set("target_number", (Object)oldTargetData.getString(FIELD_NUMBER));
                oldData.set("target_name", (Object)StringUtil.trim((String)oldTargetData.getString(FIELD_NAME), (int)100));
                oldData.set(FIELD_ENABLE, (Object)"1");
                oldData.set(FIELD_MODIFYTIME, (Object)new Timestamp(System.currentTimeMillis()));
                ++mapCount;
            }
        } else {
            DynamicObject targetData = MapDataUtil.mapTargetData(targetNumberMap, targetNameMap, sourceData, converRule.getBoolean("isfuzzymatch"));
            if (targetData != null) {
                MapDataUtil.setTargetInfo(oldData, targetData);
                ++mapCount;
            }
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_ISC_MAPPING_DATA);
        SaveServiceHelper.save((IDataEntityType)dataEntityType, (Object[])new DynamicObject[]{oldData});
        return mapCount;
    }

    private static Map<String, Long> getExistsMappingMap(long id) {
        HashMap<String, Long> existsMappingMap = new HashMap<String, Long>();
        QFilter ruleFilter = new QFilter("mapping_rule", "=", (Object)id);
        DynamicObjectCollection sourceIdCollection = QueryServiceHelper.query((String)ENTITY_ISC_MAPPING_DATA, (String)"id,source_id", (QFilter[])new QFilter[]{ruleFilter});
        for (DynamicObject dynamicObject : sourceIdCollection) {
            existsMappingMap.put(dynamicObject.getString("source_id"), dynamicObject.getLong("id"));
        }
        return existsMappingMap;
    }

    private static DynamicObjectCollection getDataCollection(DynamicObject data_schema) {
        QFilter sourceFilter = new QFilter("dataschema", "=", (Object)data_schema.getLong("id"));
        return QueryServiceHelper.query((String)"isc_basic_data", (String)"id,oid,number,name", (QFilter[])new QFilter[]{sourceFilter});
    }

    private static void setTargetInfo(DynamicObject newMappingData, DynamicObject targetData) {
        newMappingData.set("target_data", (Object)targetData.getString("id"));
        newMappingData.set("target_id", (Object)targetData.getString(FIELD_OID));
        newMappingData.set("target_number", (Object)targetData.getString(FIELD_NUMBER));
        newMappingData.set("target_name", (Object)StringUtil.trim((String)targetData.getString(FIELD_NAME), (int)100));
        newMappingData.set(FIELD_ENABLE, (Object)"1");
        newMappingData.set(FIELD_MODIFYTIME, (Object)new Timestamp(System.currentTimeMillis()));
    }

    private static DynamicObject mapTargetData(Map<String, DynamicObject> targetNumberMap, Map<String, DynamicObject> targetNameMap, DynamicObject sourceData, boolean isfuzzymatch) {
        DynamicObject targetData = targetNumberMap.get(sourceData.getString(FIELD_NUMBER));
        if (targetData == null) {
            targetData = targetNameMap.get(sourceData.getString(FIELD_NAME));
        }
        if (targetData == null && isfuzzymatch) {
            for (Map.Entry<String, DynamicObject> entry : targetNameMap.entrySet()) {
                String targetName = entry.getKey();
                String sourceName = sourceData.getString(FIELD_NAME);
                if (targetName == null || sourceName == null || !targetName.contains(sourceName) && !sourceName.contains(targetName)) continue;
                return entry.getValue();
            }
        }
        return targetData;
    }

    public static Object findMappingValue(long ruleId, String value) {
        DynamicObject cfg = ValueConversionRuleConfig.getById(ruleId);
        return MapDataUtil.findMappingValue(value, cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object findMappingValue(String value, DynamicObject cfg) {
        Object object;
        ConnectionWrapper src = null;
        ConnectionWrapper tar = null;
        try {
            src = MapDataUtil.getConnection(cfg, "source_data_source_id");
            tar = MapDataUtil.getConnection(cfg, "target_data_source_id");
            ValueConversionRule rule = ValueConversionRuleFactory.getRule(cfg, src, tar);
            object = ValueConversionRuleFactory.run(null, rule, value);
        }
        catch (Throwable throwable) {
            ConnectorUtil.close(src);
            ConnectorUtil.close(tar);
            throw throwable;
        }
        ConnectorUtil.close(src);
        ConnectorUtil.close(tar);
        return object;
    }

    private static ConnectionWrapper getConnection(DynamicObject cfg, String field) {
        long dataSourceId = cfg.getLong(field);
        DataSource dataSource = DataSource.get(dataSourceId);
        return ConnectionManager.getConnection(dataSource.getDbLink());
    }

    static {
        numberList.add(FIELD_NUMBER);
        numberList.add("Number");
        numberList.add("FNumber");
        numberList.add("Fnumber");
        numberList.add("fnumber");
        numberList.add("FBillNo");
        numberList.add("billno");
        numberList.add("FNUMBER");
        nameList.add(FIELD_NAME);
        nameList.add("Name");
        nameList.add("FName");
        nameList.add("Fname");
        nameList.add("fname");
    }
}

