/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.syndata;

import java.sql.Timestamp;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.syndata.AbstractSynData;
import kd.isc.iscb.platform.core.syndata.EntitySynData;
import kd.isc.iscb.platform.core.syndata.EnumSynData;
import kd.isc.iscb.platform.core.syndata.ProgressCache;
import kd.isc.iscb.platform.core.syndata.SyncDataJob;
import kd.isc.iscb.platform.core.syndata.TableSynData;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class SynDataUtil {
    private static final String FIELD_CREATE_TIME = "create_time";
    private static final String FIELD_TOTAL_COUNT = "total_count";
    private static final String FIELD_MODIFY_TIME = "modify_time";
    private static final String FIELD_EXEC_COUNT = "exec_count";
    private static final String ENTITY_ISC_BASE_SCHEMA = "isc_base_schema";

    public static void startSynData(long id) {
        DynamicObject baseSchema = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_ISC_BASE_SCHEMA);
        String number = baseSchema.getString("number");
        SynDataUtil.startSynData(id, number);
    }

    public static void startSynData(long id, String number) {
        SynDataUtil.beforeSubmit(id);
        try {
            String title = String.format(ResManager.loadKDString((String)"\u53c2\u7167\u6570\u636e\u65b9\u6848\uff1a%s", (String)"SynDataUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number);
            JobEngine.submit(new SyncDataJob(id, title));
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    public static Job createSynJob(long id, String number) {
        SynDataUtil.beforeSubmit(id);
        String title = String.format(ResManager.loadKDString((String)"\u53c2\u7167\u6570\u636e\u65b9\u6848\uff1a%s", (String)"SynDataUtil_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), number);
        return new SyncDataJob(id, title);
    }

    public static void beforeSubmit(long id) {
        DynamicObject baseSchema = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_ISC_BASE_SCHEMA, (String)"id,number,number_field,name_field,data_schema");
        DynamicObject metaSchema = BusinessDataServiceHelper.loadSingle((Object)baseSchema.get("data_schema_id"), (String)"isc_metadata_schema", (String)"id,type");
        if (!"ENUM".equals(metaSchema.getString("type")) && (StringUtil.isEmpty((String)baseSchema.getString("number_field")) || StringUtil.isEmpty((String)baseSchema.getString("name_field")))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u7167\u6570\u636e\u65b9\u6848(number = %s)\u7f16\u7801\u5b57\u6bb5\u6216\u540d\u79f0\u5b57\u6bb5\u672a\u586b\u5199\u3002", (String)"SynDataUtil_5", (String)"isc-iscb-platform-core", (Object[])new Object[0]), baseSchema.getString("number")));
        }
    }

    public static void executeSyncData(long id, ProgressCache progress) {
        DynamicObject baseSchema = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_ISC_BASE_SCHEMA);
        long dataSchemaId = baseSchema.getLong("data_schema_id");
        DynamicObject dataSchema = BusinessDataServiceHelper.loadSingle((Object)dataSchemaId, (String)"isc_metadata_schema");
        String type = dataSchema.getString("type");
        AbstractSynData synData = SynDataUtil.getSynData(type, baseSchema);
        synData.invoke(progress);
    }

    public static AbstractSynData getSynData(String type, DynamicObject baseSchema) {
        if ("TABLE".equals(type)) {
            return new TableSynData(baseSchema);
        }
        if ("ENTITY".equals(type)) {
            return new EntitySynData(baseSchema);
        }
        if ("ENUM".equals(type)) {
            return new EnumSynData(baseSchema);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5143\u6570\u636e\u7c7b\u578b,type : %s", (String)"SynDataUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
    }

    public static AbstractSynData getSynDataWithoutLog(String type, DynamicObject baseSchema) {
        if ("TABLE".equals(type)) {
            return new TableSynData(baseSchema, false);
        }
        if ("ENTITY".equals(type)) {
            return new EntitySynData(baseSchema, false);
        }
        if ("ENUM".equals(type)) {
            return new EnumSynData(baseSchema, false);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5143\u6570\u636e\u7c7b\u578b,type : %s", (String)"SynDataUtil_6", (String)"isc-iscb-platform-core", (Object[])new Object[0]), type));
    }

    public static DynamicObject initLog(long id, String type) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"isc_sync_data_log");
        if (ENTITY_ISC_BASE_SCHEMA.equals(type)) {
            log.set("base_schema_id", (Object)id);
        } else if ("mapping_rule".equals(type)) {
            log.set("mapping_rule_id", (Object)id);
        }
        log.set("status", (Object)"0");
        log.set(FIELD_TOTAL_COUNT, (Object)-1);
        log.set(FIELD_EXEC_COUNT, (Object)-1);
        log.set(FIELD_CREATE_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        log.set(FIELD_MODIFY_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        return log;
    }

    public static void updateStatus(DynamicObject log, String status) {
        log.set("status", (Object)status);
        log.set(FIELD_MODIFY_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static void updateTotalCount(DynamicObject log, long totalCount, long execCount) {
        log.set(FIELD_TOTAL_COUNT, (Object)totalCount);
        log.set(FIELD_EXEC_COUNT, (Object)execCount);
        log.set(FIELD_MODIFY_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    public static void updateExecCount(DynamicObject log, long execCount) {
        log.set(FIELD_EXEC_COUNT, (Object)execCount);
        log.set(FIELD_MODIFY_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }
}

