/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.syndata;

import java.sql.SQLException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.syndata.MapDataJob;
import kd.isc.iscb.platform.core.syndata.MapDataUtil;
import kd.isc.iscb.platform.core.syndata.ProgressCache;
import kd.isc.iscb.platform.core.syndata.SynDataUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class SyncBaseDataTask {
    private static Log logger = LogFactory.getLog(SyncBaseDataTask.class);

    public static Job createMapJob(long id) {
        DynamicObject converRule = SyncBaseDataTask.getAndCheck(id);
        String title = String.format(ResManager.loadKDString((String)"\u6267\u884c\u81ea\u52a8\u6620\u5c04\uff1a\u503c\u8f6c\u6362\u89c4\u5219(%s)", (String)"SyncBaseDataTask_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), converRule.getString("number"));
        return new MapDataJob(id, title);
    }

    public static void autoMapData(long id) throws SQLException {
        DynamicObject converRule = SyncBaseDataTask.getAndCheck(id);
        String title = String.format(ResManager.loadKDString((String)"\u6267\u884c\u81ea\u52a8\u6620\u5c04\uff1a\u503c\u8f6c\u6362\u89c4\u5219(%s)", (String)"SyncBaseDataTask_3", (String)"isc-iscb-platform-core", (Object[])new Object[0]), converRule.getString("number"));
        MapDataJob job = new MapDataJob(id, title);
        JobEngine.submit(job);
    }

    public static DynamicObject getAndCheck(long id) {
        DynamicObject converRule = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_value_conver_rule");
        QFilter qFilter = new QFilter("mapping_rule", "=", (Object)id);
        qFilter.and("status", "in", (Object)new String[]{"0", "1"});
        DynamicObject lastlog = BusinessDataServiceHelper.loadSingle((String)"isc_sync_data_log", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (lastlog != null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d\u4efb\u52a1[%s]\u5df2\u7ecf\u5728\u6267\u884c\u4e2d", (String)"SyncBaseDataTask_4", (String)"isc-iscb-platform-core", (Object[])new Object[0]), converRule.getString("name")));
        }
        return converRule;
    }

    public static void doAutoMapping(DynamicObject converRule, ProgressCache progress) {
        DynamicObject log = SynDataUtil.initLog(converRule.getLong("id"), "mapping_rule");
        try {
            SynDataUtil.updateStatus(log, "1");
            MapDataUtil.autoMapData(converRule, log, progress);
            SynDataUtil.updateStatus(log, "2");
        }
        catch (Exception e) {
            logger.warn("\u5339\u914d\u503c\u8f6c\u6362\u6570\u636e\u51fa\u9519\uff1a", (Throwable)e);
            String s = StringUtil.toString((Throwable)e);
            log.set("message", (Object)SyncBaseDataTask.trim(s));
            log.set("message_tag", (Object)s);
            SynDataUtil.updateStatus(log, "3");
            progress.setErr(e);
            throw D.e((Throwable)e);
        }
    }

    private static String trim(String s) {
        if (s != null && s.length() > 200) {
            s = s.substring(0, 200);
        }
        return s;
    }
}

