/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.util.SystemProperties;
import kd.isc.iscb.platform.core.task.MutexTask;
import kd.isc.iscb.platform.core.task.TaskWorker;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.trace.TraceItem;

public class MutexTaskManager {
    private static final TaskWorker queue;

    public static int getQueueSize() {
        return queue.getQueueSize();
    }

    public static Set<String> getBusyAccounts() {
        return queue.getBusyAccounts();
    }

    public static void submit(MutexTask task) {
        queue.submit(task);
    }

    public static void submit(MutexTask task, RequestContext ctx) {
        queue.submit(task, ctx);
    }

    static void submit(MutexTask task, TraceItem current, RequestContext ctx) {
        queue.submit(task, current, ctx);
    }

    public static int tasksBefore(String taskId) {
        return queue.tasksBefore(taskId);
    }

    static {
        int count;
        try {
            count = D.i((Object)SystemProperties.getWithEnv((String)"ISC_MUTEX_TASK_THREADS"));
            if (count <= 0) {
                count = 10;
            }
        }
        catch (Exception e) {
            count = 10;
        }
        queue = new TaskWorker("ISC_MUTEX_TASK", Math.max(3, count));
    }
}

